/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.media.Image;
import android.media.ImageReader;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.AndroidImageProxy;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.utils.MainThreadAsyncHandler;
import java.util.concurrent.Executor;

final class AndroidImageReaderProxy
implements ImageReaderProxy {
    @GuardedBy(value="this")
    private final ImageReader mImageReader;

    AndroidImageReaderProxy(ImageReader imageReader) {
        this.mImageReader = imageReader;
    }

    @Override
    @Nullable
    public synchronized ImageProxy acquireLatestImage() {
        Image image;
        try {
            image = this.mImageReader.acquireLatestImage();
        }
        catch (RuntimeException e) {
            if (this.isImageReaderContextNotInitializedException(e)) {
                image = null;
            }
            throw e;
        }
        if (image == null) {
            return null;
        }
        return new AndroidImageProxy(image);
    }

    @Override
    @Nullable
    public synchronized ImageProxy acquireNextImage() {
        Image image;
        try {
            image = this.mImageReader.acquireNextImage();
        }
        catch (RuntimeException e) {
            if (this.isImageReaderContextNotInitializedException(e)) {
                image = null;
            }
            throw e;
        }
        if (image == null) {
            return null;
        }
        return new AndroidImageProxy(image);
    }

    private boolean isImageReaderContextNotInitializedException(RuntimeException e) {
        return "ImageReaderContext is not initialized".equals(e.getMessage());
    }

    @Override
    public synchronized void close() {
        this.mImageReader.close();
    }

    @Override
    public synchronized int getHeight() {
        return this.mImageReader.getHeight();
    }

    @Override
    public synchronized int getWidth() {
        return this.mImageReader.getWidth();
    }

    @Override
    public synchronized int getImageFormat() {
        return this.mImageReader.getImageFormat();
    }

    @Override
    public synchronized int getMaxImages() {
        return this.mImageReader.getMaxImages();
    }

    @Override
    @NonNull
    public synchronized Surface getSurface() {
        return this.mImageReader.getSurface();
    }

    @Override
    public synchronized void setOnImageAvailableListener(final @NonNull ImageReaderProxy.OnImageAvailableListener listener, final @NonNull Executor executor) {
        ImageReader.OnImageAvailableListener transformedListener = new ImageReader.OnImageAvailableListener(){

            public void onImageAvailable(ImageReader reader) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onImageAvailable(AndroidImageReaderProxy.this);
                    }
                });
            }
        };
        this.mImageReader.setOnImageAvailableListener(transformedListener, MainThreadAsyncHandler.getInstance());
    }
}

