/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.SessionConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class UseCaseAttachState {
    private static final String TAG = "UseCaseAttachState";
    private final String mCameraId;
    private final Map<UseCase, UseCaseAttachInfo> mAttachedUseCasesToInfoMap = new HashMap<UseCase, UseCaseAttachInfo>();

    public UseCaseAttachState(@NonNull String cameraId) {
        this.mCameraId = cameraId;
    }

    public void setUseCaseActive(@NonNull UseCase useCase) {
        UseCaseAttachInfo useCaseAttachInfo = this.getOrCreateUseCaseAttachInfo(useCase);
        useCaseAttachInfo.setActive(true);
    }

    public void setUseCaseInactive(@NonNull UseCase useCase) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCase)) {
            return;
        }
        UseCaseAttachInfo useCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCase);
        useCaseAttachInfo.setActive(false);
        if (!useCaseAttachInfo.getOnline()) {
            this.mAttachedUseCasesToInfoMap.remove(useCase);
        }
    }

    public void setUseCaseOnline(@NonNull UseCase useCase) {
        UseCaseAttachInfo useCaseAttachInfo = this.getOrCreateUseCaseAttachInfo(useCase);
        useCaseAttachInfo.setOnline(true);
    }

    public void setUseCaseOffline(@NonNull UseCase useCase) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCase)) {
            return;
        }
        UseCaseAttachInfo useCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCase);
        useCaseAttachInfo.setOnline(false);
        if (!useCaseAttachInfo.getActive()) {
            this.mAttachedUseCasesToInfoMap.remove(useCase);
        }
    }

    public boolean isUseCaseOnline(@NonNull UseCase useCase) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCase)) {
            return false;
        }
        UseCaseAttachInfo useCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCase);
        return useCaseAttachInfo.getOnline();
    }

    @NonNull
    public Collection<UseCase> getOnlineUseCases() {
        return Collections.unmodifiableCollection(this.getUseCases(new AttachStateFilter(){

            @Override
            public boolean filter(UseCaseAttachInfo useCaseAttachInfo) {
                return useCaseAttachInfo.getOnline();
            }
        }));
    }

    @NonNull
    public Collection<UseCase> getActiveAndOnlineUseCases() {
        return Collections.unmodifiableCollection(this.getUseCases(new AttachStateFilter(){

            @Override
            public boolean filter(UseCaseAttachInfo useCaseAttachInfo) {
                return useCaseAttachInfo.getActive() && useCaseAttachInfo.getOnline();
            }
        }));
    }

    public void updateUseCase(@NonNull UseCase useCase) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCase)) {
            return;
        }
        UseCaseAttachInfo newUseCaseAttachInfo = new UseCaseAttachInfo(useCase.getSessionConfig(this.mCameraId));
        UseCaseAttachInfo oldUseCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCase);
        newUseCaseAttachInfo.setOnline(oldUseCaseAttachInfo.getOnline());
        newUseCaseAttachInfo.setActive(oldUseCaseAttachInfo.getActive());
        this.mAttachedUseCasesToInfoMap.put(useCase, newUseCaseAttachInfo);
    }

    @NonNull
    public SessionConfig.ValidatingBuilder getActiveAndOnlineBuilder() {
        SessionConfig.ValidatingBuilder validatingBuilder = new SessionConfig.ValidatingBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<UseCase, UseCaseAttachInfo> attachedUseCase : this.mAttachedUseCasesToInfoMap.entrySet()) {
            UseCaseAttachInfo useCaseAttachInfo = attachedUseCase.getValue();
            if (!useCaseAttachInfo.getActive() || !useCaseAttachInfo.getOnline()) continue;
            UseCase useCase = attachedUseCase.getKey();
            validatingBuilder.add(useCaseAttachInfo.getSessionConfig());
            list.add(useCase.getName());
        }
        Log.d((String)TAG, (String)("Active and online use case: " + list + " for camera: " + this.mCameraId));
        return validatingBuilder;
    }

    @NonNull
    public SessionConfig.ValidatingBuilder getOnlineBuilder() {
        SessionConfig.ValidatingBuilder validatingBuilder = new SessionConfig.ValidatingBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<UseCase, UseCaseAttachInfo> attachedUseCase : this.mAttachedUseCasesToInfoMap.entrySet()) {
            UseCaseAttachInfo useCaseAttachInfo = attachedUseCase.getValue();
            if (!useCaseAttachInfo.getOnline()) continue;
            validatingBuilder.add(useCaseAttachInfo.getSessionConfig());
            UseCase useCase = attachedUseCase.getKey();
            list.add(useCase.getName());
        }
        Log.d((String)TAG, (String)("All use case: " + list + " for camera: " + this.mCameraId));
        return validatingBuilder;
    }

    @NonNull
    public SessionConfig getUseCaseSessionConfig(@NonNull UseCase useCase) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCase)) {
            return SessionConfig.defaultEmptySessionConfig();
        }
        UseCaseAttachInfo attachInfo = this.mAttachedUseCasesToInfoMap.get(useCase);
        return attachInfo.getSessionConfig();
    }

    private UseCaseAttachInfo getOrCreateUseCaseAttachInfo(UseCase useCase) {
        UseCaseAttachInfo useCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCase);
        if (useCaseAttachInfo == null) {
            useCaseAttachInfo = new UseCaseAttachInfo(useCase.getSessionConfig(this.mCameraId));
            this.mAttachedUseCasesToInfoMap.put(useCase, useCaseAttachInfo);
        }
        return useCaseAttachInfo;
    }

    private Collection<UseCase> getUseCases(AttachStateFilter attachStateFilter) {
        ArrayList<UseCase> useCases = new ArrayList<UseCase>();
        for (Map.Entry<UseCase, UseCaseAttachInfo> attachedUseCase : this.mAttachedUseCasesToInfoMap.entrySet()) {
            if (attachStateFilter != null && !attachStateFilter.filter(attachedUseCase.getValue())) continue;
            useCases.add(attachedUseCase.getKey());
        }
        return useCases;
    }

    private static final class UseCaseAttachInfo {
        private final SessionConfig mSessionConfig;
        private boolean mOnline = false;
        private boolean mActive = false;

        UseCaseAttachInfo(SessionConfig sessionConfig) {
            this.mSessionConfig = sessionConfig;
        }

        SessionConfig getSessionConfig() {
            return this.mSessionConfig;
        }

        boolean getOnline() {
            return this.mOnline;
        }

        void setOnline(boolean online) {
            this.mOnline = online;
        }

        boolean getActive() {
            return this.mActive;
        }

        void setActive(boolean active) {
            this.mActive = active;
        }
    }

    private static interface AttachStateFilter {
        public boolean filter(UseCaseAttachInfo var1);
    }
}

