/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.Config;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class OptionsBundle
implements Config {
    private static final OptionsBundle EMPTY_BUNDLE = new OptionsBundle(new TreeMap(new Comparator<Config.Option<?>>(){

        @Override
        public int compare(Config.Option<?> o1, Config.Option<?> o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }));
    protected final TreeMap<Config.Option<?>, Object> mOptions;

    OptionsBundle(TreeMap<Config.Option<?>, Object> options) {
        this.mOptions = options;
    }

    @NonNull
    public static OptionsBundle from(@NonNull Config otherConfig) {
        if (OptionsBundle.class.equals(otherConfig.getClass())) {
            return (OptionsBundle)otherConfig;
        }
        TreeMap persistentOptions = new TreeMap(new Comparator<Config.Option<?>>(){

            @Override
            public int compare(Config.Option<?> o1, Config.Option<?> o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        for (Config.Option<?> opt : otherConfig.listOptions()) {
            persistentOptions.put(opt, otherConfig.retrieveOption(opt));
        }
        return new OptionsBundle(persistentOptions);
    }

    @NonNull
    public static OptionsBundle emptyBundle() {
        return EMPTY_BUNDLE;
    }

    @Override
    @NonNull
    public Set<Config.Option<?>> listOptions() {
        return Collections.unmodifiableSet(this.mOptions.keySet());
    }

    @Override
    public boolean containsOption(@NonNull Config.Option<?> id) {
        return this.mOptions.containsKey(id);
    }

    @Override
    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id) {
        if (!this.mOptions.containsKey(id)) {
            throw new IllegalArgumentException("Option does not exist: " + id);
        }
        Object value = this.mOptions.get(id);
        return (ValueT)value;
    }

    @Override
    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id, @Nullable ValueT valueIfMissing) {
        return (ValueT)(this.mOptions.containsKey(id) ? this.mOptions.get(id) : valueIfMissing);
    }

    @Override
    public void findOptions(@NonNull String idStem, @NonNull Config.OptionMatcher matcher) {
        Config.Option query = Config.Option.create(idStem, Void.class);
        for (Map.Entry entry : this.mOptions.tailMap(query).entrySet()) {
            Config.Option option;
            if (!entry.getKey().getId().startsWith(idStem) || !matcher.onOptionMatched(option = entry.getKey())) break;
        }
    }
}

