/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Log;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class DeferrableSurface {
    private static final boolean DEBUG = false;
    protected static final String TAG = "DeferrableSurface";
    private static AtomicInteger sUsedCount = new AtomicInteger(0);
    private static AtomicInteger sTotalCount = new AtomicInteger(0);
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private int mUseCount = 0;
    @GuardedBy(value="mLock")
    private boolean mClosed = false;
    @GuardedBy(value="mLock")
    private CallbackToFutureAdapter.Completer<Void> mTerminationCompleter;
    private final ListenableFuture<Void> mTerminationFuture = CallbackToFutureAdapter.getFuture(completer -> {
        Object object = this.mLock;
        synchronized (object) {
            this.mTerminationCompleter = completer;
        }
        return "DeferrableSurface-termination(" + this + ")";
    });

    private void printGlobalDebugCounts(@NonNull String prefix, int totalCount, int useCount) {
        Log.d((String)TAG, (String)(prefix + "[total_surfaces=" + totalCount + ", used_surfaces=" + useCount + "](" + this + "}"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public final ListenableFuture<Surface> getSurface() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return Futures.immediateFailedFuture(new SurfaceClosedException("DeferrableSurface already closed.", this));
            }
            return this.provideSurface();
        }
    }

    @NonNull
    protected abstract ListenableFuture<Surface> provideSurface();

    @NonNull
    public ListenableFuture<Void> getTerminationFuture() {
        return Futures.nonCancellationPropagating(this.mTerminationFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementUseCount() throws SurfaceClosedException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUseCount == 0 && this.mClosed) {
                throw new SurfaceClosedException("Cannot begin use on a closed surface.", this);
            }
            ++this.mUseCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        CallbackToFutureAdapter.Completer<Void> terminationCompleter = null;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mClosed) {
                this.mClosed = true;
                if (this.mUseCount == 0) {
                    terminationCompleter = this.mTerminationCompleter;
                    this.mTerminationCompleter = null;
                }
            }
        }
        if (terminationCompleter != null) {
            terminationCompleter.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementUseCount() {
        CallbackToFutureAdapter.Completer<Void> terminationCompleter = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUseCount == 0) {
                throw new IllegalStateException("Decrementing use count occurs more times than incrementing");
            }
            --this.mUseCount;
            if (this.mUseCount == 0 && this.mClosed) {
                terminationCompleter = this.mTerminationCompleter;
                this.mTerminationCompleter = null;
            }
        }
        if (terminationCompleter != null) {
            terminationCompleter.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    public int getUseCount() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUseCount;
        }
    }

    private /* synthetic */ void lambda$new$1(String creationStackTrace) {
        try {
            this.mTerminationFuture.get();
            this.printGlobalDebugCounts("Surface terminated", sTotalCount.decrementAndGet(), sUsedCount.get());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Unexpected surface termination for " + this + "\nStack Trace:\n" + creationStackTrace));
            throw new IllegalArgumentException("DeferrableSurface terminated with unexpected exception.", e);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class SurfaceClosedException
    extends Exception {
        DeferrableSurface mDeferrableSurface;

        public SurfaceClosedException(@NonNull String s, @NonNull DeferrableSurface surface) {
            super(s);
            this.mDeferrableSurface = surface;
        }

        @NonNull
        public DeferrableSurface getDeferrableSurface() {
            return this.mDeferrableSurface;
        }
    }

    public static final class SurfaceUnavailableException
    extends Exception {
        public SurfaceUnavailableException(@NonNull String message) {
            super(message);
        }
    }
}

