/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.location.Location;
import android.media.AudioRecord;
import android.media.CamcorderProfile;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraX;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.VideoCaptureConfig;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.utils.UseCaseConfigUtil;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class VideoCapture
extends UseCase {
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_ENCODER = 1;
    public static final int ERROR_MUXER = 2;
    public static final int ERROR_RECORDING_IN_PROGRESS = 3;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Defaults DEFAULT_CONFIG = new Defaults();
    private static final Metadata EMPTY_METADATA = new Metadata();
    private static final String TAG = "VideoCapture";
    private static final int DEQUE_TIMEOUT_USEC = 10000;
    private static final String VIDEO_MIME_TYPE = "video/avc";
    private static final String AUDIO_MIME_TYPE = "audio/mp4a-latm";
    private static final int[] CamcorderQuality = new int[]{8, 6, 5, 4};
    private static final short[] sAudioEncoding = new short[]{2, 3, 4};
    private final MediaCodec.BufferInfo mVideoBufferInfo = new MediaCodec.BufferInfo();
    private final Object mMuxerLock = new Object();
    private final HandlerThread mVideoHandlerThread = new HandlerThread("CameraX-video encoding thread");
    private final Handler mVideoHandler;
    private final HandlerThread mAudioHandlerThread = new HandlerThread("CameraX-audio encoding thread");
    private final Handler mAudioHandler;
    private final AtomicBoolean mEndOfVideoStreamSignal = new AtomicBoolean(true);
    private final AtomicBoolean mEndOfAudioStreamSignal = new AtomicBoolean(true);
    private final AtomicBoolean mEndOfAudioVideoSignal = new AtomicBoolean(true);
    private final MediaCodec.BufferInfo mAudioBufferInfo = new MediaCodec.BufferInfo();
    private final AtomicBoolean mIsFirstVideoSampleWrite = new AtomicBoolean(false);
    private final AtomicBoolean mIsFirstAudioSampleWrite = new AtomicBoolean(false);
    @NonNull
    MediaCodec mVideoEncoder;
    @NonNull
    private MediaCodec mAudioEncoder;
    @GuardedBy(value="mMuxerLock")
    private MediaMuxer mMuxer;
    private boolean mMuxerStarted = false;
    private int mVideoTrackIndex;
    private int mAudioTrackIndex;
    Surface mCameraSurface;
    @NonNull
    private AudioRecord mAudioRecorder;
    private int mAudioBufferSize;
    private boolean mIsRecording = false;
    private int mAudioChannelCount;
    private int mAudioSampleRate;
    private int mAudioBitRate;
    private DeferrableSurface mDeferrableSurface;

    public VideoCapture(VideoCaptureConfig config) {
        super(config);
        this.mVideoHandlerThread.start();
        this.mVideoHandler = new Handler(this.mVideoHandlerThread.getLooper());
        this.mAudioHandlerThread.start();
        this.mAudioHandler = new Handler(this.mAudioHandlerThread.getLooper());
    }

    private static MediaFormat createMediaFormat(VideoCaptureConfig config, Size resolution) {
        MediaFormat format = MediaFormat.createVideoFormat((String)VIDEO_MIME_TYPE, (int)resolution.getWidth(), (int)resolution.getHeight());
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", config.getBitRate());
        format.setInteger("frame-rate", config.getVideoFrameRate());
        format.setInteger("i-frame-interval", config.getIFrameInterval());
        return format;
    }

    @Override
    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected UseCaseConfig.Builder<?, ?, ?> getDefaultBuilder(@Nullable CameraInfo cameraInfo) {
        VideoCaptureConfig defaults = CameraX.getDefaultUseCaseConfig(VideoCaptureConfig.class, cameraInfo);
        if (defaults != null) {
            return VideoCaptureConfig.Builder.fromConfig(defaults);
        }
        return null;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected Map<String, Size> onSuggestedResolutionUpdated(@NonNull Map<String, Size> suggestedResolutionMap) {
        if (this.mCameraSurface != null) {
            this.mVideoEncoder.stop();
            this.mVideoEncoder.release();
            this.mAudioEncoder.stop();
            this.mAudioEncoder.release();
            this.releaseCameraSurface(false);
        }
        try {
            this.mVideoEncoder = MediaCodec.createEncoderByType((String)VIDEO_MIME_TYPE);
            this.mAudioEncoder = MediaCodec.createEncoderByType((String)AUDIO_MIME_TYPE);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create MediaCodec due to: " + e.getCause());
        }
        String cameraId = this.getBoundCameraId();
        Size resolution = suggestedResolutionMap.get(cameraId);
        if (resolution == null) {
            throw new IllegalArgumentException("Suggested resolution map missing resolution for camera " + cameraId);
        }
        this.setupEncoder(cameraId, resolution);
        return suggestedResolutionMap;
    }

    public void startRecording(@NonNull File saveLocation, @NonNull Executor executor, @NonNull OnVideoSavedCallback callback) {
        this.mIsFirstVideoSampleWrite.set(false);
        this.mIsFirstAudioSampleWrite.set(false);
        this.startRecording(saveLocation, EMPTY_METADATA, executor, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRecording(final @NonNull File saveLocation, @NonNull Metadata metadata, @NonNull Executor executor, @NonNull OnVideoSavedCallback callback) {
        Log.i((String)TAG, (String)"startRecording");
        final VideoSavedListenerWrapper postListener = new VideoSavedListenerWrapper(executor, callback);
        if (!this.mEndOfAudioVideoSignal.get()) {
            postListener.onError(3, "It is still in video recording!", null);
            return;
        }
        try {
            this.mAudioRecorder.startRecording();
        }
        catch (IllegalStateException e) {
            postListener.onError(1, "AudioRecorder start fail", e);
            return;
        }
        CameraInternal boundCamera = this.getBoundCamera();
        final String cameraId = this.getBoundCameraId();
        final Size resolution = this.getAttachedSurfaceResolution(cameraId);
        try {
            Log.i((String)TAG, (String)"videoEncoder start");
            this.mVideoEncoder.start();
            Log.i((String)TAG, (String)"audioEncoder start");
            this.mAudioEncoder.start();
        }
        catch (IllegalStateException e) {
            this.setupEncoder(cameraId, resolution);
            postListener.onError(1, "Audio/Video encoder start fail", e);
            return;
        }
        CameraInfoInternal cameraInfoInternal = boundCamera.getCameraInfoInternal();
        int relativeRotation = cameraInfoInternal.getSensorRotationDegrees(((ImageOutputConfig)((Object)this.getUseCaseConfig())).getTargetRotation(0));
        try {
            Object object = this.mMuxerLock;
            synchronized (object) {
                this.mMuxer = new MediaMuxer(saveLocation.getAbsolutePath(), 0);
                this.mMuxer.setOrientationHint(relativeRotation);
                if (metadata.location != null) {
                    this.mMuxer.setLocation((float)metadata.location.getLatitude(), (float)metadata.location.getLongitude());
                }
            }
        }
        catch (IOException e) {
            this.setupEncoder(cameraId, resolution);
            postListener.onError(2, "MediaMuxer creation failed!", e);
            return;
        }
        this.mEndOfVideoStreamSignal.set(false);
        this.mEndOfAudioStreamSignal.set(false);
        this.mEndOfAudioVideoSignal.set(false);
        this.mIsRecording = true;
        this.notifyActive();
        this.mAudioHandler.post(new Runnable(){

            @Override
            public void run() {
                VideoCapture.this.audioEncode(postListener);
            }
        });
        this.mVideoHandler.post(new Runnable(){

            @Override
            public void run() {
                boolean errorOccurred = VideoCapture.this.videoEncode(postListener, cameraId, resolution);
                if (!errorOccurred) {
                    postListener.onVideoSaved(saveLocation);
                }
            }
        });
    }

    public void stopRecording() {
        Log.i((String)TAG, (String)"stopRecording");
        this.notifyInactive();
        if (!this.mEndOfAudioVideoSignal.get() && this.mIsRecording) {
            this.mEndOfAudioStreamSignal.set(true);
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void clear() {
        this.mVideoHandlerThread.quitSafely();
        this.mAudioHandlerThread.quitSafely();
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.release();
            this.mAudioEncoder = null;
        }
        if (this.mAudioRecorder != null) {
            this.mAudioRecorder.release();
            this.mAudioRecorder = null;
        }
        if (this.mCameraSurface != null) {
            this.releaseCameraSurface(true);
        }
        super.clear();
    }

    private void releaseCameraSurface(boolean releaseVideoEncoder) {
        if (this.mDeferrableSurface == null) {
            return;
        }
        MediaCodec videoEncoder = this.mVideoEncoder;
        this.mDeferrableSurface.close();
        this.mDeferrableSurface.getTerminationFuture().addListener(() -> {
            if (releaseVideoEncoder && videoEncoder != null) {
                videoEncoder.release();
            }
        }, (Executor)CameraXExecutors.mainThreadExecutor());
        if (releaseVideoEncoder) {
            this.mVideoEncoder = null;
        }
        this.mCameraSurface = null;
        this.mDeferrableSurface = null;
    }

    public void setTargetRotation(int rotation) {
        VideoCaptureConfig oldConfig = (VideoCaptureConfig)this.getUseCaseConfig();
        VideoCaptureConfig.Builder builder = VideoCaptureConfig.Builder.fromConfig(oldConfig);
        int oldRotation = oldConfig.getTargetRotation(-1);
        if (oldRotation == -1 || oldRotation != rotation) {
            UseCaseConfigUtil.updateTargetRotationAndRelatedConfigs(builder, rotation);
            this.updateUseCaseConfig(builder.getUseCaseConfig());
        }
    }

    void setupEncoder(final @NonNull String cameraId, final @NonNull Size resolution) {
        Surface cameraSurface;
        VideoCaptureConfig config = (VideoCaptureConfig)this.getUseCaseConfig();
        this.mVideoEncoder.reset();
        this.mVideoEncoder.configure(VideoCapture.createMediaFormat(config, resolution), null, null, 1);
        if (this.mCameraSurface != null) {
            this.releaseCameraSurface(false);
        }
        this.mCameraSurface = cameraSurface = this.mVideoEncoder.createInputSurface();
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.Builder.createFrom(config);
        if (this.mDeferrableSurface != null) {
            this.mDeferrableSurface.close();
        }
        this.mDeferrableSurface = new ImmediateSurface(this.mCameraSurface);
        this.mDeferrableSurface.getTerminationFuture().addListener(() -> ((Surface)cameraSurface).release(), (Executor)CameraXExecutors.mainThreadExecutor());
        sessionConfigBuilder.addSurface(this.mDeferrableSurface);
        sessionConfigBuilder.addErrorListener(new SessionConfig.ErrorListener(){

            @Override
            public void onError(@NonNull SessionConfig sessionConfig, @NonNull SessionConfig.SessionError error) {
                if (VideoCapture.this.isCurrentlyBoundCamera(cameraId)) {
                    VideoCapture.this.setupEncoder(cameraId, resolution);
                }
            }
        });
        this.attachToCamera(cameraId, sessionConfigBuilder.build());
        this.setAudioParametersByCamcorderProfile(resolution, cameraId);
        this.mAudioEncoder.reset();
        this.mAudioEncoder.configure(this.createAudioMediaFormat(), null, null, 1);
        if (this.mAudioRecorder != null) {
            this.mAudioRecorder.release();
        }
        this.mAudioRecorder = this.autoConfigAudioRecordSource(config);
        if (this.mAudioRecorder == null) {
            Log.e((String)TAG, (String)"AudioRecord object cannot initialized correctly!");
        }
        this.mVideoTrackIndex = -1;
        this.mAudioTrackIndex = -1;
        this.mIsRecording = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeVideoEncodedBuffer(int bufferIndex) {
        if (bufferIndex < 0) {
            Log.e((String)TAG, (String)("Output buffer should not have negative index: " + bufferIndex));
            return false;
        }
        ByteBuffer outputBuffer = this.mVideoEncoder.getOutputBuffer(bufferIndex);
        if (outputBuffer == null) {
            Log.d((String)TAG, (String)"OutputBuffer was null.");
            return false;
        }
        if (this.mAudioTrackIndex >= 0 && this.mVideoTrackIndex >= 0 && this.mVideoBufferInfo.size > 0) {
            outputBuffer.position(this.mVideoBufferInfo.offset);
            outputBuffer.limit(this.mVideoBufferInfo.offset + this.mVideoBufferInfo.size);
            this.mVideoBufferInfo.presentationTimeUs = System.nanoTime() / 1000L;
            Object object = this.mMuxerLock;
            synchronized (object) {
                if (!this.mIsFirstVideoSampleWrite.get()) {
                    Log.i((String)TAG, (String)"First video sample written.");
                    this.mIsFirstVideoSampleWrite.set(true);
                }
                this.mMuxer.writeSampleData(this.mVideoTrackIndex, outputBuffer, this.mVideoBufferInfo);
            }
        }
        this.mVideoEncoder.releaseOutputBuffer(bufferIndex, false);
        return (this.mVideoBufferInfo.flags & 4) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeAudioEncodedBuffer(int bufferIndex) {
        ByteBuffer buffer = this.getOutputBuffer(this.mAudioEncoder, bufferIndex);
        buffer.position(this.mAudioBufferInfo.offset);
        if (this.mAudioTrackIndex >= 0 && this.mVideoTrackIndex >= 0 && this.mAudioBufferInfo.size > 0 && this.mAudioBufferInfo.presentationTimeUs > 0L) {
            try {
                Object object = this.mMuxerLock;
                synchronized (object) {
                    if (!this.mIsFirstAudioSampleWrite.get()) {
                        Log.i((String)TAG, (String)"First audio sample written.");
                        this.mIsFirstAudioSampleWrite.set(true);
                    }
                    this.mMuxer.writeSampleData(this.mAudioTrackIndex, buffer, this.mAudioBufferInfo);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("audio error:size=" + this.mAudioBufferInfo.size + "/offset=" + this.mAudioBufferInfo.offset + "/timeUs=" + this.mAudioBufferInfo.presentationTimeUs));
                e.printStackTrace();
            }
        }
        this.mAudioEncoder.releaseOutputBuffer(bufferIndex, false);
        return (this.mAudioBufferInfo.flags & 4) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean videoEncode(@NonNull OnVideoSavedCallback videoSavedCallback, @NonNull String cameraId, @NonNull Size resolution) {
        boolean errorOccurred = false;
        boolean videoEos = false;
        while (!videoEos && !errorOccurred) {
            if (this.mEndOfVideoStreamSignal.get()) {
                this.mVideoEncoder.signalEndOfInputStream();
                this.mEndOfVideoStreamSignal.set(false);
            }
            int outputBufferId = this.mVideoEncoder.dequeueOutputBuffer(this.mVideoBufferInfo, 10000L);
            switch (outputBufferId) {
                case -2: {
                    if (this.mMuxerStarted) {
                        videoSavedCallback.onError(1, "Unexpected change in video encoding format.", null);
                        errorOccurred = true;
                    }
                    Object object = this.mMuxerLock;
                    synchronized (object) {
                        this.mVideoTrackIndex = this.mMuxer.addTrack(this.mVideoEncoder.getOutputFormat());
                        if (this.mAudioTrackIndex >= 0 && this.mVideoTrackIndex >= 0) {
                            this.mMuxerStarted = true;
                            Log.i((String)TAG, (String)"media mMuxer start");
                            this.mMuxer.start();
                        }
                        break;
                    }
                }
                default: {
                    videoEos = this.writeVideoEncodedBuffer(outputBufferId);
                }
            }
        }
        try {
            Log.i((String)TAG, (String)"videoEncoder stop");
            this.mVideoEncoder.stop();
        }
        catch (IllegalStateException e) {
            videoSavedCallback.onError(1, "Video encoder stop failed!", e);
            errorOccurred = true;
        }
        try {
            Object e = this.mMuxerLock;
            synchronized (e) {
                if (this.mMuxer != null) {
                    if (this.mMuxerStarted) {
                        this.mMuxer.stop();
                    }
                    this.mMuxer.release();
                    this.mMuxer = null;
                }
            }
        }
        catch (IllegalStateException e) {
            videoSavedCallback.onError(2, "Muxer stop failed!", e);
            errorOccurred = true;
        }
        this.mMuxerStarted = false;
        this.setupEncoder(cameraId, resolution);
        this.notifyReset();
        this.mEndOfAudioVideoSignal.set(true);
        Log.i((String)TAG, (String)"Video encode thread end.");
        return errorOccurred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean audioEncode(OnVideoSavedCallback videoSavedCallback) {
        boolean audioEos = false;
        while (!audioEos && this.mIsRecording) {
            int outIndex;
            if (this.mEndOfAudioStreamSignal.get()) {
                this.mEndOfAudioStreamSignal.set(false);
                this.mIsRecording = false;
            }
            if (this.mAudioEncoder == null || this.mAudioRecorder == null) continue;
            int index = this.mAudioEncoder.dequeueInputBuffer(-1L);
            if (index >= 0) {
                ByteBuffer buffer = this.getInputBuffer(this.mAudioEncoder, index);
                buffer.clear();
                int length = this.mAudioRecorder.read(buffer, this.mAudioBufferSize);
                if (length > 0) {
                    this.mAudioEncoder.queueInputBuffer(index, 0, length, System.nanoTime() / 1000L, this.mIsRecording ? 0 : 4);
                }
            }
            do {
                outIndex = this.mAudioEncoder.dequeueOutputBuffer(this.mAudioBufferInfo, 0L);
                switch (outIndex) {
                    case -2: {
                        Object object = this.mMuxerLock;
                        synchronized (object) {
                            this.mAudioTrackIndex = this.mMuxer.addTrack(this.mAudioEncoder.getOutputFormat());
                            if (this.mAudioTrackIndex >= 0 && this.mVideoTrackIndex >= 0) {
                                this.mMuxerStarted = true;
                                this.mMuxer.start();
                            }
                            break;
                        }
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        audioEos = this.writeAudioEncodedBuffer(outIndex);
                    }
                }
            } while (outIndex >= 0 && !audioEos);
        }
        try {
            Log.i((String)TAG, (String)"audioRecorder stop");
            this.mAudioRecorder.stop();
        }
        catch (IllegalStateException e) {
            videoSavedCallback.onError(1, "Audio recorder stop failed!", e);
        }
        try {
            this.mAudioEncoder.stop();
        }
        catch (IllegalStateException e) {
            videoSavedCallback.onError(1, "Audio encoder stop failed!", e);
        }
        Log.i((String)TAG, (String)"Audio encode thread end");
        this.mEndOfVideoStreamSignal.set(true);
        return false;
    }

    private ByteBuffer getInputBuffer(MediaCodec codec, int index) {
        return codec.getInputBuffer(index);
    }

    private ByteBuffer getOutputBuffer(MediaCodec codec, int index) {
        return codec.getOutputBuffer(index);
    }

    private MediaFormat createAudioMediaFormat() {
        MediaFormat format = MediaFormat.createAudioFormat((String)AUDIO_MIME_TYPE, (int)this.mAudioSampleRate, (int)this.mAudioChannelCount);
        format.setInteger("aac-profile", 2);
        format.setInteger("bitrate", this.mAudioBitRate);
        return format;
    }

    private AudioRecord autoConfigAudioRecordSource(VideoCaptureConfig config) {
        for (short audioFormat : sAudioEncoding) {
            int channelConfig = this.mAudioChannelCount == 1 ? 16 : 12;
            int source = config.getAudioRecordSource();
            try {
                AudioRecord recorder;
                int bufferSize = AudioRecord.getMinBufferSize((int)this.mAudioSampleRate, (int)channelConfig, (int)audioFormat);
                if (bufferSize <= 0) {
                    bufferSize = config.getAudioMinBufferSize();
                }
                if ((recorder = new AudioRecord(source, this.mAudioSampleRate, channelConfig, (int)audioFormat, bufferSize * 2)).getState() != 1) continue;
                this.mAudioBufferSize = bufferSize;
                Log.i((String)TAG, (String)("source: " + source + " audioSampleRate: " + this.mAudioSampleRate + " channelConfig: " + channelConfig + " audioFormat: " + audioFormat + " bufferSize: " + bufferSize));
                return recorder;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception, keep trying.", (Throwable)e);
            }
        }
        return null;
    }

    private void setAudioParametersByCamcorderProfile(Size currentResolution, String cameraId) {
        boolean isCamcorderProfileFound = false;
        for (int quality : CamcorderQuality) {
            if (!CamcorderProfile.hasProfile((int)Integer.parseInt(cameraId), (int)quality)) continue;
            CamcorderProfile profile = CamcorderProfile.get((int)Integer.parseInt(cameraId), (int)quality);
            if (currentResolution.getWidth() != profile.videoFrameWidth || currentResolution.getHeight() != profile.videoFrameHeight) continue;
            this.mAudioChannelCount = profile.audioChannels;
            this.mAudioSampleRate = profile.audioSampleRate;
            this.mAudioBitRate = profile.audioBitRate;
            isCamcorderProfileFound = true;
            break;
        }
        if (!isCamcorderProfileFound) {
            VideoCaptureConfig config = (VideoCaptureConfig)this.getUseCaseConfig();
            this.mAudioChannelCount = config.getAudioChannelCount();
            this.mAudioSampleRate = config.getAudioSampleRate();
            this.mAudioBitRate = config.getAudioBitRate();
        }
    }

    private final class VideoSavedListenerWrapper
    implements OnVideoSavedCallback {
        @NonNull
        Executor mExecutor;
        @NonNull
        OnVideoSavedCallback mOnVideoSavedCallback;

        VideoSavedListenerWrapper(@NonNull Executor executor, OnVideoSavedCallback onVideoSavedCallback) {
            this.mExecutor = executor;
            this.mOnVideoSavedCallback = onVideoSavedCallback;
        }

        @Override
        public void onVideoSaved(@NonNull File file) {
            try {
                this.mExecutor.execute(() -> this.mOnVideoSavedCallback.onVideoSaved(file));
            }
            catch (RejectedExecutionException e) {
                Log.e((String)VideoCapture.TAG, (String)"Unable to post to the supplied executor.");
            }
        }

        @Override
        public void onError(int videoCaptureError, @NonNull String message, @Nullable Throwable cause) {
            try {
                this.mExecutor.execute(() -> this.mOnVideoSavedCallback.onError(videoCaptureError, message, cause));
            }
            catch (RejectedExecutionException e) {
                Log.e((String)VideoCapture.TAG, (String)"Unable to post to the supplied executor.");
            }
        }
    }

    public static final class Metadata {
        @Nullable
        public Location location;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Defaults
    implements ConfigProvider<VideoCaptureConfig> {
        private static final int DEFAULT_VIDEO_FRAME_RATE = 30;
        private static final int DEFAULT_BIT_RATE = 0x800000;
        private static final int DEFAULT_INTRA_FRAME_INTERVAL = 1;
        private static final int DEFAULT_AUDIO_BIT_RATE = 64000;
        private static final int DEFAULT_AUDIO_SAMPLE_RATE = 8000;
        private static final int DEFAULT_AUDIO_CHANNEL_COUNT = 1;
        private static final int DEFAULT_AUDIO_RECORD_SOURCE = 1;
        private static final int DEFAULT_AUDIO_MIN_BUFFER_SIZE = 1024;
        private static final Size DEFAULT_MAX_RESOLUTION = new Size(1920, 1080);
        private static final int DEFAULT_SURFACE_OCCUPANCY_PRIORITY = 3;
        private static final VideoCaptureConfig DEFAULT_CONFIG;

        @Override
        @NonNull
        public VideoCaptureConfig getConfig(@Nullable CameraInfo cameraInfo) {
            return DEFAULT_CONFIG;
        }

        static {
            VideoCaptureConfig.Builder builder = new VideoCaptureConfig.Builder().setVideoFrameRate(30).setBitRate(0x800000).setIFrameInterval(1).setAudioBitRate(64000).setAudioSampleRate(8000).setAudioChannelCount(1).setAudioRecordSource(1).setAudioMinBufferSize(1024).setMaxResolution(DEFAULT_MAX_RESOLUTION).setSurfaceOccupancyPriority(3);
            DEFAULT_CONFIG = builder.getUseCaseConfig();
        }
    }

    public static interface OnVideoSavedCallback {
        public void onVideoSaved(@NonNull File var1);

        public void onError(int var1, @NonNull String var2, @Nullable Throwable var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface VideoCaptureError {
    }
}

