/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.util.Size;
import androidx.annotation.CallSuper;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class UseCase {
    private final Set<StateChangeCallback> mStateChangeCallbacks = new HashSet<StateChangeCallback>();
    private final Map<String, CameraControlInternal> mAttachedCameraControlMap = new HashMap<String, CameraControlInternal>();
    private final Map<String, SessionConfig> mAttachedCameraIdToSessionConfigMap = new HashMap<String, SessionConfig>();
    private final Map<String, Size> mAttachedSurfaceResolutionMap = new HashMap<String, Size>();
    private State mState = State.INACTIVE;
    private UseCaseConfig<?> mUseCaseConfig;
    private final Object mBoundCameraLock = new Object();
    @GuardedBy(value="mBoundCameraLock")
    private CameraInternal mBoundCamera;
    private int mImageFormat = 34;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected UseCase(@NonNull UseCaseConfig<?> useCaseConfig) {
        this.updateUseCaseConfig(useCaseConfig);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    protected UseCaseConfig.Builder<?, ?, ?> getDefaultBuilder(@Nullable CameraInfo cameraInfo) {
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected final void updateUseCaseConfig(@NonNull UseCaseConfig<?> useCaseConfig) {
        UseCaseConfig.Builder<?, ?, ?> defaultBuilder = this.getDefaultBuilder(this.getBoundCamera() == null ? null : this.getBoundCamera().getCameraInfo());
        this.mUseCaseConfig = this.applyDefaults(useCaseConfig, defaultBuilder);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected UseCaseConfig<?> applyDefaults(@NonNull UseCaseConfig<?> userConfig, @Nullable UseCaseConfig.Builder<?, ?, ?> defaultConfigBuilder) {
        if (defaultConfigBuilder == null) {
            return userConfig;
        }
        MutableConfig defaultMutableConfig = defaultConfigBuilder.getMutableConfig();
        if (userConfig.containsOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO) && defaultMutableConfig.containsOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO_CUSTOM)) {
            defaultMutableConfig.removeOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO_CUSTOM);
        }
        Iterator<Config.Option<?>> iterator = userConfig.listOptions().iterator();
        while (iterator.hasNext()) {
            Config.Option<?> opt;
            Config.Option<?> objectOpt = opt = iterator.next();
            defaultMutableConfig.insertOption(objectOpt, userConfig.retrieveOption(objectOpt));
        }
        Object defaultConfig = defaultConfigBuilder.getUseCaseConfig();
        return defaultConfig;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Set<String> getAttachedCameraIds() {
        return this.mAttachedCameraIdToSessionConfigMap.keySet();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void attachToCamera(String cameraId, SessionConfig sessionConfig) {
        this.mAttachedCameraIdToSessionConfigMap.put(cameraId, sessionConfig);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void addStateChangeCallback(@NonNull StateChangeCallback callback) {
        this.mStateChangeCallbacks.add(callback);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void attachCameraControl(String cameraId, CameraControlInternal cameraControl) {
        this.mAttachedCameraControlMap.put(cameraId, cameraControl);
        this.onCameraControlReady(cameraId);
    }

    final void detachCameraControl(String cameraId) {
        this.mAttachedCameraControlMap.remove(cameraId);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void removeStateChangeCallback(@NonNull StateChangeCallback callback) {
        this.mStateChangeCallbacks.remove(callback);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SessionConfig getSessionConfig(String cameraId) {
        SessionConfig sessionConfig = this.mAttachedCameraIdToSessionConfigMap.get(cameraId);
        if (sessionConfig == null) {
            throw new IllegalArgumentException("Invalid camera: " + cameraId);
        }
        return sessionConfig;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected final void notifyActive() {
        this.mState = State.ACTIVE;
        this.notifyState();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected final void notifyInactive() {
        this.mState = State.INACTIVE;
        this.notifyState();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected final void notifyUpdated() {
        for (StateChangeCallback stateChangeCallback : this.mStateChangeCallbacks) {
            stateChangeCallback.onUseCaseUpdated(this);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected final void notifyReset() {
        for (StateChangeCallback stateChangeCallback : this.mStateChangeCallbacks) {
            stateChangeCallback.onUseCaseReset(this);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected final void notifyState() {
        switch (this.mState) {
            case INACTIVE: {
                for (StateChangeCallback stateChangeCallback : this.mStateChangeCallbacks) {
                    stateChangeCallback.onUseCaseInactive(this);
                }
                break;
            }
            case ACTIVE: {
                for (StateChangeCallback stateChangeCallback : this.mStateChangeCallbacks) {
                    stateChangeCallback.onUseCaseActive(this);
                }
                break;
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected String getBoundCameraId() {
        return ((CameraInternal)Preconditions.checkNotNull((Object)this.getBoundCamera(), (Object)("No camera bound to use case: " + this))).getCameraInfoInternal().getCameraId();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected boolean isCurrentlyBoundCamera(@NonNull String cameraId) {
        if (this.getBoundCamera() == null) {
            return false;
        }
        return Objects.equals(cameraId, this.getBoundCameraId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @CallSuper
    public void clear() {
        EventCallback eventCallback = this.mUseCaseConfig.getUseCaseEventCallback(null);
        if (eventCallback != null) {
            eventCallback.onUnbind();
        }
        Object object = this.mBoundCameraLock;
        synchronized (object) {
            this.mBoundCamera = null;
        }
        this.mStateChangeCallbacks.clear();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public String getName() {
        return this.mUseCaseConfig.getTargetName("<UnknownUseCase-" + this.hashCode() + ">");
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public UseCaseConfig<?> getUseCaseConfig() {
        return this.mUseCaseConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CameraInternal getBoundCamera() {
        Object object = this.mBoundCameraLock;
        synchronized (object) {
            return this.mBoundCamera;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Size getAttachedSurfaceResolution(String cameraId) {
        return this.mAttachedSurfaceResolutionMap.get(cameraId);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void updateSuggestedResolution(Map<String, Size> suggestedResolutionMap) {
        Map<String, Size> resolutionMap = this.onSuggestedResolutionUpdated(suggestedResolutionMap);
        for (Map.Entry<String, Size> entry : resolutionMap.entrySet()) {
            this.mAttachedSurfaceResolutionMap.put(entry.getKey(), entry.getValue());
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected abstract Map<String, Size> onSuggestedResolutionUpdated(@NonNull Map<String, Size> var1);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void onCameraControlReady(String cameraId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void onBind(@NonNull CameraInternal camera) {
        Object object = this.mBoundCameraLock;
        synchronized (object) {
            this.mBoundCamera = camera;
        }
        this.updateUseCaseConfig(this.mUseCaseConfig);
        EventCallback eventCallback = this.mUseCaseConfig.getUseCaseEventCallback(null);
        if (eventCallback != null) {
            eventCallback.onBind(camera.getCameraInfoInternal().getCameraId());
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onStateOnline(@NonNull String cameraId) {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onStateOffline(@NonNull String cameraId) {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected CameraControlInternal getCameraControl(String cameraId) {
        CameraControlInternal cameraControl = this.mAttachedCameraControlMap.get(cameraId);
        if (cameraControl == null) {
            return CameraControlInternal.DEFAULT_EMPTY_INSTANCE;
        }
        return cameraControl;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getImageFormat() {
        return this.mImageFormat;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void setImageFormat(int imageFormat) {
        this.mImageFormat = imageFormat;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface EventCallback {
        public void onBind(@NonNull String var1);

        public void onUnbind();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface StateChangeCallback {
        public void onUseCaseActive(@NonNull UseCase var1);

        public void onUseCaseInactive(@NonNull UseCase var1);

        public void onUseCaseUpdated(@NonNull UseCase var1);

        public void onUseCaseReset(@NonNull UseCase var1);
    }

    static enum State {
        ACTIVE,
        INACTIVE;

    }
}

