/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.PointF;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.MeteringPointFactory;
import androidx.camera.core.UseCase;
import java.util.Iterator;
import java.util.Set;

public class SurfaceOrientedMeteringPointFactory
extends MeteringPointFactory {
    private final float mWidth;
    private final float mHeight;

    public SurfaceOrientedMeteringPointFactory(float width, float height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    public SurfaceOrientedMeteringPointFactory(float width, float height, @NonNull UseCase useCaseForAspectRatio) {
        super(SurfaceOrientedMeteringPointFactory.getUseCaseAspectRatio(useCaseForAspectRatio));
        this.mWidth = width;
        this.mHeight = height;
    }

    @Nullable
    private static Rational getUseCaseAspectRatio(@Nullable UseCase useCase) {
        if (useCase == null) {
            return null;
        }
        Set<String> cameraIds = useCase.getAttachedCameraIds();
        if (cameraIds.isEmpty()) {
            throw new IllegalStateException("UseCase " + useCase + " is not bound.");
        }
        Iterator<String> iterator = cameraIds.iterator();
        if (iterator.hasNext()) {
            String id = iterator.next();
            Size resolution = useCase.getAttachedSurfaceResolution(id);
            return new Rational(resolution.getWidth(), resolution.getHeight());
        }
        return null;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected PointF convertPoint(float x, float y) {
        PointF pt = new PointF(x / this.mWidth, y / this.mHeight);
        return pt;
    }
}

