/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageAnalysisAbstractAnalyzer;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class ImageAnalysisNonBlockingAnalyzer
extends ImageAnalysisAbstractAnalyzer {
    private static final String TAG = "NonBlockingCallback";
    final Executor mBackgroundExecutor;
    @GuardedBy(value="this")
    private ImageProxy mCachedImage;
    private final AtomicLong mPostedImageTimestamp;
    private final AtomicReference<CacheAnalyzingImageProxy> mPostedImage;

    ImageAnalysisNonBlockingAnalyzer(Executor executor) {
        this.mBackgroundExecutor = executor;
        this.mPostedImage = new AtomicReference();
        this.mPostedImageTimestamp = new AtomicLong();
        this.open();
    }

    @Override
    public void onImageAvailable(@NonNull ImageReaderProxy imageReaderProxy) {
        ImageProxy imageProxy = imageReaderProxy.acquireLatestImage();
        if (imageProxy == null) {
            return;
        }
        this.analyze(imageProxy);
    }

    @Override
    synchronized void open() {
        super.open();
        this.mCachedImage = null;
        this.mPostedImageTimestamp.set(-1L);
        this.mPostedImage.set(null);
    }

    @Override
    synchronized void close() {
        super.close();
        if (this.mCachedImage != null) {
            this.mCachedImage.close();
            this.mCachedImage = null;
        }
    }

    synchronized void analyzeCachedImage() {
        if (this.mCachedImage != null) {
            ImageProxy cachedImage = this.mCachedImage;
            this.mCachedImage = null;
            this.analyze(cachedImage);
        }
    }

    private synchronized void analyze(final @NonNull ImageProxy imageProxy) {
        if (this.isClosed()) {
            imageProxy.close();
            return;
        }
        CacheAnalyzingImageProxy postedImage = this.mPostedImage.get();
        if (postedImage != null && imageProxy.getImageInfo().getTimestamp() <= this.mPostedImageTimestamp.get()) {
            imageProxy.close();
            return;
        }
        if (postedImage != null && !postedImage.isClosed()) {
            if (this.mCachedImage != null) {
                this.mCachedImage.close();
            }
            this.mCachedImage = imageProxy;
            return;
        }
        postedImage = new CacheAnalyzingImageProxy(imageProxy, this);
        this.mPostedImage.set(postedImage);
        this.mPostedImageTimestamp.set(postedImage.getImageInfo().getTimestamp());
        ListenableFuture<Void> analyzeFuture = this.analyzeImage(postedImage);
        Futures.addCallback(analyzeFuture, new FutureCallback<Void>(){

            @Override
            public void onSuccess(Void result) {
            }

            @Override
            public void onFailure(Throwable t) {
                imageProxy.close();
            }
        }, CameraXExecutors.directExecutor());
    }

    static class CacheAnalyzingImageProxy
    extends ForwardingImageProxy {
        WeakReference<ImageAnalysisNonBlockingAnalyzer> mNonBlockingAnalyzerWeakReference;
        private boolean mClosed = false;

        CacheAnalyzingImageProxy(ImageProxy image, ImageAnalysisNonBlockingAnalyzer nonBlockingAnalyzer) {
            super(image);
            this.mNonBlockingAnalyzerWeakReference = new WeakReference<ImageAnalysisNonBlockingAnalyzer>(nonBlockingAnalyzer);
            this.addOnImageCloseListener(imageProxy -> {
                this.mClosed = true;
                ImageAnalysisNonBlockingAnalyzer analyzer = (ImageAnalysisNonBlockingAnalyzer)this.mNonBlockingAnalyzerWeakReference.get();
                if (analyzer != null) {
                    analyzer.mBackgroundExecutor.execute(analyzer::analyzeCachedImage);
                }
            });
        }

        boolean isClosed() {
            return this.mClosed;
        }
    }
}

