/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.PointF;
import android.view.Display;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraX;
import androidx.camera.core.MeteringPointFactory;
import androidx.camera.core.impl.CameraInfoInternal;

public final class DisplayOrientedMeteringPointFactory
extends MeteringPointFactory {
    private final float mWidth;
    private final float mHeight;
    private final CameraSelector mCameraSelector;
    @NonNull
    private final Display mDisplay;
    @NonNull
    private final CameraInfoInternal mCameraInfo;

    public DisplayOrientedMeteringPointFactory(@NonNull Display display, @NonNull CameraSelector cameraSelector, float width, float height) {
        this.mWidth = width;
        this.mHeight = height;
        this.mCameraSelector = cameraSelector;
        this.mDisplay = display;
        try {
            String cameraId = CameraX.getCameraWithCameraSelector(this.mCameraSelector);
            this.mCameraInfo = CameraX.getCameraInfo(cameraId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to get camera id for the CameraSelector.", e);
        }
    }

    @Nullable
    private Integer getLensFacing() {
        return this.mCameraInfo.getLensFacing();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected PointF convertPoint(float x, float y) {
        float width = this.mWidth;
        float height = this.mHeight;
        Integer lensFacing = this.getLensFacing();
        boolean compensateForMirroring = lensFacing != null && lensFacing == 0;
        int relativeCameraOrientation = this.getRelativeCameraOrientation(compensateForMirroring);
        float outputX = x;
        float outputY = y;
        float outputWidth = width;
        float outputHeight = height;
        if (relativeCameraOrientation == 90 || relativeCameraOrientation == 270) {
            outputX = y;
            outputY = x;
            outputWidth = height;
            outputHeight = width;
        }
        switch (relativeCameraOrientation) {
            case 90: {
                outputY = outputHeight - outputY;
                break;
            }
            case 180: {
                outputX = outputWidth - outputX;
                outputY = outputHeight - outputY;
                break;
            }
            case 270: {
                outputX = outputWidth - outputX;
                break;
            }
        }
        if (compensateForMirroring) {
            outputX = outputWidth - outputX;
        }
        return new PointF(outputX /= outputWidth, outputY /= outputHeight);
    }

    private int getRelativeCameraOrientation(boolean compensateForMirroring) {
        int rotationDegrees;
        try {
            int displayRotation = this.mDisplay.getRotation();
            rotationDegrees = this.mCameraInfo.getSensorRotationDegrees(displayRotation);
            if (compensateForMirroring) {
                rotationDegrees = (360 - rotationDegrees) % 360;
            }
        }
        catch (Exception e) {
            rotationDegrees = 0;
        }
        return rotationDegrees;
    }
}

