/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.impl.CameraFactory;
import androidx.core.util.Preconditions;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class CameraExecutor
implements Executor {
    private static final int DEFAULT_CORE_THREADS = 1;
    private static final int DEFAULT_MAX_THREADS = 1;
    private final Object mExecutorLock = new Object();
    @GuardedBy(value="mExecutorLock")
    @NonNull
    private ThreadPoolExecutor mThreadPoolExecutor = CameraExecutor.createExecutor();
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){
        private static final String THREAD_NAME_STEM = "CameraX-core_camera_%d";
        private final AtomicInteger mThreadId = new AtomicInteger(0);

        @Override
        public Thread newThread(@NonNull Runnable runnable) {
            Thread t = new Thread(runnable);
            t.setName(String.format(Locale.US, THREAD_NAME_STEM, this.mThreadId.getAndIncrement()));
            return t;
        }
    };

    CameraExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(@NonNull CameraFactory cameraFactory) {
        ThreadPoolExecutor executor;
        Preconditions.checkNotNull((Object)cameraFactory);
        Object object = this.mExecutorLock;
        synchronized (object) {
            if (this.mThreadPoolExecutor.isShutdown()) {
                this.mThreadPoolExecutor = CameraExecutor.createExecutor();
            }
            executor = this.mThreadPoolExecutor;
        }
        int cameraNumber = 0;
        try {
            cameraNumber = cameraFactory.getAvailableCameraIds().size();
        }
        catch (CameraInfoUnavailableException e) {
            e.printStackTrace();
        }
        int corePoolSize = Math.max(1, cameraNumber);
        executor.setMaximumPoolSize(corePoolSize);
        executor.setCorePoolSize(corePoolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deinit() {
        Object object = this.mExecutorLock;
        synchronized (object) {
            if (!this.mThreadPoolExecutor.isShutdown()) {
                this.mThreadPoolExecutor.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NonNull Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        Object object = this.mExecutorLock;
        synchronized (object) {
            Preconditions.checkState((!this.mThreadPoolExecutor.isShutdown() ? 1 : 0) != 0, (String)"CameraExecutor is deinit");
            this.mThreadPoolExecutor.execute(runnable);
        }
    }

    private static ThreadPoolExecutor createExecutor() {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), THREAD_FACTORY);
    }
}

