/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.Config;
import androidx.camera.core.MutableOptionsBundle;
import androidx.camera.core.OptionsBundle;
import androidx.camera.core.impl.CameraDeviceConfig;
import androidx.camera.core.impl.CameraIdFilter;
import androidx.camera.core.internal.CameraIdFilterSet;
import java.util.LinkedHashSet;
import java.util.Set;

public final class CameraSelectorUtil {
    @NonNull
    public static CameraDeviceConfig toCameraDeviceConfig(@NonNull CameraSelector cameraSelector) {
        LinkedHashSet<CameraIdFilter> idFilters;
        MutableOptionsBundle mutableOptionsBundle = MutableOptionsBundle.create();
        Integer lensFacing = cameraSelector.getLensFacing();
        if (lensFacing != null) {
            mutableOptionsBundle.insertOption(CameraDeviceConfig.OPTION_LENS_FACING, lensFacing);
        }
        if (!(idFilters = cameraSelector.getCameraFilterSet()).isEmpty()) {
            CameraIdFilter combinedFilter = (CameraIdFilter)idFilters.iterator().next();
            if (idFilters.size() > 1) {
                CameraIdFilterSet filterSet = new CameraIdFilterSet();
                for (CameraIdFilter filter : idFilters) {
                    filterSet.addCameraIdFilter(filter);
                }
                combinedFilter = filterSet;
            }
            mutableOptionsBundle.insertOption(CameraDeviceConfig.OPTION_CAMERA_ID_FILTER, combinedFilter);
        }
        return new CameraSelectorDeviceConfig(OptionsBundle.from(mutableOptionsBundle));
    }

    private CameraSelectorUtil() {
    }

    private static class CameraSelectorDeviceConfig
    implements CameraDeviceConfig,
    Config {
        private final OptionsBundle mConfig;

        CameraSelectorDeviceConfig(OptionsBundle options) {
            this.mConfig = options;
        }

        @Override
        @Nullable
        public Integer getLensFacing(@Nullable Integer valueIfMissing) {
            try {
                return this.getLensFacing();
            }
            catch (IllegalArgumentException e) {
                return valueIfMissing;
            }
        }

        @Override
        public int getLensFacing() {
            return (Integer)this.retrieveOption(OPTION_LENS_FACING);
        }

        @Override
        @Nullable
        public CameraIdFilter getCameraIdFilter(@Nullable CameraIdFilter valueIfMissing) {
            return this.retrieveOption(OPTION_CAMERA_ID_FILTER, valueIfMissing);
        }

        @Override
        @NonNull
        public CameraIdFilter getCameraIdFilter() {
            return (CameraIdFilter)this.retrieveOption(OPTION_CAMERA_ID_FILTER);
        }

        @Override
        public boolean containsOption(@NonNull Config.Option<?> id) {
            return this.mConfig.containsOption(id);
        }

        @Override
        @Nullable
        public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id) {
            return this.mConfig.retrieveOption(id);
        }

        @Override
        @Nullable
        public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id, @Nullable ValueT valueIfMissing) {
            return this.mConfig.retrieveOption(id, valueIfMissing);
        }

        @Override
        public void findOptions(@NonNull String idStem, @NonNull Config.OptionMatcher matcher) {
            this.mConfig.findOptions(idStem, matcher);
        }

        @Override
        @NonNull
        public Set<Config.Option<?>> listOptions() {
            return this.mConfig.listOptions();
        }
    }
}

