/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.UseCaseGroup;
import androidx.camera.core.UseCaseGroupLifecycleController;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class UseCaseGroupRepository {
    final Object mUseCasesLock = new Object();
    @GuardedBy(value="mUseCasesLock")
    final Map<LifecycleOwner, UseCaseGroupLifecycleController> mLifecycleToUseCaseGroupControllerMap = new HashMap<LifecycleOwner, UseCaseGroupLifecycleController>();
    @GuardedBy(value="mUseCasesLock")
    final List<LifecycleOwner> mActiveLifecycleOwnerList = new ArrayList<LifecycleOwner>();
    @GuardedBy(value="mUseCasesLock")
    LifecycleOwner mCurrentActiveLifecycleOwner = null;

    UseCaseGroupRepository() {
    }

    UseCaseGroupLifecycleController getOrCreateUseCaseGroup(LifecycleOwner lifecycleOwner) {
        return this.getOrCreateUseCaseGroup(lifecycleOwner, new UseCaseGroupSetup(){

            @Override
            public void setup(UseCaseGroup useCaseGroup) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UseCaseGroupLifecycleController getOrCreateUseCaseGroup(LifecycleOwner lifecycleOwner, UseCaseGroupSetup groupSetup) {
        UseCaseGroupLifecycleController useCaseGroupLifecycleController;
        Object object = this.mUseCasesLock;
        synchronized (object) {
            useCaseGroupLifecycleController = this.mLifecycleToUseCaseGroupControllerMap.get(lifecycleOwner);
            if (useCaseGroupLifecycleController == null) {
                useCaseGroupLifecycleController = this.createUseCaseGroup(lifecycleOwner);
                groupSetup.setup(useCaseGroupLifecycleController.getUseCaseGroup());
            }
        }
        return useCaseGroupLifecycleController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UseCaseGroupLifecycleController createUseCaseGroup(LifecycleOwner lifecycleOwner) {
        if (lifecycleOwner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            throw new IllegalArgumentException("Trying to create use case group with destroyed lifecycle.");
        }
        lifecycleOwner.getLifecycle().addObserver(this.createLifecycleObserver());
        UseCaseGroupLifecycleController useCaseGroupLifecycleController = new UseCaseGroupLifecycleController(lifecycleOwner.getLifecycle());
        Object object = this.mUseCasesLock;
        synchronized (object) {
            this.mLifecycleToUseCaseGroupControllerMap.put(lifecycleOwner, useCaseGroupLifecycleController);
        }
        return useCaseGroupLifecycleController;
    }

    private LifecycleObserver createLifecycleObserver() {
        return new LifecycleObserver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
            public void onStart(LifecycleOwner lifecycleOwner) {
                Object object = UseCaseGroupRepository.this.mUseCasesLock;
                synchronized (object) {
                    for (Map.Entry<LifecycleOwner, UseCaseGroupLifecycleController> entry : UseCaseGroupRepository.this.mLifecycleToUseCaseGroupControllerMap.entrySet()) {
                        UseCaseGroup useCaseGroup;
                        if (entry.getKey() == lifecycleOwner || !(useCaseGroup = entry.getValue().getUseCaseGroup()).isActive()) continue;
                        useCaseGroup.stop();
                    }
                    UseCaseGroupRepository.this.mCurrentActiveLifecycleOwner = lifecycleOwner;
                    UseCaseGroupRepository.this.mActiveLifecycleOwnerList.add(0, UseCaseGroupRepository.this.mCurrentActiveLifecycleOwner);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
            public void onStop(LifecycleOwner lifecycleOwner) {
                Object object = UseCaseGroupRepository.this.mUseCasesLock;
                synchronized (object) {
                    UseCaseGroupRepository.this.mActiveLifecycleOwnerList.remove(lifecycleOwner);
                    if (UseCaseGroupRepository.this.mCurrentActiveLifecycleOwner == lifecycleOwner) {
                        if (UseCaseGroupRepository.this.mActiveLifecycleOwnerList.size() > 0) {
                            UseCaseGroupRepository.this.mCurrentActiveLifecycleOwner = UseCaseGroupRepository.this.mActiveLifecycleOwnerList.get(0);
                            UseCaseGroupRepository.this.mLifecycleToUseCaseGroupControllerMap.get(UseCaseGroupRepository.this.mCurrentActiveLifecycleOwner).getUseCaseGroup().start();
                        } else {
                            UseCaseGroupRepository.this.mCurrentActiveLifecycleOwner = null;
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
            public void onDestroy(LifecycleOwner lifecycleOwner) {
                Object object = UseCaseGroupRepository.this.mUseCasesLock;
                synchronized (object) {
                    UseCaseGroupRepository.this.mLifecycleToUseCaseGroupControllerMap.remove(lifecycleOwner);
                }
                lifecycleOwner.getLifecycle().removeObserver((LifecycleObserver)this);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<UseCaseGroupLifecycleController> getUseCaseGroups() {
        Object object = this.mUseCasesLock;
        synchronized (object) {
            return Collections.unmodifiableCollection(this.mLifecycleToUseCaseGroupControllerMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Map<LifecycleOwner, UseCaseGroupLifecycleController> getUseCasesMap() {
        Object object = this.mUseCasesLock;
        synchronized (object) {
            return this.mLifecycleToUseCaseGroupControllerMap;
        }
    }

    public static interface UseCaseGroupSetup {
        public void setup(UseCaseGroup var1);
    }
}

