/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.os.Handler;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxy;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;

final class QueuedImageReaderProxy
implements ImageReaderProxy,
ForwardingImageProxy.OnImageCloseListener {
    private final int mWidth;
    private final int mHeight;
    private final int mFormat;
    private final int mMaxImages;
    @GuardedBy(value="this")
    private final Surface mSurface;
    @GuardedBy(value="this")
    private final List<ImageProxy> mImages;
    @GuardedBy(value="this")
    private final Set<ImageProxy> mAcquiredImages = new HashSet<ImageProxy>();
    @GuardedBy(value="this")
    private final Set<OnReaderCloseListener> mOnReaderCloseListeners = new HashSet<OnReaderCloseListener>();
    @GuardedBy(value="this")
    private int mCurrentPosition;
    @GuardedBy(value="this")
    @Nullable
    private ImageReaderProxy.OnImageAvailableListener mOnImageAvailableListener;
    @GuardedBy(value="this")
    @Nullable
    private Executor mOnImageAvailableExecutor;
    @GuardedBy(value="this")
    private boolean mClosed;

    QueuedImageReaderProxy(int width, int height, int format, int maxImages, Surface surface) {
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = format;
        this.mMaxImages = maxImages;
        this.mSurface = surface;
        this.mImages = new ArrayList<ImageProxy>(maxImages);
        this.mCurrentPosition = 0;
        this.mClosed = false;
    }

    @Override
    @Nullable
    public synchronized ImageProxy acquireLatestImage() {
        this.throwExceptionIfClosed();
        if (this.mImages.isEmpty()) {
            return null;
        }
        if (this.mCurrentPosition >= this.mImages.size()) {
            throw new IllegalStateException("Max images have already been acquired without close.");
        }
        ArrayList<ImageProxy> imagesToClose = new ArrayList<ImageProxy>();
        for (int i = 0; i < this.mImages.size() - 1; ++i) {
            if (this.mAcquiredImages.contains(this.mImages.get(i))) continue;
            imagesToClose.add(this.mImages.get(i));
        }
        for (ImageProxy image : imagesToClose) {
            image.close();
        }
        this.mCurrentPosition = this.mImages.size() - 1;
        ImageProxy acquiredImage = this.mImages.get(this.mCurrentPosition++);
        this.mAcquiredImages.add(acquiredImage);
        return acquiredImage;
    }

    @Override
    @Nullable
    public synchronized ImageProxy acquireNextImage() {
        this.throwExceptionIfClosed();
        if (this.mImages.isEmpty()) {
            return null;
        }
        if (this.mCurrentPosition >= this.mImages.size()) {
            throw new IllegalStateException("Max images have already been acquired without close.");
        }
        ImageProxy acquiredImage = this.mImages.get(this.mCurrentPosition++);
        this.mAcquiredImages.add(acquiredImage);
        return acquiredImage;
    }

    synchronized void enqueueImage(ForwardingImageProxy image) {
        this.throwExceptionIfClosed();
        if (this.mImages.size() < this.mMaxImages) {
            this.mImages.add(image);
            image.addOnImageCloseListener(this);
            if (this.mOnImageAvailableListener != null && this.mOnImageAvailableExecutor != null) {
                final ImageReaderProxy.OnImageAvailableListener listener = this.mOnImageAvailableListener;
                this.mOnImageAvailableExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!QueuedImageReaderProxy.this.isClosed()) {
                            listener.onImageAvailable(QueuedImageReaderProxy.this);
                        }
                    }
                });
            }
        } else {
            image.close();
        }
    }

    @Override
    public synchronized void close() {
        if (!this.mClosed) {
            this.mOnImageAvailableExecutor = null;
            this.mOnImageAvailableListener = null;
            ArrayList<ImageProxy> imagesToClose = new ArrayList<ImageProxy>(this.mImages);
            for (ImageProxy image : imagesToClose) {
                image.close();
            }
            this.mImages.clear();
            this.mClosed = true;
            this.notifyOnReaderCloseListeners();
        }
    }

    @Override
    public int getHeight() {
        this.throwExceptionIfClosed();
        return this.mHeight;
    }

    @Override
    public int getWidth() {
        this.throwExceptionIfClosed();
        return this.mWidth;
    }

    @Override
    public int getImageFormat() {
        this.throwExceptionIfClosed();
        return this.mFormat;
    }

    @Override
    public int getMaxImages() {
        this.throwExceptionIfClosed();
        return this.mMaxImages;
    }

    @Override
    public synchronized Surface getSurface() {
        this.throwExceptionIfClosed();
        return this.mSurface;
    }

    @Override
    public synchronized void setOnImageAvailableListener(@NonNull ImageReaderProxy.OnImageAvailableListener onImageAvailableListener, @Nullable Handler onImageAvailableHandler) {
        this.setOnImageAvailableListener(onImageAvailableListener, onImageAvailableHandler == null ? null : CameraXExecutors.newHandlerExecutor(onImageAvailableHandler));
    }

    @Override
    public synchronized void setOnImageAvailableListener(@NonNull ImageReaderProxy.OnImageAvailableListener onImageAvailableListener, @NonNull Executor executor) {
        this.throwExceptionIfClosed();
        this.mOnImageAvailableListener = onImageAvailableListener;
        this.mOnImageAvailableExecutor = executor;
    }

    @Override
    public synchronized void onImageClose(ImageProxy image) {
        int index = this.mImages.indexOf(image);
        if (index >= 0) {
            this.mImages.remove(index);
            if (index <= this.mCurrentPosition) {
                --this.mCurrentPosition;
            }
        }
        this.mAcquiredImages.remove(image);
    }

    synchronized int getCurrentImages() {
        this.throwExceptionIfClosed();
        return this.mImages.size();
    }

    synchronized boolean isClosed() {
        return this.mClosed;
    }

    synchronized void addOnReaderCloseListener(OnReaderCloseListener listener) {
        this.mOnReaderCloseListeners.add(listener);
    }

    private synchronized void throwExceptionIfClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("This reader is already closed.");
        }
    }

    private synchronized void notifyOnReaderCloseListeners() {
        for (OnReaderCloseListener listener : this.mOnReaderCloseListeners) {
            listener.onReaderClose(this);
        }
    }

    static interface OnReaderCloseListener {
        public void onReaderClose(ImageReaderProxy var1);
    }
}

