/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.SurfaceTexture;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.CallbackDeferrableSurface;
import androidx.camera.core.CaptureProcessor;
import androidx.camera.core.CaptureStage;
import androidx.camera.core.DeferrableSurface;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxy;
import androidx.camera.core.MetadataImageReader;
import androidx.camera.core.SingleImageProxyBundle;
import androidx.camera.core.SurfaceHolder;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;

final class ProcessingSurface
extends DeferrableSurface
implements SurfaceHolder {
    private static final String TAG = "ProcessingSurfaceTextur";
    final Object mLock = new Object();
    private final ImageReaderProxy.OnImageAvailableListener mTransformedListener = new ImageReaderProxy.OnImageAvailableListener(){

        @Override
        public void onImageAvailable(ImageReaderProxy reader) {
            ProcessingSurface.this.imageIncoming(reader);
        }
    };
    @GuardedBy(value="mLock")
    boolean mReleased = false;
    @NonNull
    private final Size mResolution;
    @GuardedBy(value="mLock")
    final MetadataImageReader mInputImageReader;
    @GuardedBy(value="mLock")
    final Surface mInputSurface;
    private final Handler mImageReaderHandler;
    private static final int MAX_IMAGES = 2;
    @GuardedBy(value="mLock")
    SurfaceTexture mSurfaceTexture;
    @GuardedBy(value="mLock")
    Surface mSurfaceTextureSurface;
    final CaptureStage mCaptureStage;
    @NonNull
    @GuardedBy(value="mLock")
    final CaptureProcessor mCaptureProcessor;
    private final CameraCaptureCallback mCameraCaptureCallback;
    private final CallbackDeferrableSurface mCallbackDeferrableSurface;

    ProcessingSurface(int width, int height, int format, @Nullable Handler handler, @NonNull CaptureStage captureStage, @NonNull CaptureProcessor captureProcessor, @NonNull CallbackDeferrableSurface callbackDeferrableSurface) {
        this.mResolution = new Size(width, height);
        if (handler != null) {
            this.mImageReaderHandler = handler;
        } else {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalStateException("Creating a ProcessingSurfaceTexture requires a non-null Handler, or be created on a thread with a Looper.");
            }
            this.mImageReaderHandler = new Handler(looper);
        }
        this.mInputImageReader = new MetadataImageReader(width, height, format, 2, this.mImageReaderHandler);
        this.mInputImageReader.setOnImageAvailableListener(this.mTransformedListener, this.mImageReaderHandler);
        this.mInputSurface = this.mInputImageReader.getSurface();
        this.mCameraCaptureCallback = this.mInputImageReader.getCameraCaptureCallback();
        this.mCaptureProcessor = captureProcessor;
        this.mCaptureProcessor.onResolutionUpdate(this.mResolution);
        this.mCaptureStage = captureStage;
        this.mCallbackDeferrableSurface = callbackDeferrableSurface;
        Futures.addCallback(callbackDeferrableSurface.getSurface(), new FutureCallback<Surface>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(@Nullable Surface surface) {
                Object object = ProcessingSurface.this.mLock;
                synchronized (object) {
                    ProcessingSurface.this.mCaptureProcessor.onOutputSurface(surface, 1);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                Log.e((String)ProcessingSurface.TAG, (String)"Failed to extract Listenable<Surface>.", (Throwable)t);
            }
        }, CameraXExecutors.directExecutor());
    }

    @Override
    @NonNull
    public ListenableFuture<Surface> provideSurface() {
        return Futures.immediateFuture(this.mInputSurface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    CameraCaptureCallback getCameraCaptureCallback() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mReleased) {
                throw new IllegalStateException("ProcessingSurfaceTexture already released!");
            }
            return this.mCameraCaptureCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mReleased) {
                return;
            }
            if (this.mCallbackDeferrableSurface == null) {
                this.mSurfaceTexture.release();
                this.mSurfaceTexture = null;
                this.mSurfaceTextureSurface.release();
                this.mSurfaceTextureSurface = null;
            } else {
                this.mCallbackDeferrableSurface.release();
            }
            this.mReleased = true;
            this.mInputImageReader.setOnImageAvailableListener(new ImageReaderProxy.OnImageAvailableListener(){

                @Override
                public void onImageAvailable(ImageReaderProxy imageReaderProxy) {
                    try {
                        ImageProxy image = imageReaderProxy.acquireLatestImage();
                        Throwable throwable = null;
                        if (image != null) {
                            if (throwable != null) {
                                try {
                                    image.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                image.close();
                            }
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }, AsyncTask.THREAD_POOL_EXECUTOR);
            this.setOnSurfaceDetachedListener(CameraXExecutors.directExecutor(), new DeferrableSurface.OnSurfaceDetachedListener(){

                @Override
                public void onSurfaceDetached() {
                    ProcessingSurface.this.closeInputs();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeInputs() {
        Object object = this.mLock;
        synchronized (object) {
            this.mInputImageReader.close();
            this.mInputSurface.release();
        }
    }

    @GuardedBy(value="mLock")
    void imageIncoming(ImageReaderProxy imageReader) {
        if (this.mReleased) {
            return;
        }
        ImageProxy image = null;
        try {
            image = imageReader.acquireNextImage();
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"Failed to acquire next image.", (Throwable)e);
        }
        if (image == null) {
            return;
        }
        ImageInfo imageInfo = image.getImageInfo();
        if (imageInfo == null) {
            image.close();
            return;
        }
        Object tagObject = imageInfo.getTag();
        if (tagObject == null) {
            image.close();
            return;
        }
        if (!(tagObject instanceof Integer)) {
            image.close();
            return;
        }
        Integer tag = (Integer)tagObject;
        if (this.mCaptureStage.getId() != tag.intValue()) {
            Log.w((String)TAG, (String)("ImageProxyBundle does not contain this id: " + tag));
            image.close();
        } else {
            SingleImageProxyBundle imageProxyBundle = new SingleImageProxyBundle(image);
            this.mCaptureProcessor.process(imageProxyBundle);
            imageProxyBundle.close();
        }
    }
}

