/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.media.ImageReader;
import android.os.Handler;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.AndroidImageReaderProxy;
import androidx.camera.core.CaptureBundle;
import androidx.camera.core.CaptureProcessor;
import androidx.camera.core.CaptureStage;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxy;
import androidx.camera.core.MetadataImageReader;
import androidx.camera.core.SettableImageProxyBundle;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

class ProcessingImageReader
implements ImageReaderProxy {
    private static final String TAG = "ProcessingImageReader";
    private final Object mLock = new Object();
    private ImageReaderProxy.OnImageAvailableListener mTransformedListener = new ImageReaderProxy.OnImageAvailableListener(){

        @Override
        public void onImageAvailable(ImageReaderProxy reader) {
            ProcessingImageReader.this.imageIncoming(reader);
        }
    };
    private ImageReaderProxy.OnImageAvailableListener mImageProcessedListener = new ImageReaderProxy.OnImageAvailableListener(){

        @Override
        public void onImageAvailable(ImageReaderProxy reader) {
            if (ProcessingImageReader.this.mExecutor != null) {
                ProcessingImageReader.this.mExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ProcessingImageReader.this.mListener.onImageAvailable(ProcessingImageReader.this);
                    }
                });
            } else {
                ProcessingImageReader.this.mListener.onImageAvailable(ProcessingImageReader.this);
            }
            ProcessingImageReader.this.mSettableImageProxyBundle.reset();
            ProcessingImageReader.this.setupSettableImageProxyBundleCallbacks();
        }
    };
    private FutureCallback<List<ImageProxy>> mCaptureStageReadyCallback = new FutureCallback<List<ImageProxy>>(){

        @Override
        public void onSuccess(@Nullable List<ImageProxy> imageProxyList) {
            ProcessingImageReader.this.mCaptureProcessor.process(ProcessingImageReader.this.mSettableImageProxyBundle);
        }

        @Override
        public void onFailure(Throwable throwable) {
        }
    };
    @GuardedBy(value="mLock")
    private boolean mClosed = false;
    @GuardedBy(value="mLock")
    private final ImageReaderProxy mInputImageReader;
    @GuardedBy(value="mLock")
    private final ImageReaderProxy mOutputImageReader;
    @GuardedBy(value="mLock")
    @Nullable
    ImageReaderProxy.OnImageAvailableListener mListener;
    @GuardedBy(value="mLock")
    @Nullable
    Executor mExecutor;
    @NonNull
    CaptureProcessor mCaptureProcessor;
    @GuardedBy(value="mLock")
    SettableImageProxyBundle mSettableImageProxyBundle = null;
    private final List<Integer> mCaptureIdList = new ArrayList<Integer>();

    ProcessingImageReader(int width, int height, int format, int maxImages, @Nullable Handler handler, @NonNull CaptureBundle captureBundle, @NonNull CaptureProcessor captureProcessor) {
        this.mInputImageReader = new MetadataImageReader(width, height, format, maxImages, handler);
        this.mOutputImageReader = new AndroidImageReaderProxy(ImageReader.newInstance((int)width, (int)height, (int)format, (int)maxImages));
        this.init(CameraXExecutors.newHandlerExecutor(handler), captureBundle, captureProcessor);
    }

    ProcessingImageReader(ImageReaderProxy imageReader, @Nullable Handler handler, @NonNull CaptureBundle captureBundle, @NonNull CaptureProcessor captureProcessor) {
        if (imageReader.getMaxImages() < captureBundle.getCaptureStages().size()) {
            throw new IllegalArgumentException("MetadataImageReader is smaller than CaptureBundle.");
        }
        this.mInputImageReader = imageReader;
        this.mOutputImageReader = new AndroidImageReaderProxy(ImageReader.newInstance((int)imageReader.getWidth(), (int)imageReader.getHeight(), (int)imageReader.getImageFormat(), (int)imageReader.getMaxImages()));
        this.init(CameraXExecutors.newHandlerExecutor(handler), captureBundle, captureProcessor);
    }

    private void init(@NonNull Executor executor, @NonNull CaptureBundle captureBundle, @NonNull CaptureProcessor captureProcessor) {
        this.mExecutor = executor;
        this.mInputImageReader.setOnImageAvailableListener(this.mTransformedListener, executor);
        this.mOutputImageReader.setOnImageAvailableListener(this.mImageProcessedListener, executor);
        this.mCaptureProcessor = captureProcessor;
        this.mCaptureProcessor.onOutputSurface(this.mOutputImageReader.getSurface(), this.getImageFormat());
        this.mCaptureProcessor.onResolutionUpdate(new Size(this.mInputImageReader.getWidth(), this.mInputImageReader.getHeight()));
        this.setCaptureBundle(captureBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ImageProxy acquireLatestImage() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mOutputImageReader.acquireLatestImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ImageProxy acquireNextImage() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mOutputImageReader.acquireNextImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            this.mInputImageReader.close();
            this.mOutputImageReader.close();
            this.mSettableImageProxyBundle.close();
            this.mClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeight() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInputImageReader.getHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWidth() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInputImageReader.getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getImageFormat() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInputImageReader.getImageFormat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxImages() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInputImageReader.getMaxImages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Surface getSurface() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInputImageReader.getSurface();
        }
    }

    @Override
    public void setOnImageAvailableListener(@NonNull ImageReaderProxy.OnImageAvailableListener listener, @Nullable Handler handler) {
        this.setOnImageAvailableListener(listener, CameraXExecutors.newHandlerExecutor(handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOnImageAvailableListener(@NonNull ImageReaderProxy.OnImageAvailableListener listener, @NonNull Executor executor) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = listener;
            this.mExecutor = executor;
            this.mInputImageReader.setOnImageAvailableListener(this.mTransformedListener, executor);
            this.mOutputImageReader.setOnImageAvailableListener(this.mImageProcessedListener, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCaptureBundle(@NonNull CaptureBundle captureBundle) {
        Object object = this.mLock;
        synchronized (object) {
            if (captureBundle.getCaptureStages() != null) {
                if (this.mInputImageReader.getMaxImages() < captureBundle.getCaptureStages().size()) {
                    throw new IllegalArgumentException("CaptureBundle is lager than InputImageReader.");
                }
                this.mCaptureIdList.clear();
                for (CaptureStage captureStage : captureBundle.getCaptureStages()) {
                    if (captureStage == null) continue;
                    this.mCaptureIdList.add(captureStage.getId());
                }
            }
            this.mSettableImageProxyBundle = new SettableImageProxyBundle(this.mCaptureIdList);
            this.setupSettableImageProxyBundleCallbacks();
        }
    }

    @Nullable
    CameraCaptureCallback getCameraCaptureCallback() {
        if (this.mInputImageReader instanceof MetadataImageReader) {
            return ((MetadataImageReader)this.mInputImageReader).getCameraCaptureCallback();
        }
        return null;
    }

    void setupSettableImageProxyBundleCallbacks() {
        ArrayList<ListenableFuture<ImageProxy>> futureList = new ArrayList<ListenableFuture<ImageProxy>>();
        for (Integer id : this.mCaptureIdList) {
            futureList.add(this.mSettableImageProxyBundle.getImageProxy(id));
        }
        Futures.addCallback(Futures.allAsList(futureList), this.mCaptureStageReadyCallback, CameraXExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void imageIncoming(ImageReaderProxy imageReader) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            ImageProxy image = null;
            try {
                image = imageReader.acquireNextImage();
            }
            catch (IllegalStateException e) {
                Log.e((String)TAG, (String)"Failed to acquire latest image.", (Throwable)e);
            }
            finally {
                if (image != null) {
                    Integer tag = (Integer)image.getImageInfo().getTag();
                    if (!this.mCaptureIdList.contains(tag)) {
                        Log.w((String)TAG, (String)("ImageProxyBundle does not contain this id: " + tag));
                        image.close();
                        return;
                    }
                    this.mSettableImageProxyBundle.addImageProxy(image);
                }
            }
        }
    }
}

