/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.os.Handler;
import android.os.HandlerThread;
import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.camera.core.CallbackDeferrableSurface;
import androidx.camera.core.CameraCaptureResultImageInfo;
import androidx.camera.core.CameraX;
import androidx.camera.core.CaptureConfig;
import androidx.camera.core.CaptureProcessor;
import androidx.camera.core.CaptureStage;
import androidx.camera.core.ConfigProvider;
import androidx.camera.core.ImageInfoProcessor;
import androidx.camera.core.ImageOutputConfig;
import androidx.camera.core.MutableConfig;
import androidx.camera.core.MutableOptionsBundle;
import androidx.camera.core.OptionsBundle;
import androidx.camera.core.PreviewConfig;
import androidx.camera.core.ProcessingSurface;
import androidx.camera.core.SessionConfig;
import androidx.camera.core.SurfaceHolder;
import androidx.camera.core.ThreadConfig;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseConfig;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraDeviceConfig;
import androidx.camera.core.impl.CameraIdFilter;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.TargetConfig;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;

public class Preview
extends UseCase {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Defaults DEFAULT_CONFIG = new Defaults();
    private static final String TAG = "Preview";
    @Nullable
    private HandlerThread mProcessingPreviewThread;
    @Nullable
    private Handler mProcessingPreviewHandler;
    @Nullable
    PreviewSurfaceProvider mPreviewSurfaceProvider;
    @Nullable
    Executor mPreviewSurfaceProviderExecutor;
    @Nullable
    private Size mLatestResolution;
    SurfaceHolder mSurfaceHolder;

    @MainThread
    Preview(@NonNull PreviewConfig config) {
        super(config);
    }

    SessionConfig.Builder createPipeline(final @NonNull String cameraId, final @NonNull PreviewConfig config, final @NonNull Size resolution) {
        Threads.checkMainThread();
        Preconditions.checkState((boolean)this.isPreviewSurfaceProviderSet());
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.Builder.createFrom(config);
        CaptureProcessor captureProcessor = config.getCaptureProcessor(null);
        final CallbackDeferrableSurface callbackDeferrableSurface = new CallbackDeferrableSurface(resolution, this.mPreviewSurfaceProviderExecutor, this.mPreviewSurfaceProvider);
        if (captureProcessor != null) {
            CaptureStage.DefaultCaptureStage captureStage = new CaptureStage.DefaultCaptureStage();
            if (this.mProcessingPreviewHandler == null) {
                this.mProcessingPreviewThread = new HandlerThread("ProcessingSurfaceTexture");
                this.mProcessingPreviewThread.start();
                this.mProcessingPreviewHandler = new Handler(this.mProcessingPreviewThread.getLooper());
            }
            ProcessingSurface processingSurface = new ProcessingSurface(resolution.getWidth(), resolution.getHeight(), 35, this.mProcessingPreviewHandler, captureStage, captureProcessor, callbackDeferrableSurface);
            sessionConfigBuilder.addCameraCaptureCallback(processingSurface.getCameraCaptureCallback());
            this.mSurfaceHolder = processingSurface;
            sessionConfigBuilder.addSurface(processingSurface);
            sessionConfigBuilder.setTag(captureStage.getId());
        } else {
            final ImageInfoProcessor processor = config.getImageInfoProcessor(null);
            if (processor != null) {
                sessionConfigBuilder.addCameraCaptureCallback(new CameraCaptureCallback(){

                    @Override
                    public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
                        super.onCaptureCompleted(cameraCaptureResult);
                        if (processor.process(new CameraCaptureResultImageInfo(cameraCaptureResult))) {
                            Preview.this.notifyUpdated();
                        }
                    }
                });
            }
            this.mSurfaceHolder = callbackDeferrableSurface;
            sessionConfigBuilder.addSurface(callbackDeferrableSurface);
        }
        sessionConfigBuilder.addErrorListener(new SessionConfig.ErrorListener(){

            @Override
            public void onError(@NonNull SessionConfig sessionConfig, @NonNull SessionConfig.SessionError error) {
                callbackDeferrableSurface.release();
                if (Preview.this.isCurrentlyBoundCamera(cameraId)) {
                    SessionConfig.Builder sessionConfigBuilder = Preview.this.createPipeline(cameraId, config, resolution);
                    Preview.this.attachToCamera(cameraId, sessionConfigBuilder.build());
                    Preview.this.notifyReset();
                }
            }
        });
        return sessionConfigBuilder;
    }

    @UiThread
    @Nullable
    public PreviewSurfaceProvider getPreviewSurfaceProvider() {
        Threads.checkMainThread();
        return this.mPreviewSurfaceProvider;
    }

    @UiThread
    public void setPreviewSurfaceProvider(@NonNull Executor executor, @Nullable PreviewSurfaceProvider previewSurfaceProvider) {
        Threads.checkMainThread();
        if (previewSurfaceProvider == null) {
            this.mPreviewSurfaceProvider = null;
            this.notifyInactive();
        } else {
            this.mPreviewSurfaceProvider = previewSurfaceProvider;
            this.mPreviewSurfaceProviderExecutor = executor;
            this.notifyActive();
            if (this.mLatestResolution != null) {
                this.updateConfigAndOutput(this.getBoundCameraId(), (PreviewConfig)this.getUseCaseConfig(), this.mLatestResolution);
            }
        }
    }

    @UiThread
    public void setPreviewSurfaceProvider(@Nullable PreviewSurfaceProvider previewSurfaceProvider) {
        this.setPreviewSurfaceProvider(CameraXExecutors.mainThreadExecutor(), previewSurfaceProvider);
    }

    boolean isPreviewSurfaceProviderSet() {
        return this.mPreviewSurfaceProvider != null && this.mPreviewSurfaceProviderExecutor != null;
    }

    private void updateConfigAndOutput(@NonNull String cameraId, @NonNull PreviewConfig config, @NonNull Size resolution) {
        Preconditions.checkState((boolean)this.isPreviewSurfaceProviderSet());
        this.attachToCamera(cameraId, this.createPipeline(cameraId, config, resolution).build());
    }

    @NonNull
    public String toString() {
        return "Preview:" + this.getName();
    }

    @Override
    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected UseCaseConfig.Builder<?, ?, ?> getDefaultBuilder(@Nullable Integer lensFacing) {
        PreviewConfig defaults = CameraX.getDefaultUseCaseConfig(PreviewConfig.class, lensFacing);
        if (defaults != null) {
            return Builder.fromConfig(defaults);
        }
        return null;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected UseCaseConfig<?> applyDefaults(@NonNull UseCaseConfig<?> userConfig, @Nullable UseCaseConfig.Builder<?, ?, ?> defaultConfigBuilder) {
        PreviewConfig previewConfig = (PreviewConfig)super.applyDefaults(userConfig, defaultConfigBuilder);
        CameraInternal boundCamera = this.getBoundCamera();
        if (boundCamera != null && CameraX.getSurfaceManager().requiresCorrectedAspectRatio(boundCamera.getCameraInfoInternal().getCameraId())) {
            PreviewConfig imageConfig = previewConfig;
            Rational resultRatio = CameraX.getSurfaceManager().getCorrectedAspectRatio(boundCamera.getCameraInfoInternal().getCameraId(), imageConfig.getTargetRotation(0));
            if (resultRatio != null) {
                Builder configBuilder = Builder.fromConfig(previewConfig);
                configBuilder.setTargetAspectRatioCustom(resultRatio);
                previewConfig = configBuilder.getUseCaseConfig();
            }
        }
        return previewConfig;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void clear() {
        this.notifyInactive();
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.release();
        }
        super.clear();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected Map<String, Size> onSuggestedResolutionUpdated(@NonNull Map<String, Size> suggestedResolutionMap) {
        String cameraId = this.getBoundCameraId();
        Size resolution = suggestedResolutionMap.get(cameraId);
        if (resolution == null) {
            throw new IllegalArgumentException("Suggested resolution map missing resolution for camera " + cameraId);
        }
        this.mLatestResolution = resolution;
        if (this.isPreviewSurfaceProviderSet()) {
            this.updateConfigAndOutput(cameraId, (PreviewConfig)this.getUseCaseConfig(), resolution);
        }
        return suggestedResolutionMap;
    }

    public static final class Builder
    implements UseCaseConfig.Builder<Preview, PreviewConfig, Builder>,
    ImageOutputConfig.Builder<Builder>,
    CameraDeviceConfig.Builder<Builder>,
    ThreadConfig.Builder<Builder> {
        private final MutableOptionsBundle mMutableConfig;

        public Builder() {
            this(MutableOptionsBundle.create());
        }

        private Builder(MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            Class oldConfigClass = mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(Preview.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setTargetClass((Class)Preview.class);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static Builder fromConfig(@NonNull PreviewConfig configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PreviewConfig getUseCaseConfig() {
            return new PreviewConfig(OptionsBundle.from(this.mMutableConfig));
        }

        @Override
        @NonNull
        public Preview build() {
            if (this.getMutableConfig().retrieveOption(PreviewConfig.OPTION_TARGET_ASPECT_RATIO, null) != null && this.getMutableConfig().retrieveOption(PreviewConfig.OPTION_TARGET_RESOLUTION, null) != null) {
                throw new IllegalArgumentException("Cannot use both setTargetResolution and setTargetAspectRatio on the same config.");
            }
            return new Preview(this.getUseCaseConfig());
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setTargetClass(@NonNull Class<Preview> targetClass) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(PreviewConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_NAME, targetName);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setLensFacing(int lensFacing) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_LENS_FACING, lensFacing);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCameraIdFilter(@NonNull CameraIdFilter cameraIdFilter) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_CAMERA_ID_FILTER, cameraIdFilter);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setTargetAspectRatioCustom(@NonNull Rational aspectRatio) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_ASPECT_RATIO_CUSTOM, aspectRatio);
            this.getMutableConfig().removeOption(PreviewConfig.OPTION_TARGET_ASPECT_RATIO);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetAspectRatio(int aspectRatio) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_ASPECT_RATIO, aspectRatio);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetRotation(int rotation) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_ROTATION, rotation);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION, resolution);
            if (resolution != null) {
                this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_ASPECT_RATIO_CUSTOM, new Rational(resolution.getWidth(), resolution.getHeight()));
            }
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setDefaultResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_DEFAULT_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setMaxResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_MAX_RESOLUTION, resolution);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> resolutions) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_SUPPORTED_RESOLUTIONS, resolutions);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setBackgroundExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_BACKGROUND_EXECUTOR, executor);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_DEFAULT_SESSION_CONFIG, sessionConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_DEFAULT_CAPTURE_CONFIG, captureConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_SESSION_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_CAPTURE_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSurfaceOccupancyPriority(int priority) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, priority);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setUseCaseEventCallback(@NonNull UseCase.EventCallback useCaseEventCallback) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_USE_CASE_EVENT_CALLBACK, useCaseEventCallback);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setImageInfoProcessor(@NonNull ImageInfoProcessor processor) {
            this.getMutableConfig().insertOption(PreviewConfig.IMAGE_INFO_PROCESSOR, processor);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureProcessor(@NonNull CaptureProcessor captureProcessor) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_PREVIEW_CAPTURE_PROCESSOR, captureProcessor);
            return this;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Defaults
    implements ConfigProvider<PreviewConfig> {
        private static final Size DEFAULT_MAX_RESOLUTION = CameraX.getSurfaceManager().getPreviewSize();
        private static final int DEFAULT_SURFACE_OCCUPANCY_PRIORITY = 2;
        private static final PreviewConfig DEFAULT_CONFIG;

        @Override
        public PreviewConfig getConfig(@Nullable Integer lensFacing) {
            return DEFAULT_CONFIG;
        }

        static {
            Builder builder = new Builder().setMaxResolution(DEFAULT_MAX_RESOLUTION).setSurfaceOccupancyPriority(2);
            DEFAULT_CONFIG = builder.getUseCaseConfig();
        }
    }

    public static interface PreviewSurfaceProvider {
        @NonNull
        public ListenableFuture<Surface> provideSurface(@NonNull Size var1, @NonNull ListenableFuture<Void> var2);
    }
}

