/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.Config;
import androidx.camera.core.MutableConfig;
import androidx.camera.core.OptionsBundle;
import java.util.Comparator;
import java.util.TreeMap;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MutableOptionsBundle
extends OptionsBundle
implements MutableConfig {
    private static final Comparator<Config.Option<?>> ID_COMPARE = new Comparator<Config.Option<?>>(){

        @Override
        public int compare(Config.Option<?> o1, Config.Option<?> o2) {
            return o1.getId().compareTo(o2.getId());
        }
    };

    private MutableOptionsBundle(TreeMap<Config.Option<?>, Object> persistentOptions) {
        super(persistentOptions);
    }

    public static MutableOptionsBundle create() {
        return new MutableOptionsBundle(new TreeMap(ID_COMPARE));
    }

    public static MutableOptionsBundle from(Config otherConfig) {
        TreeMap persistentOptions = new TreeMap(ID_COMPARE);
        for (Config.Option<?> opt : otherConfig.listOptions()) {
            persistentOptions.put(opt, otherConfig.retrieveOption(opt));
        }
        return new MutableOptionsBundle(persistentOptions);
    }

    @Override
    @Nullable
    public <ValueT> ValueT removeOption(Config.Option<ValueT> opt) {
        Object value = this.mOptions.remove(opt);
        return (ValueT)value;
    }

    @Override
    public <ValueT> void insertOption(Config.Option<ValueT> opt, ValueT value) {
        this.mOptions.put(opt, value);
    }
}

