/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.location.Location;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageUtil;
import androidx.camera.core.impl.utils.Exif;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.Executor;

final class ImageSaver
implements Runnable {
    private static final String TAG = "ImageSaver";
    @Nullable
    private final Location mLocation;
    private final ImageProxy mImage;
    private final int mOrientation;
    private final boolean mIsReversedHorizontal;
    private final boolean mIsReversedVertical;
    final File mFile;
    private final Executor mExecutor;
    final OnImageSavedCallback mCallback;

    ImageSaver(ImageProxy image, File file, int orientation, boolean reversedHorizontal, boolean reversedVertical, @Nullable Location location, Executor executor, OnImageSavedCallback callback) {
        this.mImage = image;
        this.mFile = file;
        this.mOrientation = orientation;
        this.mIsReversedHorizontal = reversedHorizontal;
        this.mIsReversedVertical = reversedVertical;
        this.mCallback = callback;
        this.mExecutor = executor;
        this.mLocation = location;
    }

    @Override
    public void run() {
        SaveError saveError = null;
        String errorMessage = null;
        Exception exception = null;
        try (ImageProxy imageToClose = this.mImage;
             FileOutputStream output = new FileOutputStream(this.mFile);){
            byte[] bytes = ImageUtil.imageToJpegByteArray(this.mImage);
            output.write(bytes);
            Exif exif = Exif.createFromFile(this.mFile);
            exif.attachTimestamp();
            exif.rotate(this.mOrientation);
            if (this.mIsReversedHorizontal) {
                exif.flipHorizontally();
            }
            if (this.mIsReversedVertical) {
                exif.flipVertically();
            }
            if (this.mLocation != null) {
                exif.attachLocation(this.mLocation);
            }
            exif.save();
        }
        catch (IOException e) {
            saveError = SaveError.FILE_IO_FAILED;
            errorMessage = "Failed to write or close the file";
            exception = e;
        }
        catch (ImageUtil.CodecFailedException e) {
            switch (e.getFailureType()) {
                case ENCODE_FAILED: {
                    saveError = SaveError.ENCODE_FAILED;
                    errorMessage = "Failed to encode mImage";
                    break;
                }
                case DECODE_FAILED: {
                    saveError = SaveError.CROP_FAILED;
                    errorMessage = "Failed to crop mImage";
                    break;
                }
                default: {
                    saveError = SaveError.UNKNOWN;
                    errorMessage = "Failed to transcode mImage";
                }
            }
            exception = e;
        }
        if (saveError != null) {
            this.postError(saveError, errorMessage, exception);
        } else {
            this.postSuccess();
        }
    }

    private void postSuccess() {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ImageSaver.this.mCallback.onImageSaved(ImageSaver.this.mFile);
            }
        });
    }

    private void postError(final SaveError saveError, final String message, final @Nullable Throwable cause) {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ImageSaver.this.mCallback.onError(saveError, message, cause);
            }
        });
    }

    public static interface OnImageSavedCallback {
        public void onImageSaved(File var1);

        public void onError(SaveError var1, String var2, @Nullable Throwable var3);
    }

    public static enum SaveError {
        FILE_IO_FAILED,
        ENCODE_FAILED,
        CROP_FAILED,
        UNKNOWN;

    }
}

