/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CaptureBundle;
import androidx.camera.core.CaptureConfig;
import androidx.camera.core.CaptureProcessor;
import androidx.camera.core.Config;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageOutputConfig;
import androidx.camera.core.IoConfig;
import androidx.camera.core.OptionsBundle;
import androidx.camera.core.SessionConfig;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseConfig;
import androidx.camera.core.impl.CameraDeviceConfig;
import androidx.camera.core.impl.CameraIdFilter;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ImageCaptureConfig
implements UseCaseConfig<ImageCapture>,
ImageOutputConfig,
CameraDeviceConfig,
IoConfig {
    static final Config.Option<Integer> OPTION_IMAGE_CAPTURE_MODE = Config.Option.create("camerax.core.imageCapture.captureMode", Integer.TYPE);
    static final Config.Option<Integer> OPTION_FLASH_MODE = Config.Option.create("camerax.core.imageCapture.flashMode", Integer.TYPE);
    static final Config.Option<CaptureBundle> OPTION_CAPTURE_BUNDLE = Config.Option.create("camerax.core.imageCapture.captureBundle", CaptureBundle.class);
    static final Config.Option<CaptureProcessor> OPTION_CAPTURE_PROCESSOR = Config.Option.create("camerax.core.imageCapture.captureProcessor", CaptureProcessor.class);
    static final Config.Option<Integer> OPTION_BUFFER_FORMAT = Config.Option.create("camerax.core.imageCapture.bufferFormat", Integer.class);
    static final Config.Option<Integer> OPTION_MAX_CAPTURE_STAGES = Config.Option.create("camerax.core.imageCapture.maxCaptureStages", Integer.class);
    private final OptionsBundle mConfig;

    ImageCaptureConfig(OptionsBundle config) {
        this.mConfig = config;
    }

    public boolean hasCaptureMode() {
        return this.containsOption(OPTION_IMAGE_CAPTURE_MODE);
    }

    public int getCaptureMode() {
        return this.retrieveOption(OPTION_IMAGE_CAPTURE_MODE);
    }

    public int getFlashMode() {
        return this.retrieveOption(OPTION_FLASH_MODE);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CaptureBundle getCaptureBundle(@Nullable CaptureBundle valueIfMissing) {
        return this.retrieveOption(OPTION_CAPTURE_BUNDLE, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public CaptureBundle getCaptureBundle() {
        return this.retrieveOption(OPTION_CAPTURE_BUNDLE);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CaptureProcessor getCaptureProcessor(@Nullable CaptureProcessor valueIfMissing) {
        return this.retrieveOption(OPTION_CAPTURE_PROCESSOR, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public CaptureProcessor getCaptureProcessor() {
        return this.retrieveOption(OPTION_CAPTURE_PROCESSOR);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Integer getBufferFormat(@Nullable Integer valueIfMissing) {
        return this.retrieveOption(OPTION_BUFFER_FORMAT, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Integer getBufferFormat() {
        return this.retrieveOption(OPTION_BUFFER_FORMAT);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getMaxCaptureStages(int valueIfMissing) {
        return this.retrieveOption(OPTION_MAX_CAPTURE_STAGES, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getMaxCaptureStages() {
        return this.retrieveOption(OPTION_MAX_CAPTURE_STAGES);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean containsOption(@NonNull Config.Option<?> id) {
        return this.mConfig.containsOption(id);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id) {
        return this.mConfig.retrieveOption(id);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id, @Nullable ValueT valueIfMissing) {
        return this.mConfig.retrieveOption(id, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void findOptions(@NonNull String idStem, @NonNull Config.OptionMatcher matcher) {
        this.mConfig.findOptions(idStem, matcher);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Set<Config.Option<?>> listOptions() {
        return this.mConfig.listOptions();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Class<ImageCapture> getTargetClass(@Nullable Class<ImageCapture> valueIfMissing) {
        Class<ImageCapture> storedClass = this.retrieveOption(OPTION_TARGET_CLASS, valueIfMissing);
        return storedClass;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Class<ImageCapture> getTargetClass() {
        Class storedClass = (Class)this.retrieveOption(OPTION_TARGET_CLASS);
        return storedClass;
    }

    @Override
    @Nullable
    public String getTargetName(@Nullable String valueIfMissing) {
        return this.retrieveOption(OPTION_TARGET_NAME, valueIfMissing);
    }

    @Override
    @NonNull
    public String getTargetName() {
        return (String)this.retrieveOption(OPTION_TARGET_NAME);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Integer getLensFacing(@Nullable Integer valueIfMissing) {
        return this.retrieveOption(OPTION_LENS_FACING, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getLensFacing() {
        return (Integer)this.retrieveOption(OPTION_LENS_FACING);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CameraIdFilter getCameraIdFilter(@Nullable CameraIdFilter valueIfMissing) {
        return this.retrieveOption(OPTION_CAMERA_ID_FILTER, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public CameraIdFilter getCameraIdFilter() {
        return (CameraIdFilter)this.retrieveOption(OPTION_CAMERA_ID_FILTER);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Rational getTargetAspectRatioCustom(@Nullable Rational valueIfMissing) {
        return this.retrieveOption(OPTION_TARGET_ASPECT_RATIO_CUSTOM, valueIfMissing);
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Rational getTargetAspectRatioCustom() {
        return (Rational)this.retrieveOption(OPTION_TARGET_ASPECT_RATIO_CUSTOM);
    }

    @Override
    public boolean hasTargetAspectRatio() {
        return this.containsOption(OPTION_TARGET_ASPECT_RATIO);
    }

    @Override
    public int getTargetAspectRatio() {
        return (Integer)this.retrieveOption(OPTION_TARGET_ASPECT_RATIO);
    }

    @Override
    public int getTargetRotation(int valueIfMissing) {
        return this.retrieveOption(OPTION_TARGET_ROTATION, valueIfMissing);
    }

    @Override
    public int getTargetRotation() {
        return (Integer)this.retrieveOption(OPTION_TARGET_ROTATION);
    }

    @Override
    @Nullable
    public Size getTargetResolution(@Nullable Size valueIfMissing) {
        return this.retrieveOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION, valueIfMissing);
    }

    @Override
    @NonNull
    public Size getTargetResolution() {
        return this.retrieveOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION);
    }

    @Override
    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Size getDefaultResolution(@Nullable Size valueIfMissing) {
        return this.retrieveOption(OPTION_DEFAULT_RESOLUTION, valueIfMissing);
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Size getDefaultResolution() {
        return (Size)this.retrieveOption(OPTION_DEFAULT_RESOLUTION);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Size getMaxResolution(@Nullable Size valueIfMissing) {
        return this.retrieveOption(OPTION_MAX_RESOLUTION, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Size getMaxResolution() {
        return (Size)this.retrieveOption(OPTION_MAX_RESOLUTION);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public List<Pair<Integer, Size[]>> getSupportedResolutions(@Nullable List<Pair<Integer, Size[]>> valueIfMissing) {
        return this.retrieveOption(OPTION_SUPPORTED_RESOLUTIONS, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public List<Pair<Integer, Size[]>> getSupportedResolutions() {
        return (List)this.retrieveOption(OPTION_SUPPORTED_RESOLUTIONS);
    }

    @Override
    @Nullable
    public Executor getIoExecutor(@Nullable Executor valueIfMissing) {
        return this.retrieveOption(OPTION_IO_EXECUTOR, valueIfMissing);
    }

    @Override
    @NonNull
    public Executor getIoExecutor() {
        return (Executor)this.retrieveOption(OPTION_IO_EXECUTOR);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public SessionConfig getDefaultSessionConfig(@Nullable SessionConfig valueIfMissing) {
        return this.retrieveOption(OPTION_DEFAULT_SESSION_CONFIG, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public SessionConfig getDefaultSessionConfig() {
        return (SessionConfig)this.retrieveOption(OPTION_DEFAULT_SESSION_CONFIG);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CaptureConfig getDefaultCaptureConfig(@Nullable CaptureConfig valueIfMissing) {
        return this.retrieveOption(OPTION_DEFAULT_CAPTURE_CONFIG, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public CaptureConfig getDefaultCaptureConfig() {
        return (CaptureConfig)this.retrieveOption(OPTION_DEFAULT_CAPTURE_CONFIG);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public SessionConfig.OptionUnpacker getSessionOptionUnpacker(@Nullable SessionConfig.OptionUnpacker valueIfMissing) {
        return this.retrieveOption(OPTION_SESSION_CONFIG_UNPACKER, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public SessionConfig.OptionUnpacker getSessionOptionUnpacker() {
        return (SessionConfig.OptionUnpacker)this.retrieveOption(OPTION_SESSION_CONFIG_UNPACKER);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CaptureConfig.OptionUnpacker getCaptureOptionUnpacker(@Nullable CaptureConfig.OptionUnpacker valueIfMissing) {
        return this.retrieveOption(OPTION_CAPTURE_CONFIG_UNPACKER, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public CaptureConfig.OptionUnpacker getCaptureOptionUnpacker() {
        return (CaptureConfig.OptionUnpacker)this.retrieveOption(OPTION_CAPTURE_CONFIG_UNPACKER);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getSurfaceOccupancyPriority(int valueIfMissing) {
        return this.retrieveOption(OPTION_SURFACE_OCCUPANCY_PRIORITY, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getSurfaceOccupancyPriority() {
        return (Integer)this.retrieveOption(OPTION_SURFACE_OCCUPANCY_PRIORITY);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public UseCase.EventCallback getUseCaseEventCallback(@Nullable UseCase.EventCallback valueIfMissing) {
        return this.retrieveOption(OPTION_USE_CASE_EVENT_CALLBACK, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public UseCase.EventCallback getUseCaseEventCallback() {
        return (UseCase.EventCallback)this.retrieveOption(OPTION_USE_CASE_EVENT_CALLBACK);
    }
}

