/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.annotation.SuppressLint;
import android.location.Location;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.camera.core.CameraClosedException;
import androidx.camera.core.CameraX;
import androidx.camera.core.CaptureBundle;
import androidx.camera.core.CaptureBundles;
import androidx.camera.core.CaptureConfig;
import androidx.camera.core.CaptureProcessor;
import androidx.camera.core.CaptureStage;
import androidx.camera.core.ConfigProvider;
import androidx.camera.core.DeferrableSurface;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageCaptureConfig;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageOutputConfig;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderFormatRecommender;
import androidx.camera.core.ImageReaderProxy;
import androidx.camera.core.ImageSaver;
import androidx.camera.core.ImageUtil;
import androidx.camera.core.ImmediateSurface;
import androidx.camera.core.ImmutableImageInfo;
import androidx.camera.core.IoConfig;
import androidx.camera.core.MetadataImageReader;
import androidx.camera.core.MutableConfig;
import androidx.camera.core.MutableOptionsBundle;
import androidx.camera.core.OptionsBundle;
import androidx.camera.core.ProcessingImageReader;
import androidx.camera.core.SessionConfig;
import androidx.camera.core.SettableImageProxy;
import androidx.camera.core.SingleCloseImageProxy;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseConfig;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureFailure;
import androidx.camera.core.impl.CameraCaptureMetaData;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CameraDeviceConfig;
import androidx.camera.core.impl.CameraIdFilter;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.TargetConfig;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ImageCapture
extends UseCase {
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_FILE_IO = 1;
    public static final int ERROR_CAPTURE_FAILED = 2;
    public static final int ERROR_CAMERA_CLOSED = 3;
    public static final int ERROR_INVALID_CAMERA = 4;
    public static final int CAPTURE_MODE_MAXIMIZE_QUALITY = 0;
    public static final int CAPTURE_MODE_MINIMIZE_LATENCY = 1;
    public static final int FLASH_MODE_AUTO = 0;
    public static final int FLASH_MODE_ON = 1;
    public static final int FLASH_MODE_OFF = 2;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Defaults DEFAULT_CONFIG = new Defaults();
    private static final String TAG = "ImageCapture";
    private static final long CHECK_3A_TIMEOUT_IN_MS = 1000L;
    private static final int MAX_IMAGES = 2;
    private static final Metadata EMPTY_METADATA = new Metadata();
    @Nullable
    private HandlerThread mProcessingImageResultThread;
    @Nullable
    private Handler mProcessingImageResultHandler;
    final Deque<ImageCaptureRequest> mImageCaptureRequests = new ConcurrentLinkedDeque<ImageCaptureRequest>();
    SessionConfig.Builder mSessionConfigBuilder;
    private final CaptureConfig mCaptureConfig;
    private final ExecutorService mExecutor = Executors.newFixedThreadPool(1, new ThreadFactory(){
        private final AtomicInteger mId = new AtomicInteger(0);

        @Override
        public Thread newThread(@NonNull Runnable r) {
            return new Thread(r, "CameraX-image_capture_" + this.mId.getAndIncrement());
        }
    });
    @NonNull
    final Executor mIoExecutor;
    private final CaptureCallbackChecker mSessionCallbackChecker = new CaptureCallbackChecker();
    private final int mCaptureMode;
    private final CaptureBundle mCaptureBundle;
    private final int mMaxCaptureStages;
    private final CaptureProcessor mCaptureProcessor;
    private final Builder mUseCaseConfigBuilder;
    ImageReaderProxy mImageReader;
    private CameraCaptureCallback mMetadataMatchingCaptureCallback;
    private ImageCaptureConfig mConfig;
    private DeferrableSurface mDeferrableSurface;
    private boolean mEnableCheck3AConverged;
    private int mFlashMode;
    final ForwardingImageProxy.OnImageCloseListener mOnImageCloseListener = new ForwardingImageProxy.OnImageCloseListener(){

        @Override
        public void onImageClose(ImageProxy image) {
            if (Looper.getMainLooper() != Looper.myLooper()) {
                CameraXExecutors.mainThreadExecutor().execute(() -> this.onImageClose(image));
                return;
            }
            ImageCapture.this.mImageCaptureRequests.poll();
            ImageCapture.this.issueImageCaptureRequests();
        }
    };

    ImageCapture(@NonNull ImageCaptureConfig userConfig) {
        super(userConfig);
        this.mUseCaseConfigBuilder = Builder.fromConfig(userConfig);
        this.mConfig = (ImageCaptureConfig)this.getUseCaseConfig();
        this.mCaptureMode = this.mConfig.getCaptureMode();
        this.mFlashMode = this.mConfig.getFlashMode();
        this.mCaptureProcessor = this.mConfig.getCaptureProcessor(null);
        this.mMaxCaptureStages = this.mConfig.getMaxCaptureStages(2);
        if (this.mMaxCaptureStages < 1) {
            throw new IllegalArgumentException("Maximum outstanding image count must be at least 1");
        }
        Integer bufferFormat = this.mConfig.getBufferFormat(null);
        if (bufferFormat != null) {
            if (this.mCaptureProcessor != null) {
                throw new IllegalArgumentException("Cannot set buffer format with CaptureProcessor defined.");
            }
            this.setImageFormat(bufferFormat);
        } else if (this.mCaptureProcessor != null) {
            this.setImageFormat(35);
        } else {
            this.setImageFormat(ImageReaderFormatRecommender.chooseCombo().imageCaptureFormat());
        }
        this.mCaptureBundle = this.mConfig.getCaptureBundle(CaptureBundles.singleDefaultCaptureBundle());
        this.mIoExecutor = this.mConfig.getIoExecutor(CameraXExecutors.ioExecutor());
        if (this.mCaptureMode == 0) {
            this.mEnableCheck3AConverged = true;
        } else if (this.mCaptureMode == 1) {
            this.mEnableCheck3AConverged = false;
        }
        CaptureConfig.Builder captureBuilder = CaptureConfig.Builder.createFrom(this.mConfig);
        this.mCaptureConfig = captureBuilder.build();
    }

    SessionConfig.Builder createPipeline(final @NonNull String cameraId, final @NonNull ImageCaptureConfig config, final @NonNull Size resolution) {
        Threads.checkMainThread();
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.Builder.createFrom(config);
        sessionConfigBuilder.addRepeatingCameraCaptureCallback(this.mSessionCallbackChecker);
        this.mProcessingImageResultThread = new HandlerThread("OnImageAvailableHandlerThread");
        this.mProcessingImageResultThread.start();
        this.mProcessingImageResultHandler = new Handler(this.mProcessingImageResultThread.getLooper());
        if (this.mCaptureProcessor != null) {
            ProcessingImageReader processingImageReader = new ProcessingImageReader(resolution.getWidth(), resolution.getHeight(), this.getImageFormat(), this.mMaxCaptureStages, this.mProcessingImageResultHandler, this.getCaptureBundle(CaptureBundles.singleDefaultCaptureBundle()), this.mCaptureProcessor);
            this.mMetadataMatchingCaptureCallback = processingImageReader.getCameraCaptureCallback();
            this.mImageReader = processingImageReader;
        } else {
            MetadataImageReader metadataImageReader = new MetadataImageReader(resolution.getWidth(), resolution.getHeight(), this.getImageFormat(), 2, this.mProcessingImageResultHandler);
            this.mMetadataMatchingCaptureCallback = metadataImageReader.getCameraCaptureCallback();
            this.mImageReader = metadataImageReader;
        }
        this.mImageReader.setOnImageAvailableListener(new ImageReaderProxy.OnImageAvailableListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onImageAvailable(ImageReaderProxy imageReader) {
                ImageProxy image = null;
                try {
                    image = imageReader.acquireLatestImage();
                }
                catch (IllegalStateException e) {
                    Log.e((String)ImageCapture.TAG, (String)"Failed to acquire latest image.", (Throwable)e);
                }
                finally {
                    if (image != null) {
                        ImageCaptureRequest imageCaptureRequest = ImageCapture.this.mImageCaptureRequests.peek();
                        if (imageCaptureRequest != null) {
                            SingleCloseImageProxy wrappedImage = new SingleCloseImageProxy(image);
                            wrappedImage.addOnImageCloseListener(ImageCapture.this.mOnImageCloseListener);
                            imageCaptureRequest.dispatchImage(wrappedImage);
                        } else {
                            image.close();
                        }
                    }
                }
            }
        }, this.mProcessingImageResultHandler);
        this.mDeferrableSurface = new ImmediateSurface(this.mImageReader.getSurface());
        sessionConfigBuilder.addNonRepeatingSurface(this.mDeferrableSurface);
        sessionConfigBuilder.addErrorListener(new SessionConfig.ErrorListener(){

            @Override
            public void onError(@NonNull SessionConfig sessionConfig, @NonNull SessionConfig.SessionError error) {
                ImageCapture.this.clearPipeline();
                if (ImageCapture.this.isCurrentlyBoundCamera(cameraId)) {
                    ImageCapture.this.mSessionConfigBuilder = ImageCapture.this.createPipeline(cameraId, config, resolution);
                    ImageCapture.this.attachToCamera(cameraId, ImageCapture.this.mSessionConfigBuilder.build());
                    ImageCapture.this.notifyReset();
                }
            }
        });
        return sessionConfigBuilder;
    }

    void clearPipeline() {
        Threads.checkMainThread();
        DeferrableSurface deferrableSurface = this.mDeferrableSurface;
        this.mDeferrableSurface = null;
        final ImageReaderProxy imageReaderProxy = this.mImageReader;
        this.mImageReader = null;
        final HandlerThread handlerThread = this.mProcessingImageResultThread;
        if (deferrableSurface != null) {
            deferrableSurface.setOnSurfaceDetachedListener(CameraXExecutors.mainThreadExecutor(), new DeferrableSurface.OnSurfaceDetachedListener(){

                @Override
                public void onSurfaceDetached() {
                    if (imageReaderProxy != null) {
                        imageReaderProxy.close();
                    }
                    handlerThread.quitSafely();
                }
            });
        }
    }

    @Override
    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected UseCaseConfig.Builder<?, ?, ?> getDefaultBuilder(@Nullable Integer lensFacing) {
        ImageCaptureConfig defaults = CameraX.getDefaultUseCaseConfig(ImageCaptureConfig.class, lensFacing);
        if (defaults != null) {
            return Builder.fromConfig(defaults);
        }
        return null;
    }

    private CameraControlInternal getCurrentCameraControl() {
        String cameraId = this.getBoundCameraId();
        return this.getCameraControl(cameraId);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void onCameraControlReady(@NonNull String cameraId) {
        this.getCameraControl(cameraId).setFlashMode(this.mFlashMode);
    }

    public int getFlashMode() {
        return this.mFlashMode;
    }

    public void setFlashMode(int flashMode) {
        this.mFlashMode = flashMode;
        if (this.getBoundCamera() != null) {
            this.getCurrentCameraControl().setFlashMode(flashMode);
        }
    }

    public void setTargetAspectRatioCustom(@NonNull Rational aspectRatio) {
        ImageOutputConfig oldConfig = (ImageOutputConfig)((Object)this.getUseCaseConfig());
        Rational oldRatio = oldConfig.getTargetAspectRatioCustom(null);
        if (!aspectRatio.equals((Object)oldRatio)) {
            this.mUseCaseConfigBuilder.setTargetAspectRatioCustom(aspectRatio);
            this.updateUseCaseConfig(this.mUseCaseConfigBuilder.getUseCaseConfig());
            this.mConfig = (ImageCaptureConfig)this.getUseCaseConfig();
        }
    }

    public void setTargetRotation(int rotation) {
        ImageOutputConfig oldConfig = (ImageOutputConfig)((Object)this.getUseCaseConfig());
        int oldRotation = oldConfig.getTargetRotation(-1);
        if (oldRotation == -1 || oldRotation != rotation) {
            this.mUseCaseConfigBuilder.setTargetRotation(rotation);
            this.updateUseCaseConfig(this.mUseCaseConfigBuilder.build().getUseCaseConfig());
            this.mConfig = (ImageCaptureConfig)this.getUseCaseConfig();
        }
    }

    @SuppressLint(value={"LambdaLast"})
    public void takePicture(@NonNull Executor executor, @NonNull OnImageCapturedCallback callback) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            CameraXExecutors.mainThreadExecutor().execute(() -> this.takePicture(executor, callback));
            return;
        }
        this.sendImageCaptureRequest(executor, callback);
    }

    @SuppressLint(value={"LambdaLast", "StreamFiles"})
    public void takePicture(@NonNull File saveLocation, @NonNull Executor executor, @NonNull OnImageSavedCallback imageSavedCallback) {
        this.takePicture(saveLocation, EMPTY_METADATA, executor, imageSavedCallback);
    }

    @SuppressLint(value={"LambdaLast", "StreamFiles"})
    public void takePicture(final @NonNull File saveLocation, final @NonNull Metadata metadata, final @NonNull Executor executor, final @NonNull OnImageSavedCallback imageSavedCallback) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            CameraXExecutors.mainThreadExecutor().execute(() -> this.takePicture(saveLocation, metadata, executor, imageSavedCallback));
            return;
        }
        final ImageSaver.OnImageSavedCallback imageSavedCallbackWrapper = new ImageSaver.OnImageSavedCallback(){

            @Override
            public void onImageSaved(File file) {
                imageSavedCallback.onImageSaved(file);
            }

            @Override
            public void onError(ImageSaver.SaveError error, String message, @Nullable Throwable cause) {
                int imageCaptureError = 0;
                switch (error) {
                    case FILE_IO_FAILED: {
                        imageCaptureError = 1;
                        break;
                    }
                }
                imageSavedCallback.onError(imageCaptureError, message, cause);
            }
        };
        OnImageCapturedCallback imageCaptureCallbackWrapper = new OnImageCapturedCallback(){

            @Override
            public void onCaptureSuccess(@NonNull ImageProxy image) {
                ImageCapture.this.mIoExecutor.execute(new ImageSaver(image, saveLocation, image.getImageInfo().getRotationDegrees(), metadata.isReversedHorizontal(), metadata.isReversedVertical(), metadata.getLocation(), executor, imageSavedCallbackWrapper));
            }

            @Override
            public void onError(int error, @NonNull String message, @Nullable Throwable cause) {
                imageSavedCallback.onError(error, message, cause);
            }
        };
        this.sendImageCaptureRequest(CameraXExecutors.mainThreadExecutor(), imageCaptureCallbackWrapper);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @UiThread
    public void onStateOffline(@NonNull String cameraId) {
        super.onStateOffline(cameraId);
        this.abortImagecaptureRequests();
    }

    private void abortImagecaptureRequests() {
        CameraClosedException throwable = new CameraClosedException("Camera is closed.");
        for (ImageCaptureRequest captureRequest : this.mImageCaptureRequests) {
            captureRequest.notifyCallbackError(this.getError(throwable), throwable.getMessage(), throwable);
        }
        this.mImageCaptureRequests.clear();
    }

    @UiThread
    private void sendImageCaptureRequest(@Nullable Executor listenerExecutor, OnImageCapturedCallback callback) {
        String cameraId;
        try {
            cameraId = this.getBoundCameraId();
        }
        catch (Throwable e) {
            callback.onError(4, "Not bound to a valid Camera [" + this + "]", e);
            return;
        }
        CameraInfoInternal cameraInfoInternal = CameraX.getCameraInfo(cameraId);
        int relativeRotation = cameraInfoInternal.getSensorRotationDegrees(this.mConfig.getTargetRotation(0));
        Rational targetRatio = this.mConfig.getTargetAspectRatioCustom(null);
        targetRatio = ImageUtil.rotate(targetRatio, relativeRotation);
        this.mImageCaptureRequests.offer(new ImageCaptureRequest(relativeRotation, targetRatio, listenerExecutor, callback));
        if (this.mImageCaptureRequests.size() == 1) {
            this.issueImageCaptureRequests();
        }
    }

    @UiThread
    void issueImageCaptureRequests() {
        if (this.mImageCaptureRequests.isEmpty()) {
            return;
        }
        this.takePictureInternal();
    }

    private void takePictureInternal() {
        final TakePictureState state = new TakePictureState();
        FutureChain.from(this.preTakePicture(state)).transformAsync(v -> this.issueTakePicture(), this.mExecutor).addCallback(new FutureCallback<Void>(){

            @Override
            public void onSuccess(Void result) {
                ImageCapture.this.postTakePicture(state);
            }

            @Override
            public void onFailure(Throwable throwable) {
                Log.e((String)ImageCapture.TAG, (String)"takePictureInternal onFailure", (Throwable)throwable);
                ImageCapture.this.postTakePicture(state);
                CameraXExecutors.mainThreadExecutor().execute(() -> {
                    ImageCaptureRequest request = ImageCapture.this.mImageCaptureRequests.poll();
                    if (request == null) {
                        return;
                    }
                    request.notifyCallbackError(ImageCapture.this.getError(throwable), throwable != null ? throwable.getMessage() : "Unknown error", throwable);
                    ImageCapture.this.issueImageCaptureRequests();
                });
            }
        }, this.mExecutor);
    }

    @NonNull
    public String toString() {
        return "ImageCapture:" + this.getName();
    }

    int getError(Throwable throwable) {
        if (throwable instanceof CameraClosedException) {
            return 3;
        }
        if (throwable instanceof CaptureFailedException) {
            return 2;
        }
        return 0;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void clear() {
        this.clearPipeline();
        this.mExecutor.shutdown();
        super.clear();
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected Map<String, Size> onSuggestedResolutionUpdated(@NonNull Map<String, Size> suggestedResolutionMap) {
        String cameraId = this.getBoundCameraId();
        Size resolution = suggestedResolutionMap.get(cameraId);
        if (resolution == null) {
            throw new IllegalArgumentException("Suggested resolution map missing resolution for camera " + cameraId);
        }
        if (this.mImageReader != null) {
            if (this.mImageReader.getHeight() == resolution.getHeight() && this.mImageReader.getWidth() == resolution.getWidth()) {
                return suggestedResolutionMap;
            }
            this.mImageReader.close();
        }
        this.mSessionConfigBuilder = this.createPipeline(cameraId, this.mConfig, resolution);
        this.attachToCamera(cameraId, this.mSessionConfigBuilder.build());
        this.notifyActive();
        return suggestedResolutionMap;
    }

    private ListenableFuture<Void> preTakePicture(TakePictureState state) {
        return FutureChain.from(this.getPreCaptureStateIfNeeded()).transformAsync(captureResult -> {
            state.mPreCaptureState = captureResult;
            this.triggerAfIfNeeded(state);
            if (this.isFlashRequired(state)) {
                state.mIsFlashTriggered = true;
                this.triggerAePrecapture(state);
            }
            return this.check3AConverged(state);
        }, this.mExecutor).transform(is3AConverged -> null, this.mExecutor);
    }

    void postTakePicture(TakePictureState state) {
        this.mExecutor.execute(() -> this.cancelAfAeTrigger(state));
    }

    private ListenableFuture<CameraCaptureResult> getPreCaptureStateIfNeeded() {
        if (this.mEnableCheck3AConverged || this.getFlashMode() == 0) {
            return this.mSessionCallbackChecker.checkCaptureResult(new CaptureCallbackChecker.CaptureResultChecker<CameraCaptureResult>(){

                @Override
                public CameraCaptureResult check(@NonNull CameraCaptureResult captureResult) {
                    return captureResult;
                }
            });
        }
        return Futures.immediateFuture(null);
    }

    boolean isFlashRequired(TakePictureState state) {
        switch (this.getFlashMode()) {
            case 1: {
                return true;
            }
            case 0: {
                return state.mPreCaptureState.getAeState() == CameraCaptureMetaData.AeState.FLASH_REQUIRED;
            }
            case 2: {
                return false;
            }
        }
        throw new AssertionError(this.getFlashMode());
    }

    ListenableFuture<Boolean> check3AConverged(TakePictureState state) {
        if (!this.mEnableCheck3AConverged && !state.mIsFlashTriggered) {
            return Futures.immediateFuture(false);
        }
        if (this.is3AConverged(state.mPreCaptureState)) {
            return Futures.immediateFuture(true);
        }
        return this.mSessionCallbackChecker.checkCaptureResult(new CaptureCallbackChecker.CaptureResultChecker<Boolean>(){

            @Override
            public Boolean check(@NonNull CameraCaptureResult captureResult) {
                if (ImageCapture.this.is3AConverged(captureResult)) {
                    return true;
                }
                return null;
            }
        }, 1000L, false);
    }

    boolean is3AConverged(CameraCaptureResult captureResult) {
        if (captureResult == null) {
            return false;
        }
        boolean isAfReady = captureResult.getAfMode() == CameraCaptureMetaData.AfMode.ON_CONTINUOUS_AUTO || captureResult.getAfMode() == CameraCaptureMetaData.AfMode.OFF || captureResult.getAfMode() == CameraCaptureMetaData.AfMode.UNKNOWN || captureResult.getAfState() == CameraCaptureMetaData.AfState.FOCUSED || captureResult.getAfState() == CameraCaptureMetaData.AfState.LOCKED_FOCUSED || captureResult.getAfState() == CameraCaptureMetaData.AfState.LOCKED_NOT_FOCUSED;
        boolean isAeReady = captureResult.getAeState() == CameraCaptureMetaData.AeState.CONVERGED || captureResult.getAeState() == CameraCaptureMetaData.AeState.UNKNOWN;
        boolean isAwbReady = captureResult.getAwbState() == CameraCaptureMetaData.AwbState.CONVERGED || captureResult.getAwbState() == CameraCaptureMetaData.AwbState.UNKNOWN;
        return isAfReady && isAeReady && isAwbReady;
    }

    void triggerAfIfNeeded(TakePictureState state) {
        if (this.mEnableCheck3AConverged && state.mPreCaptureState.getAfMode() == CameraCaptureMetaData.AfMode.ON_MANUAL_AUTO && state.mPreCaptureState.getAfState() == CameraCaptureMetaData.AfState.INACTIVE) {
            this.triggerAf(state);
        }
    }

    private void triggerAf(TakePictureState state) {
        state.mIsAfTriggered = true;
        this.getCurrentCameraControl().triggerAf();
    }

    void triggerAePrecapture(TakePictureState state) {
        state.mIsAePrecaptureTriggered = true;
        this.getCurrentCameraControl().triggerAePrecapture();
    }

    void cancelAfAeTrigger(TakePictureState state) {
        if (!state.mIsAfTriggered && !state.mIsAePrecaptureTriggered) {
            return;
        }
        this.getCurrentCameraControl().cancelAfAeTrigger(state.mIsAfTriggered, state.mIsAePrecaptureTriggered);
        state.mIsAfTriggered = false;
        state.mIsAePrecaptureTriggered = false;
    }

    ListenableFuture<Void> issueTakePicture() {
        CaptureBundle captureBundle;
        ArrayList<ListenableFuture> futureList = new ArrayList<ListenableFuture>();
        ArrayList<CaptureConfig> captureConfigs = new ArrayList<CaptureConfig>();
        if (this.mCaptureProcessor != null) {
            captureBundle = this.getCaptureBundle(null);
            if (captureBundle == null) {
                return Futures.immediateFailedFuture(new IllegalArgumentException("ImageCapture cannot set empty CaptureBundle."));
            }
            if (captureBundle.getCaptureStages().size() > this.mMaxCaptureStages) {
                return Futures.immediateFailedFuture(new IllegalArgumentException("ImageCapture has CaptureStages > Max CaptureStage size"));
            }
            ((ProcessingImageReader)this.mImageReader).setCaptureBundle(captureBundle);
        } else {
            captureBundle = this.getCaptureBundle(CaptureBundles.singleDefaultCaptureBundle());
            if (captureBundle.getCaptureStages().size() > 1) {
                return Futures.immediateFailedFuture(new IllegalArgumentException("ImageCapture have no CaptureProcess set with CaptureBundle size > 1."));
            }
        }
        for (CaptureStage captureStage : captureBundle.getCaptureStages()) {
            CaptureConfig.Builder builder = new CaptureConfig.Builder();
            builder.setTemplateType(this.mCaptureConfig.getTemplateType());
            builder.addImplementationOptions(this.mCaptureConfig.getImplementationOptions());
            builder.addAllCameraCaptureCallbacks(this.mSessionConfigBuilder.getSingleCameraCaptureCallbacks());
            builder.addSurface(this.mDeferrableSurface);
            builder.addImplementationOptions(captureStage.getCaptureConfig().getImplementationOptions());
            builder.setTag(captureStage.getCaptureConfig().getTag());
            builder.addCameraCaptureCallback(this.mMetadataMatchingCaptureCallback);
            ListenableFuture future = CallbackToFutureAdapter.getFuture(completer -> {
                CameraCaptureCallback completerCallback = new CameraCaptureCallback(){

                    @Override
                    public void onCaptureCompleted(@NonNull CameraCaptureResult result) {
                        completer.set(null);
                    }

                    @Override
                    public void onCaptureFailed(@NonNull CameraCaptureFailure failure) {
                        String msg = "Capture request failed with reason " + (Object)((Object)failure.getReason());
                        completer.setException((Throwable)new CaptureFailedException(msg));
                    }

                    @Override
                    public void onCaptureCancelled() {
                        String msg = "Capture request is cancelled because camera is closed";
                        completer.setException((Throwable)new CameraClosedException(msg));
                    }
                };
                builder.addCameraCaptureCallback(completerCallback);
                captureConfigs.add(builder.build());
                return "issueTakePicture[stage=" + captureStage.getId() + "]";
            });
            futureList.add(future);
        }
        this.getCurrentCameraControl().submitCaptureRequests(captureConfigs);
        return Futures.transform(Futures.allAsList(futureList), input -> null, CameraXExecutors.directExecutor());
    }

    private CaptureBundle getCaptureBundle(CaptureBundle defaultCaptureBundle) {
        List<CaptureStage> captureStages = this.mCaptureBundle.getCaptureStages();
        if (captureStages == null || captureStages.isEmpty()) {
            return defaultCaptureBundle;
        }
        return CaptureBundles.createCaptureBundle(captureStages);
    }

    public static final class Builder
    implements UseCaseConfig.Builder<ImageCapture, ImageCaptureConfig, Builder>,
    ImageOutputConfig.Builder<Builder>,
    CameraDeviceConfig.Builder<Builder>,
    IoConfig.Builder<Builder> {
        private final MutableOptionsBundle mMutableConfig;

        public Builder() {
            this(MutableOptionsBundle.create());
        }

        private Builder(MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            Class oldConfigClass = mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(ImageCapture.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setTargetClass((Class)ImageCapture.class);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static Builder fromConfig(@NonNull ImageCaptureConfig configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public ImageCaptureConfig getUseCaseConfig() {
            return new ImageCaptureConfig(OptionsBundle.from(this.mMutableConfig));
        }

        @Override
        @NonNull
        public ImageCapture build() {
            if (this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_TARGET_ASPECT_RATIO, null) != null && this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_TARGET_RESOLUTION, null) != null) {
                throw new IllegalArgumentException("Cannot use both setTargetResolution and setTargetAspectRatio on the same config.");
            }
            return new ImageCapture(this.getUseCaseConfig());
        }

        @NonNull
        public Builder setCaptureMode(int captureMode) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_IMAGE_CAPTURE_MODE, captureMode);
            return this;
        }

        @NonNull
        public Builder setFlashMode(int flashMode) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_FLASH_MODE, flashMode);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureBundle(@NonNull CaptureBundle captureBundle) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_CAPTURE_BUNDLE, captureBundle);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureProcessor(@NonNull CaptureProcessor captureProcessor) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_CAPTURE_PROCESSOR, captureProcessor);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setBufferFormat(int bufferImageFormat) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, bufferImageFormat);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setMaxCaptureStages(int maxCaptureStages) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_MAX_CAPTURE_STAGES, maxCaptureStages);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> resolutions) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_SUPPORTED_RESOLUTIONS, resolutions);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setTargetClass(@NonNull Class<ImageCapture> targetClass) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_NAME, targetName);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setLensFacing(int lensFacing) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_LENS_FACING, lensFacing);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCameraIdFilter(@NonNull CameraIdFilter cameraIdFilter) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_CAMERA_ID_FILTER, cameraIdFilter);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setTargetAspectRatioCustom(@NonNull Rational aspectRatio) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_ASPECT_RATIO_CUSTOM, aspectRatio);
            this.getMutableConfig().removeOption(ImageCaptureConfig.OPTION_TARGET_ASPECT_RATIO);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetAspectRatio(int aspectRatio) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_ASPECT_RATIO, aspectRatio);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetRotation(int rotation) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_ROTATION, rotation);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_RESOLUTION, resolution);
            if (resolution != null) {
                this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_ASPECT_RATIO_CUSTOM, new Rational(resolution.getWidth(), resolution.getHeight()));
            }
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setDefaultResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_DEFAULT_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setMaxResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_MAX_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        public Builder setIoExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_IO_EXECUTOR, executor);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_DEFAULT_SESSION_CONFIG, sessionConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_DEFAULT_CAPTURE_CONFIG, captureConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_SESSION_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_CAPTURE_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSurfaceOccupancyPriority(int priority) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, priority);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setUseCaseEventCallback(@NonNull UseCase.EventCallback useCaseEventCallback) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_USE_CASE_EVENT_CALLBACK, useCaseEventCallback);
            return this;
        }
    }

    private final class ImageCaptureRequest {
        int mRotationDegrees;
        Rational mTargetRatio;
        @NonNull
        Executor mListenerExecutor;
        @NonNull
        OnImageCapturedCallback mCallback;

        ImageCaptureRequest(int rotationDegrees, @NonNull Rational targetRatio, @NonNull Executor executor, OnImageCapturedCallback callback) {
            this.mRotationDegrees = rotationDegrees;
            this.mTargetRatio = targetRatio;
            this.mListenerExecutor = executor;
            this.mCallback = callback;
        }

        void dispatchImage(ImageProxy image) {
            try {
                this.mListenerExecutor.execute(() -> {
                    Size sourceSize = new Size(image.getWidth(), image.getHeight());
                    if (ImageUtil.isAspectRatioValid(sourceSize, this.mTargetRatio)) {
                        image.setCropRect(ImageUtil.computeCropRectFromAspectRatio(sourceSize, this.mTargetRatio));
                    }
                    ImageInfo imageInfo = ImmutableImageInfo.create(image.getImageInfo().getTag(), image.getImageInfo().getTimestamp(), this.mRotationDegrees);
                    this.mCallback.onCaptureSuccess(new SettableImageProxy(image, imageInfo));
                });
            }
            catch (RejectedExecutionException e) {
                Log.e((String)ImageCapture.TAG, (String)"Unable to post to the supplied executor.");
                image.close();
            }
        }

        void notifyCallbackError(int imageCaptureError, String message, Throwable cause) {
            try {
                this.mListenerExecutor.execute(() -> this.mCallback.onError(imageCaptureError, message, cause));
            }
            catch (RejectedExecutionException e) {
                Log.e((String)ImageCapture.TAG, (String)"Unable to post to the supplied executor.");
            }
        }
    }

    static final class CaptureCallbackChecker
    extends CameraCaptureCallback {
        private static final long NO_TIMEOUT = 0L;
        private final Set<CaptureResultListener> mCaptureResultListeners = new HashSet<CaptureResultListener>();

        CaptureCallbackChecker() {
        }

        @Override
        public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
            this.deliverCaptureResultToListeners(cameraCaptureResult);
        }

        <T> ListenableFuture<T> checkCaptureResult(CaptureResultChecker<T> checker) {
            return this.checkCaptureResult(checker, 0L, null);
        }

        <T> ListenableFuture<T> checkCaptureResult(final CaptureResultChecker<T> checker, final long timeoutInMs, final T defValue) {
            if (timeoutInMs < 0L) {
                throw new IllegalArgumentException("Invalid timeout value: " + timeoutInMs);
            }
            final long startTimeInMs = timeoutInMs != 0L ? SystemClock.elapsedRealtime() : 0L;
            return CallbackToFutureAdapter.getFuture(completer -> {
                this.addListener(new CaptureResultListener(){

                    @Override
                    public boolean onCaptureResult(@NonNull CameraCaptureResult captureResult) {
                        Object result = checker.check(captureResult);
                        if (result != null) {
                            completer.set(result);
                            return true;
                        }
                        if (startTimeInMs > 0L && SystemClock.elapsedRealtime() - startTimeInMs > timeoutInMs) {
                            completer.set(defValue);
                            return true;
                        }
                        return false;
                    }
                });
                return "checkCaptureResult";
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deliverCaptureResultToListeners(@NonNull CameraCaptureResult captureResult) {
            Set<CaptureResultListener> set = this.mCaptureResultListeners;
            synchronized (set) {
                HashSet<CaptureResultListener> removeSet = null;
                for (CaptureResultListener listener : new HashSet<CaptureResultListener>(this.mCaptureResultListeners)) {
                    if (!listener.onCaptureResult(captureResult)) continue;
                    if (removeSet == null) {
                        removeSet = new HashSet<CaptureResultListener>();
                    }
                    removeSet.add(listener);
                }
                if (removeSet != null) {
                    this.mCaptureResultListeners.removeAll(removeSet);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addListener(CaptureResultListener listener) {
            Set<CaptureResultListener> set = this.mCaptureResultListeners;
            synchronized (set) {
                this.mCaptureResultListeners.add(listener);
            }
        }

        private static interface CaptureResultListener {
            public boolean onCaptureResult(@NonNull CameraCaptureResult var1);
        }

        public static interface CaptureResultChecker<T> {
            @Nullable
            public T check(@NonNull CameraCaptureResult var1);
        }
    }

    static final class TakePictureState {
        CameraCaptureResult mPreCaptureState = CameraCaptureResult.EmptyCameraCaptureResult.create();
        boolean mIsAfTriggered = false;
        boolean mIsAePrecaptureTriggered = false;
        boolean mIsFlashTriggered = false;

        TakePictureState() {
        }
    }

    public static final class Metadata {
        private boolean mIsReversedHorizontal;
        private boolean mIsReversedVertical;
        @Nullable
        private Location mLocation;

        public boolean isReversedHorizontal() {
            return this.mIsReversedHorizontal;
        }

        public void setReversedHorizontal(boolean isReversedHorizontal) {
            this.mIsReversedHorizontal = isReversedHorizontal;
        }

        public boolean isReversedVertical() {
            return this.mIsReversedVertical;
        }

        public void setReversedVertical(boolean isReversedVertical) {
            this.mIsReversedVertical = isReversedVertical;
        }

        @Nullable
        public Location getLocation() {
            return this.mLocation;
        }

        public void setLocation(@Nullable Location location) {
            this.mLocation = location;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Defaults
    implements ConfigProvider<ImageCaptureConfig> {
        private static final int DEFAULT_CAPTURE_MODE = 1;
        private static final int DEFAULT_FLASH_MODE = 2;
        private static final int DEFAULT_SURFACE_OCCUPANCY_PRIORITY = 4;
        private static final ImageCaptureConfig DEFAULT_CONFIG;

        @Override
        public ImageCaptureConfig getConfig(@Nullable Integer lensFacing) {
            return DEFAULT_CONFIG;
        }

        static {
            Builder builder = new Builder().setCaptureMode(1).setFlashMode(2).setSurfaceOccupancyPriority(4);
            DEFAULT_CONFIG = builder.getUseCaseConfig();
        }
    }

    public static abstract class OnImageCapturedCallback {
        public void onCaptureSuccess(@NonNull ImageProxy image) {
            image.close();
        }

        public void onError(int imageCaptureError, @NonNull String message, @Nullable Throwable cause) {
        }
    }

    public static interface OnImageSavedCallback {
        @SuppressLint(value={"StreamFiles"})
        public void onImageSaved(@NonNull File var1);

        public void onError(int var1, @NonNull String var2, @Nullable Throwable var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface FlashMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface CaptureMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ImageCaptureError {
    }

    static final class CaptureFailedException
    extends RuntimeException {
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        CaptureFailedException(String s, Throwable e) {
            super(s, e);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        CaptureFailedException(String s) {
            super(s);
        }
    }
}

