/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.util.Log;
import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraX;
import androidx.camera.core.CaptureConfig;
import androidx.camera.core.ConfigProvider;
import androidx.camera.core.DeferrableSurface;
import androidx.camera.core.ImageAnalysisAbstractAnalyzer;
import androidx.camera.core.ImageAnalysisBlockingAnalyzer;
import androidx.camera.core.ImageAnalysisConfig;
import androidx.camera.core.ImageAnalysisNonBlockingAnalyzer;
import androidx.camera.core.ImageOutputConfig;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderFormatRecommender;
import androidx.camera.core.ImageReaderProxy;
import androidx.camera.core.ImageReaderProxys;
import androidx.camera.core.ImmediateSurface;
import androidx.camera.core.MutableConfig;
import androidx.camera.core.MutableOptionsBundle;
import androidx.camera.core.OptionsBundle;
import androidx.camera.core.SessionConfig;
import androidx.camera.core.ThreadConfig;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseConfig;
import androidx.camera.core.impl.CameraDeviceConfig;
import androidx.camera.core.impl.CameraIdFilter;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.TargetConfig;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;

public final class ImageAnalysis
extends UseCase {
    public static final int STRATEGY_KEEP_ONLY_LATEST = 0;
    public static final int STRATEGY_BLOCK_PRODUCER = 1;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Defaults DEFAULT_CONFIG = new Defaults();
    private static final String TAG = "ImageAnalysis";
    private static final int NON_BLOCKING_IMAGE_DEPTH = 4;
    private final Builder mUseCaseConfigBuilder;
    final ImageAnalysisAbstractAnalyzer mImageAnalysisAbstractAnalyzer;
    @GuardedBy(value="mAnalysisLock")
    private Analyzer mSubscribedAnalyzer;
    @Nullable
    private ImageReaderProxy mImageReader;
    @Nullable
    private DeferrableSurface mDeferrableSurface;
    private final Object mAnalysisLock = new Object();

    ImageAnalysis(@NonNull ImageAnalysisConfig config) {
        super(config);
        this.mUseCaseConfigBuilder = Builder.fromConfig(config);
        ImageAnalysisConfig combinedConfig = (ImageAnalysisConfig)this.getUseCaseConfig();
        this.setImageFormat(ImageReaderFormatRecommender.chooseCombo().imageAnalysisFormat());
        this.mImageAnalysisAbstractAnalyzer = combinedConfig.getBackpressureStrategy() == 1 ? new ImageAnalysisBlockingAnalyzer() : new ImageAnalysisNonBlockingAnalyzer(config.getBackgroundExecutor(CameraXExecutors.highPriorityExecutor()));
    }

    SessionConfig.Builder createPipeline(final @NonNull String cameraId, final @NonNull ImageAnalysisConfig config, final @NonNull Size resolution) {
        Threads.checkMainThread();
        Executor backgroundExecutor = config.getBackgroundExecutor(CameraXExecutors.highPriorityExecutor());
        int imageQueueDepth = config.getBackpressureStrategy() == 1 ? config.getImageQueueDepth() : 4;
        this.mImageReader = ImageReaderProxys.createCompatibleReader(CameraX.getSurfaceManager(), cameraId, resolution.getWidth(), resolution.getHeight(), this.getImageFormat(), imageQueueDepth, backgroundExecutor);
        this.tryUpdateRelativeRotation(cameraId);
        this.mImageAnalysisAbstractAnalyzer.open();
        this.mImageReader.setOnImageAvailableListener((ImageReaderProxy.OnImageAvailableListener)this.mImageAnalysisAbstractAnalyzer, backgroundExecutor);
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.Builder.createFrom(config);
        this.mDeferrableSurface = new ImmediateSurface(this.mImageReader.getSurface());
        sessionConfigBuilder.addSurface(this.mDeferrableSurface);
        sessionConfigBuilder.addErrorListener(new SessionConfig.ErrorListener(){

            @Override
            public void onError(@NonNull SessionConfig sessionConfig, @NonNull SessionConfig.SessionError error) {
                ImageAnalysis.this.clearPipeline();
                if (ImageAnalysis.this.isCurrentlyBoundCamera(cameraId)) {
                    SessionConfig.Builder sessionConfigBuilder = ImageAnalysis.this.createPipeline(cameraId, config, resolution);
                    ImageAnalysis.this.attachToCamera(cameraId, sessionConfigBuilder.build());
                    ImageAnalysis.this.notifyReset();
                }
            }
        });
        return sessionConfigBuilder;
    }

    void clearPipeline() {
        Threads.checkMainThread();
        this.mImageAnalysisAbstractAnalyzer.close();
        DeferrableSurface deferrableSurface = this.mDeferrableSurface;
        this.mDeferrableSurface = null;
        final ImageReaderProxy imageReaderProxy = this.mImageReader;
        this.mImageReader = null;
        if (deferrableSurface != null) {
            deferrableSurface.setOnSurfaceDetachedListener(CameraXExecutors.mainThreadExecutor(), new DeferrableSurface.OnSurfaceDetachedListener(){

                @Override
                public void onSurfaceDetached() {
                    if (imageReaderProxy != null) {
                        imageReaderProxy.close();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAnalyzer() {
        Object object = this.mAnalysisLock;
        synchronized (object) {
            this.mImageAnalysisAbstractAnalyzer.setAnalyzer(null, null);
            if (this.mSubscribedAnalyzer != null) {
                this.notifyInactive();
            }
            this.mSubscribedAnalyzer = null;
        }
    }

    public void setTargetRotation(int rotation) {
        ImageAnalysisConfig oldConfig = (ImageAnalysisConfig)this.getUseCaseConfig();
        int oldRotation = oldConfig.getTargetRotation(-1);
        if (oldRotation == -1 || oldRotation != rotation) {
            this.mUseCaseConfigBuilder.setTargetRotation(rotation);
            this.updateUseCaseConfig(this.mUseCaseConfigBuilder.getUseCaseConfig());
            try {
                this.tryUpdateRelativeRotation(this.getBoundCameraId());
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Unable to get camera id for the use case.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnalyzer(@NonNull Executor executor, @NonNull Analyzer analyzer) {
        Object object = this.mAnalysisLock;
        synchronized (object) {
            this.mImageAnalysisAbstractAnalyzer.setAnalyzer(executor, analyzer);
            if (this.mSubscribedAnalyzer == null) {
                this.notifyActive();
            }
            this.mSubscribedAnalyzer = analyzer;
        }
    }

    @NonNull
    public String toString() {
        return "ImageAnalysis:" + this.getName();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void clear() {
        this.clearPipeline();
        super.clear();
    }

    @Override
    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected UseCaseConfig.Builder<?, ?, ?> getDefaultBuilder(@Nullable Integer lensFacing) {
        ImageAnalysisConfig defaults = CameraX.getDefaultUseCaseConfig(ImageAnalysisConfig.class, lensFacing);
        if (defaults != null) {
            return Builder.fromConfig(defaults);
        }
        return null;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected Map<String, Size> onSuggestedResolutionUpdated(@NonNull Map<String, Size> suggestedResolutionMap) {
        ImageAnalysisConfig config = (ImageAnalysisConfig)this.getUseCaseConfig();
        String cameraId = this.getBoundCameraId();
        Size resolution = suggestedResolutionMap.get(cameraId);
        if (resolution == null) {
            throw new IllegalArgumentException("Suggested resolution map missing resolution for camera " + cameraId);
        }
        if (this.mImageReader != null) {
            this.mImageReader.close();
        }
        SessionConfig.Builder sessionConfigBuilder = this.createPipeline(cameraId, config, resolution);
        this.attachToCamera(cameraId, sessionConfigBuilder.build());
        return suggestedResolutionMap;
    }

    private void tryUpdateRelativeRotation(String cameraId) {
        ImageOutputConfig config = (ImageOutputConfig)((Object)this.getUseCaseConfig());
        CameraInfoInternal cameraInfoInternal = CameraX.getCameraInfo(cameraId);
        this.mImageAnalysisAbstractAnalyzer.setRelativeRotation(cameraInfoInternal.getSensorRotationDegrees(config.getTargetRotation(0)));
    }

    public static final class Builder
    implements CameraDeviceConfig.Builder<Builder>,
    ImageOutputConfig.Builder<Builder>,
    ThreadConfig.Builder<Builder>,
    UseCaseConfig.Builder<ImageAnalysis, ImageAnalysisConfig, Builder> {
        private final MutableOptionsBundle mMutableConfig;

        public Builder() {
            this(MutableOptionsBundle.create());
        }

        private Builder(MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            Class oldConfigClass = mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(ImageAnalysis.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setTargetClass((Class)ImageAnalysis.class);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static Builder fromConfig(@NonNull ImageAnalysisConfig configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @NonNull
        public Builder setBackpressureStrategy(int strategy) {
            this.getMutableConfig().insertOption(ImageAnalysisConfig.OPTION_BACKPRESSURE_STRATEGY, strategy);
            return this;
        }

        @NonNull
        public Builder setImageQueueDepth(int depth) {
            this.getMutableConfig().insertOption(ImageAnalysisConfig.OPTION_IMAGE_QUEUE_DEPTH, depth);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public ImageAnalysisConfig getUseCaseConfig() {
            return new ImageAnalysisConfig(OptionsBundle.from(this.mMutableConfig));
        }

        @Override
        @NonNull
        public ImageAnalysis build() {
            if (this.getMutableConfig().retrieveOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO, null) != null && this.getMutableConfig().retrieveOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION, null) != null) {
                throw new IllegalArgumentException("Cannot use both setTargetResolution and setTargetAspectRatio on the same config.");
            }
            return new ImageAnalysis(this.getUseCaseConfig());
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setTargetClass(@NonNull Class<ImageAnalysis> targetClass) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(UseCaseConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_TARGET_NAME, targetName);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setLensFacing(int lensFacing) {
            this.getMutableConfig().insertOption(CameraDeviceConfig.OPTION_LENS_FACING, lensFacing);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCameraIdFilter(@NonNull CameraIdFilter cameraIdFilter) {
            this.getMutableConfig().insertOption(CameraDeviceConfig.OPTION_CAMERA_ID_FILTER, cameraIdFilter);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setTargetAspectRatioCustom(@NonNull Rational aspectRatio) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO_CUSTOM, aspectRatio);
            this.getMutableConfig().removeOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetAspectRatio(int aspectRatio) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO, aspectRatio);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetRotation(int rotation) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_ROTATION, rotation);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION, resolution);
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO_CUSTOM, new Rational(resolution.getWidth(), resolution.getHeight()));
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setDefaultResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_DEFAULT_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setMaxResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_MAX_RESOLUTION, resolution);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> resolutions) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_SUPPORTED_RESOLUTIONS, resolutions);
            return this;
        }

        @Override
        @NonNull
        public Builder setBackgroundExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(ThreadConfig.OPTION_BACKGROUND_EXECUTOR, executor);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_DEFAULT_SESSION_CONFIG, sessionConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_DEFAULT_CAPTURE_CONFIG, captureConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_SESSION_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAPTURE_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSurfaceOccupancyPriority(int priority) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, priority);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setUseCaseEventCallback(@NonNull UseCase.EventCallback useCaseEventCallback) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_USE_CASE_EVENT_CALLBACK, useCaseEventCallback);
            return this;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Defaults
    implements ConfigProvider<ImageAnalysisConfig> {
        private static final int DEFAULT_BACKPRESSURE_STRATEGY = 0;
        private static final int DEFAULT_IMAGE_QUEUE_DEPTH = 6;
        private static final Size DEFAULT_TARGET_RESOLUTION = new Size(640, 480);
        private static final Size DEFAULT_MAX_RESOLUTION = new Size(1920, 1080);
        private static final int DEFAULT_SURFACE_OCCUPANCY_PRIORITY = 1;
        private static final ImageAnalysisConfig DEFAULT_CONFIG;

        @Override
        @NonNull
        public ImageAnalysisConfig getConfig(@Nullable Integer lensFacing) {
            return DEFAULT_CONFIG;
        }

        static {
            Builder builder = new Builder().setBackpressureStrategy(0).setImageQueueDepth(6).setDefaultResolution(DEFAULT_TARGET_RESOLUTION).setMaxResolution(DEFAULT_MAX_RESOLUTION).setSurfaceOccupancyPriority(1);
            DEFAULT_CONFIG = builder.getUseCaseConfig();
        }
    }

    public static interface Analyzer {
        public void analyze(@NonNull ImageProxy var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface BackpressureStrategy {
    }
}

