/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.GuardedBy;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageProxyDownsampler;
import androidx.camera.core.ImageReaderProxy;
import androidx.camera.core.QueuedImageReaderProxy;
import androidx.camera.core.ReferenceCountedImageProxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class ForwardingImageReaderListener
implements ImageReaderProxy.OnImageAvailableListener {
    @GuardedBy(value="this")
    private final List<QueuedImageReaderProxy> mImageReaders;

    ForwardingImageReaderListener(List<QueuedImageReaderProxy> imageReaders) {
        this.mImageReaders = Collections.unmodifiableList(new ArrayList<QueuedImageReaderProxy>(imageReaders));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void onImageAvailable(ImageReaderProxy imageReaderProxy) {
        ImageProxy imageProxy = imageReaderProxy.acquireNextImage();
        if (imageProxy == null) {
            return;
        }
        ReferenceCountedImageProxy referenceCountedImageProxy = new ReferenceCountedImageProxy(imageProxy);
        Iterator<QueuedImageReaderProxy> iterator = this.mImageReaders.iterator();
        while (iterator.hasNext()) {
            QueuedImageReaderProxy queuedImageReaderProxy;
            QueuedImageReaderProxy queuedImageReaderProxy2 = queuedImageReaderProxy = iterator.next();
            synchronized (queuedImageReaderProxy2) {
                if (!queuedImageReaderProxy.isClosed()) {
                    ImageProxy forkedImage = referenceCountedImageProxy.fork();
                    ForwardingImageProxy imageToEnqueue = ImageProxyDownsampler.downsample(forkedImage, queuedImageReaderProxy.getWidth(), queuedImageReaderProxy.getHeight(), ImageProxyDownsampler.DownsamplingMethod.AVERAGING);
                    queuedImageReaderProxy.enqueueImage(imageToEnqueue);
                }
            }
        }
        referenceCountedImageProxy.close();
    }
}

