/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.core.MeteringPoint;
import androidx.core.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class FocusMeteringAction {
    public static final int FLAG_AF = 1;
    public static final int FLAG_AE = 2;
    public static final int FLAG_AWB = 4;
    static final int DEFAULT_METERINGMODE = 7;
    static final long DEFAULT_AUTOCANCEL_DURATION = 5000L;
    private final List<MeteringPoint> mMeteringPointsAf;
    private final List<MeteringPoint> mMeteringPointsAe;
    private final List<MeteringPoint> mMeteringPointsAwb;
    private final long mAutoCancelDurationInMillis;

    FocusMeteringAction(Builder builder) {
        this.mMeteringPointsAf = Collections.unmodifiableList(builder.mMeteringPointsAf);
        this.mMeteringPointsAe = Collections.unmodifiableList(builder.mMeteringPointsAe);
        this.mMeteringPointsAwb = Collections.unmodifiableList(builder.mMeteringPointsAwb);
        this.mAutoCancelDurationInMillis = builder.mAutoCancelDurationInMillis;
    }

    public long getAutoCancelDurationInMillis() {
        return this.mAutoCancelDurationInMillis;
    }

    @NonNull
    public List<MeteringPoint> getMeteringPointsAf() {
        return this.mMeteringPointsAf;
    }

    @NonNull
    public List<MeteringPoint> getMeteringPointsAe() {
        return this.mMeteringPointsAe;
    }

    @NonNull
    public List<MeteringPoint> getMeteringPointsAwb() {
        return this.mMeteringPointsAwb;
    }

    public boolean isAutoCancelEnabled() {
        return this.mAutoCancelDurationInMillis > 0L;
    }

    public static class Builder {
        final List<MeteringPoint> mMeteringPointsAf = new ArrayList<MeteringPoint>();
        final List<MeteringPoint> mMeteringPointsAe = new ArrayList<MeteringPoint>();
        final List<MeteringPoint> mMeteringPointsAwb = new ArrayList<MeteringPoint>();
        long mAutoCancelDurationInMillis = 5000L;

        private Builder(@NonNull MeteringPoint point) {
            this(point, 7);
        }

        private Builder(@NonNull MeteringPoint point, int mode) {
            this.addPoint(point, mode);
        }

        @NonNull
        public static Builder from(@NonNull MeteringPoint meteringPoint) {
            return new Builder(meteringPoint);
        }

        @NonNull
        public static Builder from(@NonNull MeteringPoint meteringPoint, int mode) {
            return new Builder(meteringPoint, mode);
        }

        @NonNull
        public Builder addPoint(@NonNull MeteringPoint point) {
            return this.addPoint(point, 7);
        }

        @NonNull
        public Builder addPoint(@NonNull MeteringPoint point, int mode) {
            Preconditions.checkArgument((mode >= 1 && mode <= 7 ? 1 : 0) != 0, (Object)("Invalid metering mode " + mode));
            if ((mode & 1) != 0) {
                this.mMeteringPointsAf.add(point);
            }
            if ((mode & 2) != 0) {
                this.mMeteringPointsAe.add(point);
            }
            if ((mode & 4) != 0) {
                this.mMeteringPointsAwb.add(point);
            }
            return this;
        }

        @NonNull
        public Builder setAutoCancelDuration(@IntRange(from=1L) long duration, @NonNull TimeUnit timeUnit) {
            Preconditions.checkArgument((duration >= 1L ? 1 : 0) != 0, (Object)"autoCancelDuration must be at least 1");
            this.mAutoCancelDurationInMillis = timeUnit.toMillis(duration);
            return this;
        }

        @NonNull
        public Builder disableAutoCancel() {
            this.mAutoCancelDurationInMillis = 0L;
            return this;
        }

        @NonNull
        public FocusMeteringAction build() {
            return new FocusMeteringAction(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface MeteringMode {
    }
}

