/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.DeferrableSurface;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class DeferrableSurfaces {
    private DeferrableSurfaces() {
    }

    @NonNull
    public static ListenableFuture<List<Surface>> surfaceListWithTimeout(@NonNull Collection<DeferrableSurface> deferrableSurfaces, final boolean removeNullSurfaces, long timeout, @NonNull Executor executor, @NonNull ScheduledExecutorService scheduledExecutorService) {
        ArrayList<ListenableFuture<Surface>> listenableFutureSurfaces = new ArrayList<ListenableFuture<Surface>>();
        for (DeferrableSurface deferrableSurface : deferrableSurfaces) {
            listenableFutureSurfaces.add(deferrableSurface.getSurface());
        }
        return CallbackToFutureAdapter.getFuture(completer -> {
            ListenableFuture listenableFuture = Futures.successfulAsList(listenableFutureSurfaces);
            final ScheduledFuture<?> scheduledFuture = scheduledExecutorService.schedule(() -> executor.execute(() -> {
                if (!listenableFuture.isDone()) {
                    completer.setException((Throwable)new TimeoutException("Cannot complete surfaceList within " + timeout));
                    listenableFuture.cancel(true);
                }
            }), timeout, TimeUnit.MILLISECONDS);
            completer.addCancellationListener(() -> listenableFuture.cancel(true), executor);
            Futures.addCallback(listenableFuture, new FutureCallback<List<Surface>>(){

                @Override
                public void onSuccess(@Nullable List<Surface> result) {
                    ArrayList<Surface> surfaces = new ArrayList<Surface>(result);
                    if (removeNullSurfaces) {
                        surfaces.removeAll(Collections.singleton(null));
                    }
                    completer.set(surfaces);
                    scheduledFuture.cancel(true);
                }

                @Override
                public void onFailure(Throwable t) {
                    completer.set(Collections.unmodifiableList(Collections.emptyList()));
                    scheduledFuture.cancel(true);
                }
            }, executor);
            return "surfaceList";
        });
    }
}

