/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.RestrictTo;
import androidx.camera.core.CaptureBundle;
import androidx.camera.core.CaptureStage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
final class CaptureBundles {
    static CaptureBundle singleDefaultCaptureBundle() {
        return CaptureBundles.createCaptureBundle(new CaptureStage.DefaultCaptureStage());
    }

    static CaptureBundle createCaptureBundle(CaptureStage ... captureStages) {
        return new CaptureBundleImpl(Arrays.asList(captureStages));
    }

    static CaptureBundle createCaptureBundle(List<CaptureStage> captureStageList) {
        return new CaptureBundleImpl(captureStageList);
    }

    private CaptureBundles() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    static final class CaptureBundleImpl
    implements CaptureBundle {
        final List<CaptureStage> mCaptureStageList;

        CaptureBundleImpl(List<CaptureStage> captureStageList) {
            if (captureStageList == null || captureStageList.isEmpty()) {
                throw new IllegalArgumentException("Cannot set an empty CaptureStage list.");
            }
            this.mCaptureStageList = Collections.unmodifiableList(new ArrayList<CaptureStage>(captureStageList));
        }

        @Override
        public List<CaptureStage> getCaptureStages() {
            return this.mCaptureStageList;
        }
    }
}

