/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import android.util.Size;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraExecutor;
import androidx.camera.core.CameraFactory;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.CameraRepository;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraXConfig;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseConfig;
import androidx.camera.core.UseCaseConfigFactory;
import androidx.camera.core.UseCaseGroup;
import androidx.camera.core.UseCaseGroupLifecycleController;
import androidx.camera.core.UseCaseGroupRepository;
import androidx.camera.core.impl.CameraDeviceConfig;
import androidx.camera.core.impl.CameraDeviceSurfaceManager;
import androidx.camera.core.impl.CameraIdFilter;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@MainThread
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CameraX {
    private static final String TAG = "CameraX";
    private static final long WAIT_INITIALIZED_TIMEOUT = 3L;
    static final Object sInitializeLock = new Object();
    @GuardedBy(value="sInitializeLock")
    @Nullable
    static CameraX sInstance = null;
    @GuardedBy(value="sInitializeLock")
    private static boolean sTargetInitialized = false;
    @GuardedBy(value="sInitializeLock")
    @NonNull
    private static ListenableFuture<Void> sInitializeFuture = Futures.immediateFailedFuture(new IllegalStateException("CameraX is not initialized."));
    @GuardedBy(value="sInitializeLock")
    @NonNull
    private static ListenableFuture<Void> sShutdownFuture = Futures.immediateFuture(null);
    final CameraRepository mCameraRepository = new CameraRepository();
    private final Object mInitializeLock = new Object();
    private final UseCaseGroupRepository mUseCaseGroupRepository = new UseCaseGroupRepository();
    private final Executor mCameraExecutor;
    private CameraFactory mCameraFactory;
    private CameraDeviceSurfaceManager mSurfaceManager;
    private UseCaseConfigFactory mDefaultConfigFactory;
    private Context mContext;
    @GuardedBy(value="mInitializeLock")
    private InternalInitState mInitState = InternalInitState.UNINITIALIZED;
    @GuardedBy(value="mInitializeLock")
    private ListenableFuture<Void> mShutdownInternalFuture = Futures.immediateFuture(null);

    CameraX(@NonNull Executor executor) {
        Preconditions.checkNotNull((Object)executor);
        this.mCameraExecutor = executor;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static Camera bindToLifecycle(@NonNull LifecycleOwner lifecycleOwner, @NonNull CameraSelector cameraSelector, UseCase ... useCases) {
        Threads.checkMainThread();
        CameraX cameraX = CameraX.checkInitialized();
        UseCaseGroupLifecycleController useCaseGroupLifecycleController = cameraX.getOrCreateUseCaseGroup(lifecycleOwner);
        UseCaseGroup useCaseGroupToBind = useCaseGroupLifecycleController.getUseCaseGroup();
        Collection<UseCaseGroupLifecycleController> controllers = cameraX.mUseCaseGroupRepository.getUseCaseGroups();
        for (UseCase useCase : useCases) {
            for (UseCaseGroupLifecycleController controller : controllers) {
                UseCaseGroup useCaseGroup = controller.getUseCaseGroup();
                if (!useCaseGroup.contains(useCase) || useCaseGroup == useCaseGroupToBind) continue;
                throw new IllegalStateException(String.format("Use case %s already bound to a different lifecycle.", useCase));
            }
        }
        CameraSelector.Builder selectorBuilder = CameraSelector.Builder.fromSelector(cameraSelector);
        for (UseCase useCase : useCases) {
            CameraIdFilter filter = ((CameraDeviceConfig)((Object)useCase.getUseCaseConfig())).getCameraIdFilter(null);
            if (filter == null) continue;
            selectorBuilder.appendFilter(filter);
        }
        String newCameraId = CameraX.getCameraWithCameraSelector(selectorBuilder.build());
        CameraInternal camera = cameraX.getCameraRepository().getCamera(newCameraId);
        for (UseCase useCase : useCases) {
            useCase.onBind(camera);
        }
        CameraX.calculateSuggestedResolutions(lifecycleOwner, newCameraId, useCases);
        for (UseCase useCase : useCases) {
            useCaseGroupToBind.addUseCase(useCase);
            for (String cameraId : useCase.getAttachedCameraIds()) {
                CameraX.attach(cameraId, useCase);
            }
        }
        useCaseGroupLifecycleController.notifyState();
        return camera;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isBound(@NonNull UseCase useCase) {
        CameraX cameraX = CameraX.checkInitialized();
        Collection<UseCaseGroupLifecycleController> controllers = cameraX.mUseCaseGroupRepository.getUseCaseGroups();
        for (UseCaseGroupLifecycleController controller : controllers) {
            UseCaseGroup useCaseGroup = controller.getUseCaseGroup();
            if (!useCaseGroup.contains(useCase)) continue;
            return true;
        }
        return false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void unbind(UseCase ... useCases) {
        Threads.checkMainThread();
        CameraX cameraX = CameraX.checkInitialized();
        Collection<UseCaseGroupLifecycleController> useCaseGroups = cameraX.mUseCaseGroupRepository.getUseCaseGroups();
        HashMap<String, ArrayList<UseCase>> detachingUseCaseMap = new HashMap<String, ArrayList<UseCase>>();
        for (UseCase useCase : useCases) {
            for (UseCaseGroupLifecycleController useCaseGroupLifecycleController : useCaseGroups) {
                UseCaseGroup useCaseGroup = useCaseGroupLifecycleController.getUseCaseGroup();
                if (!useCaseGroup.removeUseCase(useCase)) continue;
                for (String cameraId : useCase.getAttachedCameraIds()) {
                    ArrayList<UseCase> useCasesOnCameraId = (ArrayList<UseCase>)detachingUseCaseMap.get(cameraId);
                    if (useCasesOnCameraId == null) {
                        useCasesOnCameraId = new ArrayList<UseCase>();
                        detachingUseCaseMap.put(cameraId, useCasesOnCameraId);
                    }
                    useCasesOnCameraId.add(useCase);
                }
            }
        }
        for (String cameraId : detachingUseCaseMap.keySet()) {
            CameraX.detach(cameraId, (List)detachingUseCaseMap.get(cameraId));
        }
        for (UseCase useCase : useCases) {
            useCase.clear();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void unbindAll() {
        Threads.checkMainThread();
        CameraX cameraX = CameraX.checkInitialized();
        Collection<UseCaseGroupLifecycleController> useCaseGroups = cameraX.mUseCaseGroupRepository.getUseCaseGroups();
        ArrayList<UseCase> useCases = new ArrayList<UseCase>();
        for (UseCaseGroupLifecycleController useCaseGroupLifecycleController : useCaseGroups) {
            UseCaseGroup useCaseGroup = useCaseGroupLifecycleController.getUseCaseGroup();
            useCases.addAll(useCaseGroup.getUseCases());
        }
        CameraX.unbind(useCases.toArray(new UseCase[0]));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean hasCamera(@NonNull CameraSelector cameraSelector) throws CameraInfoUnavailableException {
        CameraX.checkInitialized();
        try {
            cameraSelector.select(CameraX.getCameraFactory().getAvailableCameraIds());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static String getCameraWithLensFacing(int lensFacing) throws CameraInfoUnavailableException {
        CameraX.checkInitialized();
        return CameraX.getCameraFactory().cameraIdForLensFacing(lensFacing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static String getCameraWithCameraSelector(@NonNull CameraSelector cameraSelector) {
        CameraX.checkInitialized();
        String resultCameraId = null;
        try {
            Set<String> availableCameraIds = CameraX.getCameraFactory().getAvailableCameraIds();
            resultCameraId = cameraSelector.select(availableCameraIds);
        }
        catch (CameraInfoUnavailableException e) {
            return null;
        }
        return resultCameraId;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static int getDefaultLensFacing() throws CameraInfoUnavailableException {
        CameraX.checkInitialized();
        Integer lensFacingCandidate = null;
        List<Integer> lensFacingList = Arrays.asList(1, 0);
        for (Integer lensFacing : lensFacingList) {
            String cameraId = CameraX.getCameraFactory().cameraIdForLensFacing(lensFacing);
            if (cameraId == null) continue;
            lensFacingCandidate = lensFacing;
            break;
        }
        if (lensFacingCandidate == null) {
            throw new IllegalStateException("Unable to get default lens facing.");
        }
        return lensFacingCandidate;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static CameraInfoInternal getCameraInfo(String cameraId) {
        CameraX cameraX = CameraX.checkInitialized();
        return cameraX.getCameraRepository().getCamera(cameraId).getCameraInfoInternal();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static CameraDeviceSurfaceManager getSurfaceManager() {
        CameraX cameraX = CameraX.checkInitialized();
        return cameraX.getCameraDeviceSurfaceManager();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static <C extends UseCaseConfig<?>> C getDefaultUseCaseConfig(Class<C> configType, @Nullable Integer lensFacing) {
        CameraX cameraX = CameraX.checkInitialized();
        return cameraX.getDefaultConfigFactory().getConfig(configType, lensFacing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ListenableFuture<Void> initialize(@NonNull Context context, @NonNull CameraXConfig cameraXConfig) {
        Object object = sInitializeLock;
        synchronized (object) {
            return CameraX.initializeLocked(context, cameraXConfig);
        }
    }

    @GuardedBy(value="sInitializeLock")
    @NonNull
    private static ListenableFuture<Void> initializeLocked(@NonNull Context context, @NonNull CameraXConfig cameraXConfig) {
        CameraX cameraX;
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)cameraXConfig);
        Preconditions.checkState((!sTargetInitialized ? 1 : 0) != 0, (String)"Must call CameraX.shutdown() first.");
        sTargetInitialized = true;
        Executor executor = cameraXConfig.getCameraExecutor(null);
        if (executor == null) {
            executor = new CameraExecutor();
        }
        sInstance = cameraX = new CameraX(executor);
        sInitializeFuture = CallbackToFutureAdapter.getFuture(completer -> {
            Object object = sInitializeLock;
            synchronized (object) {
                FutureChain future = FutureChain.from(sShutdownFuture).transformAsync(input -> cameraX.initInternal(context, cameraXConfig), CameraXExecutors.directExecutor());
                Futures.addCallback(future, new FutureCallback<Void>(){

                    @Override
                    public void onSuccess(@Nullable Void result) {
                        completer.set(null);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onFailure(Throwable t) {
                        Log.w((String)CameraX.TAG, (String)"CameraX initialize() failed", (Throwable)t);
                        Object object = sInitializeLock;
                        synchronized (object) {
                            if (sInstance == cameraX) {
                                CameraX.shutdown();
                            }
                        }
                        completer.setException(t);
                    }
                }, CameraXExecutors.directExecutor());
                return "CameraX-initialize";
            }
        });
        return sInitializeFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ListenableFuture<Void> shutdown() {
        Object object = sInitializeLock;
        synchronized (object) {
            return CameraX.shutdownLocked();
        }
    }

    @GuardedBy(value="sInitializeLock")
    @NonNull
    private static ListenableFuture<Void> shutdownLocked() {
        if (!sTargetInitialized) {
            return sShutdownFuture;
        }
        sTargetInitialized = false;
        CameraX cameraX = sInstance;
        sInstance = null;
        sShutdownFuture = CallbackToFutureAdapter.getFuture(completer -> {
            Object object = sInitializeLock;
            synchronized (object) {
                sInitializeFuture.addListener(() -> Futures.propagate(cameraX.shutdownInternal(), completer), CameraXExecutors.directExecutor());
                return "CameraX shutdown";
            }
        });
        return sShutdownFuture;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static Context getContext() {
        CameraX cameraX = CameraX.checkInitialized();
        return cameraX.mContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isInitialized() {
        Object object = sInitializeLock;
        synchronized (object) {
            return sInstance != null && sInstance.isInitializedInternal();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static Collection<UseCase> getActiveUseCases() {
        CameraX cameraX = CameraX.checkInitialized();
        Collection<UseCase> activeUseCases = null;
        Collection<UseCaseGroupLifecycleController> controllers = cameraX.mUseCaseGroupRepository.getUseCaseGroups();
        for (UseCaseGroupLifecycleController controller : controllers) {
            if (!controller.getUseCaseGroup().isActive()) continue;
            activeUseCases = controller.getUseCaseGroup().getUseCases();
            break;
        }
        return activeUseCases;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static CameraFactory getCameraFactory() {
        CameraX cameraX = CameraX.checkInitialized();
        if (cameraX.mCameraFactory == null) {
            throw new IllegalStateException("CameraX not initialized yet.");
        }
        return cameraX.mCameraFactory;
    }

    @NonNull
    private static CameraX checkInitialized() {
        CameraX cameraX = CameraX.waitInitialized();
        Preconditions.checkState((boolean)cameraX.isInitializedInternal(), (String)"Must call CameraX.initialize() first");
        return cameraX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static ListenableFuture<CameraX> getOrCreateInstance(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context, (Object)"Context must not be null.");
        Object object = sInitializeLock;
        synchronized (object) {
            ListenableFuture<CameraX> instanceFuture = CameraX.getInstanceLocked();
            if (instanceFuture.isDone()) {
                try {
                    instanceFuture.get();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Unexpected thread interrupt. Should not be possible since future is already complete.", e);
                }
                catch (ExecutionException e) {
                    CameraX.shutdownLocked();
                    instanceFuture = null;
                }
            }
            if (instanceFuture == null) {
                Application app = (Application)context.getApplicationContext();
                if (app instanceof CameraXConfig.Provider) {
                    CameraX.initializeLocked((Context)app, ((CameraXConfig.Provider)app).getCameraXConfig());
                    instanceFuture = CameraX.getInstanceLocked();
                } else {
                    throw new IllegalStateException("CameraX is not initialized properly. Either CameraX.initialize() needs to have been called or the CameraXConfig.Provider interface must be implemented by your Application class.");
                }
            }
            return instanceFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ListenableFuture<CameraX> getInstance() {
        Object object = sInitializeLock;
        synchronized (object) {
            return CameraX.getInstanceLocked();
        }
    }

    @GuardedBy(value="sInitializeLock")
    @NonNull
    private static ListenableFuture<CameraX> getInstanceLocked() {
        if (!sTargetInitialized) {
            return Futures.immediateFailedFuture(new IllegalStateException("Must call CameraX.initialize() first"));
        }
        CameraX cameraX = sInstance;
        return Futures.transform(sInitializeFuture, nullVoid -> cameraX, CameraXExecutors.directExecutor());
    }

    @NonNull
    private static CameraX waitInitialized() {
        ListenableFuture<CameraX> future = CameraX.getInstance();
        try {
            return (CameraX)future.get(3L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void attach(String cameraId, UseCase useCase) {
        CameraX cameraX = CameraX.checkInitialized();
        CameraInternal cameraInternal = cameraX.getCameraRepository().getCamera(cameraId);
        useCase.addStateChangeCallback(cameraInternal);
        useCase.attachCameraControl(cameraId, cameraInternal.getCameraControlInternal());
    }

    private static void detach(String cameraId, List<UseCase> useCases) {
        CameraX cameraX = CameraX.checkInitialized();
        CameraInternal cameraInternal = cameraX.getCameraRepository().getCamera(cameraId);
        for (UseCase useCase : useCases) {
            useCase.removeStateChangeCallback(cameraInternal);
            useCase.detachCameraControl(cameraId);
        }
        cameraInternal.removeOnlineUseCase(useCases);
    }

    private static void calculateSuggestedResolutions(@NonNull LifecycleOwner lifecycleOwner, @NonNull String newCameraId, UseCase ... useCases) {
        List<UseCase> useCaseList;
        CameraX cameraX = CameraX.checkInitialized();
        UseCaseGroupLifecycleController useCaseGroupLifecycleController = cameraX.getOrCreateUseCaseGroup(lifecycleOwner);
        UseCaseGroup useCaseGroupToBind = useCaseGroupLifecycleController.getUseCaseGroup();
        HashMap<String, ArrayList<UseCase>> originalCameraIdUseCaseMap = new HashMap<String, ArrayList<UseCase>>();
        HashMap<String, ArrayList<UseCase>> newCameraIdUseCaseMap = new HashMap<String, ArrayList<UseCase>>();
        for (UseCase useCase : useCaseGroupToBind.getUseCases()) {
            for (String cameraId : useCase.getAttachedCameraIds()) {
                useCaseList = (List)originalCameraIdUseCaseMap.get(cameraId);
                if (useCaseList == null) {
                    useCaseList = new ArrayList();
                    originalCameraIdUseCaseMap.put(cameraId, (ArrayList<UseCase>)useCaseList);
                }
                useCaseList.add(useCase);
            }
        }
        for (UseCase useCase : useCases) {
            useCaseList = (ArrayList<UseCase>)newCameraIdUseCaseMap.get(newCameraId);
            if (useCaseList == null) {
                useCaseList = new ArrayList<UseCase>();
                newCameraIdUseCaseMap.put(newCameraId, (ArrayList<UseCase>)useCaseList);
            }
            useCaseList.add(useCase);
        }
        for (String cameraId : newCameraIdUseCaseMap.keySet()) {
            Map<UseCase, Size> suggestResolutionsMap = CameraX.getSurfaceManager().getSuggestedResolutions(cameraId, (List)originalCameraIdUseCaseMap.get(cameraId), (List)newCameraIdUseCaseMap.get(cameraId));
            for (UseCase useCase : (List)newCameraIdUseCaseMap.get(cameraId)) {
                Size resolution = suggestResolutionsMap.get(useCase);
                HashMap<String, Size> suggestedCameraSurfaceResolutionMap = new HashMap<String, Size>();
                suggestedCameraSurfaceResolutionMap.put(cameraId, resolution);
                useCase.updateSuggestedResolution(suggestedCameraSurfaceResolutionMap);
            }
        }
    }

    private CameraDeviceSurfaceManager getCameraDeviceSurfaceManager() {
        if (this.mSurfaceManager == null) {
            throw new IllegalStateException("CameraX not initialized yet.");
        }
        return this.mSurfaceManager;
    }

    private UseCaseConfigFactory getDefaultConfigFactory() {
        if (this.mDefaultConfigFactory == null) {
            throw new IllegalStateException("CameraX not initialized yet.");
        }
        return this.mDefaultConfigFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<Void> initInternal(Context context, CameraXConfig cameraXConfig) {
        Object object = this.mInitializeLock;
        synchronized (object) {
            Preconditions.checkState((this.mInitState == InternalInitState.UNINITIALIZED ? 1 : 0) != 0, (String)"CameraX.initInternal() should only be called once per instance");
            this.mInitState = InternalInitState.INITIALIZING;
            return CallbackToFutureAdapter.getFuture(completer -> {
                this.mCameraExecutor.execute(() -> {
                    IllegalArgumentException e = null;
                    try {
                        this.mContext = context.getApplicationContext();
                        CameraFactory.Provider cameraFactoryProvider = cameraXConfig.getCameraFactoryProvider(null);
                        if (cameraFactoryProvider == null) {
                            e = new IllegalArgumentException("Invalid app configuration provided. Missing CameraFactory.");
                            return;
                        }
                        this.mCameraFactory = cameraFactoryProvider.newInstance(context);
                        CameraDeviceSurfaceManager.Provider surfaceManagerProvider = cameraXConfig.getDeviceSurfaceManagerProvider(null);
                        if (surfaceManagerProvider == null) {
                            e = new IllegalArgumentException("Invalid app configuration provided. Missing CameraDeviceSurfaceManager.");
                            return;
                        }
                        this.mSurfaceManager = surfaceManagerProvider.newInstance(context);
                        UseCaseConfigFactory.Provider configFactoryProvider = cameraXConfig.getUseCaseConfigFactoryProvider(null);
                        if (configFactoryProvider == null) {
                            e = new IllegalArgumentException("Invalid app configuration provided. Missing UseCaseConfigFactory.");
                            return;
                        }
                        this.mDefaultConfigFactory = configFactoryProvider.newInstance(context);
                        if (this.mCameraExecutor instanceof CameraExecutor) {
                            CameraExecutor executor = (CameraExecutor)this.mCameraExecutor;
                            executor.init(this.mCameraFactory);
                        }
                        this.mCameraRepository.init(this.mCameraFactory);
                    }
                    finally {
                        Object object = this.mInitializeLock;
                        synchronized (object) {
                            this.mInitState = InternalInitState.INITIALIZED;
                        }
                        if (e != null) {
                            completer.setException((Throwable)e);
                        } else {
                            completer.set(null);
                        }
                    }
                });
                return "CameraX initInternal";
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private ListenableFuture<Void> shutdownInternal() {
        Object object = this.mInitializeLock;
        synchronized (object) {
            switch (this.mInitState) {
                case UNINITIALIZED: {
                    this.mInitState = InternalInitState.SHUTDOWN;
                    return Futures.immediateFuture(null);
                }
                case INITIALIZING: {
                    throw new IllegalStateException("CameraX could not be shutdown when it is initializing.");
                }
                case INITIALIZED: {
                    this.mInitState = InternalInitState.SHUTDOWN;
                    this.mShutdownInternalFuture = CallbackToFutureAdapter.getFuture(completer -> {
                        ListenableFuture<Void> future = this.mCameraRepository.deinit();
                        future.addListener(() -> {
                            if (this.mCameraExecutor instanceof CameraExecutor) {
                                CameraExecutor executor = (CameraExecutor)this.mCameraExecutor;
                                executor.deinit();
                            }
                            completer.set(null);
                        }, this.mCameraExecutor);
                        return "CameraX shutdownInternal";
                    });
                }
            }
            return this.mShutdownInternalFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInitializedInternal() {
        Object object = this.mInitializeLock;
        synchronized (object) {
            return this.mInitState == InternalInitState.INITIALIZED;
        }
    }

    private UseCaseGroupLifecycleController getOrCreateUseCaseGroup(LifecycleOwner lifecycleOwner) {
        return this.mUseCaseGroupRepository.getOrCreateUseCaseGroup(lifecycleOwner, new UseCaseGroupRepository.UseCaseGroupSetup(){

            @Override
            public void setup(UseCaseGroup useCaseGroup) {
                useCaseGroup.setListener(CameraX.this.mCameraRepository);
            }
        });
    }

    private CameraRepository getCameraRepository() {
        return this.mCameraRepository;
    }

    private static enum InternalInitState {
        UNINITIALIZED,
        INITIALIZING,
        INITIALIZED,
        SHUTDOWN;

    }
}

