/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.impl.CameraIdFilter;
import androidx.camera.core.impl.LensFacingCameraIdFilter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.LinkedHashSet;
import java.util.Set;

public final class CameraSelector {
    public static final int LENS_FACING_FRONT = 0;
    public static final int LENS_FACING_BACK = 1;
    @NonNull
    public static final CameraSelector DEFAULT_FRONT_CAMERA = new Builder().requireLensFacing(0).build();
    @NonNull
    public static final CameraSelector DEFAULT_BACK_CAMERA = new Builder().requireLensFacing(1).build();
    private LinkedHashSet<CameraIdFilter> mCameraFilterSet;

    CameraSelector(LinkedHashSet<CameraIdFilter> cameraFilterSet) {
        this.mCameraFilterSet = cameraFilterSet;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public String select(@NonNull Set<String> cameraIds) {
        Set<Object> resultCameraSet = new LinkedHashSet();
        for (CameraIdFilter filter : this.mCameraFilterSet) {
            resultCameraSet = filter.filter(cameraIds);
            if (resultCameraSet.isEmpty()) {
                throw new IllegalArgumentException("No available camera can be found.");
            }
            if (!cameraIds.containsAll(resultCameraSet)) {
                throw new IllegalArgumentException("The output isn't contained in the input.");
            }
            cameraIds = resultCameraSet;
        }
        return (String)resultCameraSet.iterator().next();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public LinkedHashSet<CameraIdFilter> getCameraFilterSet() {
        return this.mCameraFilterSet;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Integer getLensFacing() {
        Integer currentLensFacing = null;
        for (CameraIdFilter filter : this.mCameraFilterSet) {
            if (!(filter instanceof LensFacingCameraIdFilter)) continue;
            Integer newLensFacing = ((LensFacingCameraIdFilter)filter).getLensFacing();
            if (currentLensFacing == null) {
                currentLensFacing = newLensFacing;
                continue;
            }
            if (currentLensFacing.equals(newLensFacing)) continue;
            throw new IllegalStateException("Multiple conflicting lens facing requirements exist.");
        }
        return currentLensFacing;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface LensFacing {
    }

    public static final class Builder {
        private final LinkedHashSet<CameraIdFilter> mCameraFilterSet;

        public Builder() {
            this.mCameraFilterSet = new LinkedHashSet();
        }

        private Builder(@NonNull LinkedHashSet<CameraIdFilter> cameraFilterSet) {
            this.mCameraFilterSet = cameraFilterSet;
        }

        @NonNull
        public Builder requireLensFacing(int lensFacing) {
            this.mCameraFilterSet.add(new LensFacingCameraIdFilter(lensFacing));
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder appendFilter(@NonNull CameraIdFilter cameraFilter) {
            this.mCameraFilterSet.add(cameraFilter);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static Builder fromSelector(@NonNull CameraSelector cameraSelector) {
            Builder builder = new Builder(cameraSelector.getCameraFilterSet());
            return builder;
        }

        @NonNull
        public CameraSelector build() {
            return new CameraSelector(this.mCameraFilterSet);
        }
    }
}

