/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.DeferrableSurface;
import androidx.camera.core.Preview;
import androidx.camera.core.SurfaceHolder;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;

final class CallbackDeferrableSurface
extends DeferrableSurface
implements SurfaceHolder {
    @NonNull
    private ListenableFuture<Surface> mSurfaceFuture;
    @Nullable
    private CallbackToFutureAdapter.Completer<Void> mCancellationCompleter;
    @NonNull
    private Executor mCallbackExecutor;

    CallbackDeferrableSurface(@NonNull Size resolution, @NonNull Executor callbackExecutor, @NonNull Preview.PreviewSurfaceProvider previewSurfaceProvider) {
        this.mCallbackExecutor = callbackExecutor;
        this.mSurfaceFuture = CallbackToFutureAdapter.getFuture(completer -> {
            callbackExecutor.execute(() -> Futures.propagate(previewSurfaceProvider.provideSurface(resolution, (ListenableFuture<Void>)CallbackToFutureAdapter.getFuture(cancellationCompleter -> {
                this.mCancellationCompleter = cancellationCompleter;
                return "SurfaceCancellationFuture";
            })), completer));
            return "GetSurfaceFutureWithExecutor";
        });
        Futures.addCallback(this.mSurfaceFuture, new FutureCallback<Surface>(){

            @Override
            public void onSuccess(@Nullable Surface result) {
            }

            @Override
            public void onFailure(Throwable t) {
                CallbackDeferrableSurface.this.release();
            }
        }, this.mCallbackExecutor);
    }

    @Override
    ListenableFuture<Surface> provideSurface() {
        return this.mSurfaceFuture;
    }

    @Override
    public void release() {
        this.setOnSurfaceDetachedListener(this.mCallbackExecutor, () -> {
            if (this.mCancellationCompleter != null) {
                this.mCancellationCompleter.set(null);
            }
        });
    }
}

