/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.AndroidImageProxy;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxy;
import androidx.camera.core.impl.utils.MainThreadAsyncHandler;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import java.util.concurrent.Executor;

final class AndroidImageReaderProxy
implements ImageReaderProxy {
    @GuardedBy(value="this")
    private final ImageReader mImageReader;

    AndroidImageReaderProxy(ImageReader imageReader) {
        this.mImageReader = imageReader;
    }

    @Override
    @Nullable
    public synchronized ImageProxy acquireLatestImage() {
        Image image = this.mImageReader.acquireLatestImage();
        if (image == null) {
            return null;
        }
        return new AndroidImageProxy(image);
    }

    @Override
    @Nullable
    public synchronized ImageProxy acquireNextImage() {
        Image image = this.mImageReader.acquireNextImage();
        if (image == null) {
            return null;
        }
        return new AndroidImageProxy(image);
    }

    @Override
    public synchronized void close() {
        this.mImageReader.close();
    }

    @Override
    public synchronized int getHeight() {
        return this.mImageReader.getHeight();
    }

    @Override
    public synchronized int getWidth() {
        return this.mImageReader.getWidth();
    }

    @Override
    public synchronized int getImageFormat() {
        return this.mImageReader.getImageFormat();
    }

    @Override
    public synchronized int getMaxImages() {
        return this.mImageReader.getMaxImages();
    }

    @Override
    public synchronized Surface getSurface() {
        return this.mImageReader.getSurface();
    }

    @Override
    public synchronized void setOnImageAvailableListener(@NonNull ImageReaderProxy.OnImageAvailableListener listener, @Nullable Handler handler) {
        this.setOnImageAvailableListener(listener, handler == null ? null : CameraXExecutors.newHandlerExecutor(handler));
    }

    @Override
    public synchronized void setOnImageAvailableListener(final @NonNull ImageReaderProxy.OnImageAvailableListener listener, final @NonNull Executor executor) {
        ImageReader.OnImageAvailableListener transformedListener = new ImageReader.OnImageAvailableListener(){

            public void onImageAvailable(ImageReader reader) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onImageAvailable(AndroidImageReaderProxy.this);
                    }
                });
            }
        };
        this.mImageReader.setOnImageAvailableListener(transformedListener, MainThreadAsyncHandler.getInstance());
    }
}

