/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureRequest;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.CameraCaptureSessionCompat;
import androidx.core.util.Preconditions;
import java.util.List;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
class CameraCaptureSessionCompatBaseImpl
implements CameraCaptureSessionCompat.CameraCaptureSessionCompatImpl {
    final CameraCaptureSession mCameraCaptureSession;
    final Object mObject;

    CameraCaptureSessionCompatBaseImpl(@NonNull CameraCaptureSession captureSession, @Nullable Object implParams) {
        this.mCameraCaptureSession = (CameraCaptureSession)Preconditions.checkNotNull((Object)captureSession);
        this.mObject = implParams;
    }

    static CameraCaptureSessionCompat.CameraCaptureSessionCompatImpl create(@NonNull CameraCaptureSession captureSession, @NonNull Handler compatHandler) {
        return new CameraCaptureSessionCompatBaseImpl(captureSession, new CameraCaptureSessionCompatParamsApi21(compatHandler));
    }

    @Override
    public int captureBurstRequests(@NonNull List<CaptureRequest> requests, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        CameraCaptureSessionCompat.CaptureCallbackExecutorWrapper cb = new CameraCaptureSessionCompat.CaptureCallbackExecutorWrapper(executor, listener);
        CameraCaptureSessionCompatParamsApi21 params = (CameraCaptureSessionCompatParamsApi21)this.mObject;
        return this.mCameraCaptureSession.captureBurst(requests, (CameraCaptureSession.CaptureCallback)cb, params.mCompatHandler);
    }

    @Override
    public int captureSingleRequest(@NonNull CaptureRequest request, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        CameraCaptureSessionCompat.CaptureCallbackExecutorWrapper cb = new CameraCaptureSessionCompat.CaptureCallbackExecutorWrapper(executor, listener);
        CameraCaptureSessionCompatParamsApi21 params = (CameraCaptureSessionCompatParamsApi21)this.mObject;
        return this.mCameraCaptureSession.capture(request, (CameraCaptureSession.CaptureCallback)cb, params.mCompatHandler);
    }

    @Override
    public int setRepeatingBurstRequests(@NonNull List<CaptureRequest> requests, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        CameraCaptureSessionCompat.CaptureCallbackExecutorWrapper cb = new CameraCaptureSessionCompat.CaptureCallbackExecutorWrapper(executor, listener);
        CameraCaptureSessionCompatParamsApi21 params = (CameraCaptureSessionCompatParamsApi21)this.mObject;
        return this.mCameraCaptureSession.setRepeatingBurst(requests, (CameraCaptureSession.CaptureCallback)cb, params.mCompatHandler);
    }

    @Override
    public int setSingleRepeatingRequest(@NonNull CaptureRequest request, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        CameraCaptureSessionCompat.CaptureCallbackExecutorWrapper cb = new CameraCaptureSessionCompat.CaptureCallbackExecutorWrapper(executor, listener);
        CameraCaptureSessionCompatParamsApi21 params = (CameraCaptureSessionCompatParamsApi21)this.mObject;
        return this.mCameraCaptureSession.setRepeatingRequest(request, (CameraCaptureSession.CaptureCallback)cb, params.mCompatHandler);
    }

    @Override
    @NonNull
    public CameraCaptureSession unwrap() {
        return this.mCameraCaptureSession;
    }

    private static class CameraCaptureSessionCompatParamsApi21 {
        final Handler mCompatHandler;

        CameraCaptureSessionCompatParamsApi21(@NonNull Handler compatHandler) {
            this.mCompatHandler = compatHandler;
        }
    }
}

