/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.Camera2CameraImpl;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.impl.CameraFactory;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CameraStateRegistry;
import androidx.core.os.HandlerCompat;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class Camera2CameraFactory
implements CameraFactory {
    private static final int DEFAULT_ALLOWED_CONCURRENT_OPEN_CAMERAS = 1;
    private static final HandlerThread sHandlerThread = new HandlerThread("CameraX-");
    private static final Handler sHandler;
    private final CameraStateRegistry mCameraStateRegistry = new CameraStateRegistry(1);
    private final CameraManagerCompat mCameraManager;

    public Camera2CameraFactory(@NonNull Context context) {
        this.mCameraManager = CameraManagerCompat.from(context);
    }

    @NonNull
    public CameraInternal getCamera(@NonNull String cameraId) throws CameraInfoUnavailableException {
        if (!this.getAvailableCameraIds().contains(cameraId)) {
            throw new IllegalArgumentException("The given camera id is not on the available camera id list.");
        }
        Camera2CameraImpl camera2CameraImpl = new Camera2CameraImpl(this.mCameraManager, cameraId, this.mCameraStateRegistry, sHandler, sHandler);
        return camera2CameraImpl;
    }

    @NonNull
    public Set<String> getAvailableCameraIds() throws CameraInfoUnavailableException {
        List<String> camerasList;
        try {
            camerasList = Arrays.asList(this.mCameraManager.unwrap().getCameraIdList());
        }
        catch (CameraAccessException e) {
            throw new CameraInfoUnavailableException("Unable to retrieve list of cameras on device.", (Throwable)e);
        }
        return new LinkedHashSet<String>(camerasList);
    }

    @Nullable
    public String cameraIdForLensFacing(int lensFacing) throws CameraInfoUnavailableException {
        Set<String> cameraIds = this.getAvailableCameraIds();
        Integer lensFacingInteger = -1;
        switch (lensFacing) {
            case 1: {
                lensFacingInteger = 1;
                break;
            }
            case 0: {
                lensFacingInteger = 0;
            }
        }
        for (String cameraId : cameraIds) {
            CameraCharacteristics characteristics = null;
            try {
                characteristics = this.mCameraManager.unwrap().getCameraCharacteristics(cameraId);
            }
            catch (CameraAccessException e) {
                throw new CameraInfoUnavailableException("Unable to retrieve info for camera with id " + cameraId + ".", (Throwable)e);
            }
            Integer cameraLensFacing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
            if (cameraLensFacing == null || !cameraLensFacing.equals(lensFacingInteger)) continue;
            return cameraId;
        }
        return null;
    }

    static {
        sHandlerThread.start();
        sHandler = HandlerCompat.createAsync((Looper)sHandlerThread.getLooper());
    }
}

