/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.params;

import android.annotation.SuppressLint;
import android.os.Build;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompat;
import androidx.core.util.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@RequiresApi(value=21)
class OutputConfigurationCompatBaseImpl
implements OutputConfigurationCompat.OutputConfigurationCompatImpl {
    static final String TAG = "OutputConfigCompat";
    final Object mObject;

    OutputConfigurationCompatBaseImpl(@NonNull Surface surface) {
        this.mObject = new OutputConfigurationParamsApi21(surface);
    }

    OutputConfigurationCompatBaseImpl(@NonNull Object outputConfiguration) {
        this.mObject = outputConfiguration;
    }

    @Override
    public void enableSurfaceSharing() {
        ((OutputConfigurationParamsApi21)this.mObject).mIsShared = true;
    }

    boolean isSurfaceSharingEnabled() {
        return ((OutputConfigurationParamsApi21)this.mObject).mIsShared;
    }

    @Override
    public void setPhysicalCameraId(@Nullable String physicalCameraId) {
        ((OutputConfigurationParamsApi21)this.mObject).mPhysicalCameraId = physicalCameraId;
    }

    @Override
    @Nullable
    public String getPhysicalCameraId() {
        return ((OutputConfigurationParamsApi21)this.mObject).mPhysicalCameraId;
    }

    @Override
    public void addSurface(@NonNull Surface surface) {
        Preconditions.checkNotNull((Object)surface, (Object)"Surface must not be null");
        if (this.getSurface() == surface) {
            throw new IllegalStateException("Surface is already added!");
        }
        if (!this.isSurfaceSharingEnabled()) {
            throw new IllegalStateException("Cannot have 2 surfaces for a non-sharing configuration");
        }
        throw new IllegalArgumentException("Exceeds maximum number of surfaces");
    }

    @Override
    public void removeSurface(@NonNull Surface surface) {
        if (this.getSurface() == surface) {
            throw new IllegalArgumentException("Cannot remove surface associated with this output configuration");
        }
        throw new IllegalArgumentException("Surface is not part of this output configuration");
    }

    @Override
    public int getMaxSharedSurfaceCount() {
        return 1;
    }

    @Override
    @Nullable
    public Surface getSurface() {
        List<Surface> surfaces = ((OutputConfigurationParamsApi21)this.mObject).mSurfaces;
        if (surfaces.size() == 0) {
            return null;
        }
        return surfaces.get(0);
    }

    @Override
    @NonNull
    public List<Surface> getSurfaces() {
        return ((OutputConfigurationParamsApi21)this.mObject).mSurfaces;
    }

    @Override
    public int getSurfaceGroupId() {
        return -1;
    }

    @Override
    @Nullable
    public Object getOutputConfiguration() {
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OutputConfigurationCompatBaseImpl)) {
            return false;
        }
        return Objects.equals(this.mObject, ((OutputConfigurationCompatBaseImpl)obj).mObject);
    }

    public int hashCode() {
        return this.mObject.hashCode();
    }

    private static final class OutputConfigurationParamsApi21 {
        static final int MAX_SURFACES_COUNT = 1;
        private static final String LEGACY_CAMERA_DEVICE_CLASS = "android.hardware.camera2.legacy.LegacyCameraDevice";
        private static final String GET_SURFACE_SIZE_METHOD = "getSurfaceSize";
        private static final String DETECT_SURFACE_TYPE_METHOD = "detectSurfaceType";
        private static final String GET_GENERATION_ID_METHOD = "getGenerationId";
        final List<Surface> mSurfaces;
        final Size mConfiguredSize;
        final int mConfiguredFormat;
        final int mConfiguredGenerationId;
        @Nullable
        String mPhysicalCameraId;
        boolean mIsShared = false;

        OutputConfigurationParamsApi21(@NonNull Surface surface) {
            Preconditions.checkNotNull((Object)surface, (Object)"Surface must not be null");
            this.mSurfaces = Collections.singletonList(surface);
            this.mConfiguredSize = OutputConfigurationParamsApi21.getSurfaceSize(surface);
            this.mConfiguredFormat = OutputConfigurationParamsApi21.getSurfaceFormat(surface);
            this.mConfiguredGenerationId = OutputConfigurationParamsApi21.getSurfaceGenerationId(surface);
        }

        @SuppressLint(value={"BlockedPrivateApi"})
        private static Size getSurfaceSize(@NonNull Surface surface) {
            try {
                Class<?> legacyCameraDeviceClass = Class.forName(LEGACY_CAMERA_DEVICE_CLASS);
                Method getSurfaceSize = legacyCameraDeviceClass.getDeclaredMethod(GET_SURFACE_SIZE_METHOD, Surface.class);
                getSurfaceSize.setAccessible(true);
                return (Size)getSurfaceSize.invoke(null, surface);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                Log.e((String)OutputConfigurationCompatBaseImpl.TAG, (String)"Unable to retrieve surface size.", (Throwable)e);
                return null;
            }
        }

        @SuppressLint(value={"BlockedPrivateApi"})
        private static int getSurfaceFormat(@NonNull Surface surface) {
            try {
                Class<?> legacyCameraDeviceClass = Class.forName(LEGACY_CAMERA_DEVICE_CLASS);
                Method detectSurfaceType = legacyCameraDeviceClass.getDeclaredMethod(DETECT_SURFACE_TYPE_METHOD, Surface.class);
                if (Build.VERSION.SDK_INT < 22) {
                    detectSurfaceType.setAccessible(true);
                }
                return (Integer)detectSurfaceType.invoke(null, surface);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                Log.e((String)OutputConfigurationCompatBaseImpl.TAG, (String)"Unable to retrieve surface format.", (Throwable)e);
                return 0;
            }
        }

        @SuppressLint(value={"SoonBlockedPrivateApi"})
        private static int getSurfaceGenerationId(@NonNull Surface surface) {
            try {
                Method getGenerationId = Surface.class.getDeclaredMethod(GET_GENERATION_ID_METHOD, new Class[0]);
                return (Integer)getGenerationId.invoke((Object)surface, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                Log.e((String)OutputConfigurationCompatBaseImpl.TAG, (String)"Unable to retrieve surface generation id.", (Throwable)e);
                return -1;
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OutputConfigurationParamsApi21)) {
                return false;
            }
            OutputConfigurationParamsApi21 otherOutputConfig = (OutputConfigurationParamsApi21)obj;
            if (!this.mConfiguredSize.equals((Object)otherOutputConfig.mConfiguredSize) || this.mConfiguredFormat != otherOutputConfig.mConfiguredFormat || this.mConfiguredGenerationId != otherOutputConfig.mConfiguredGenerationId || this.mIsShared != otherOutputConfig.mIsShared || !Objects.equals(this.mPhysicalCameraId, otherOutputConfig.mPhysicalCameraId)) {
                return false;
            }
            int minLen = Math.min(this.mSurfaces.size(), otherOutputConfig.mSurfaces.size());
            for (int i = 0; i < minLen; ++i) {
                if (this.mSurfaces.get(i) == otherOutputConfig.mSurfaces.get(i)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int h = 1;
            h = (h << 5) - h ^ this.mSurfaces.hashCode();
            h = (h << 5) - h ^ this.mConfiguredGenerationId;
            h = (h << 5) - h ^ this.mConfiguredSize.hashCode();
            h = (h << 5) - h ^ this.mConfiguredFormat;
            h = (h << 5) - h ^ (this.mIsShared ? 1 : 0);
            h = (h << 5) - h ^ (this.mPhysicalCameraId == null ? 0 : this.mPhysicalCameraId.hashCode());
            return h;
        }
    }
}

