/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.content.Context;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.Camera2CaptureOptionUnpacker;
import androidx.camera.camera2.internal.Camera2SessionOptionUnpacker;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.Preview;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.PreviewConfig;
import androidx.camera.core.impl.SessionConfig;

public final class PreviewConfigProvider
implements ConfigProvider<PreviewConfig> {
    private static final String TAG = "PreviewConfigProvider";
    private final WindowManager mWindowManager;

    public PreviewConfigProvider(@NonNull Context context) {
        this.mWindowManager = (WindowManager)context.getSystemService("window");
    }

    @NonNull
    public PreviewConfig getConfig(@Nullable CameraInfo cameraInfo) {
        Preview.Builder builder = Preview.Builder.fromConfig((PreviewConfig)Preview.DEFAULT_CONFIG.getConfig(cameraInfo));
        SessionConfig.Builder sessionBuilder = new SessionConfig.Builder();
        sessionBuilder.setTemplateType(1);
        builder.setDefaultSessionConfig(sessionBuilder.build());
        builder.setSessionOptionUnpacker((SessionConfig.OptionUnpacker)Camera2SessionOptionUnpacker.INSTANCE);
        CaptureConfig.Builder captureBuilder = new CaptureConfig.Builder();
        captureBuilder.setTemplateType(1);
        builder.setDefaultCaptureConfig(captureBuilder.build());
        builder.setCaptureOptionUnpacker((CaptureConfig.OptionUnpacker)Camera2CaptureOptionUnpacker.INSTANCE);
        int targetRotation = this.mWindowManager.getDefaultDisplay().getRotation();
        builder.setTargetRotation(targetRotation);
        if (cameraInfo != null) {
            int rotationDegrees = cameraInfo.getSensorRotationDegrees(targetRotation);
            boolean isRotateNeeded = rotationDegrees == 90 || rotationDegrees == 270;
            builder.setTargetAspectRatioCustom(isRotateNeeded ? ImageOutputConfig.DEFAULT_ASPECT_RATIO_PORTRAIT : ImageOutputConfig.DEFAULT_ASPECT_RATIO_LANDSCAPE);
        }
        return builder.getUseCaseConfig();
    }
}

