/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.impl.CameraEventCallbacks;
import androidx.camera.camera2.internal.Camera2CaptureCallbacks;
import androidx.camera.camera2.internal.Camera2CaptureRequestBuilder;
import androidx.camera.camera2.internal.CameraBurstCaptureCallback;
import androidx.camera.camera2.internal.CameraCaptureSessionStateCallbacks;
import androidx.camera.camera2.internal.CaptureCallbackConverter;
import androidx.camera.camera2.internal.compat.CameraCaptureSessionCompat;
import androidx.camera.camera2.internal.compat.CameraDeviceCompat;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompat;
import androidx.camera.camera2.internal.compat.params.SessionConfigurationCompat;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.DeferrableSurfaces;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

final class CaptureSession {
    private static final String TAG = "CaptureSession";
    private static final long TIMEOUT_GET_SURFACE_IN_MS = 5000L;
    final Object mStateLock = new Object();
    private final Executor mExecutor;
    private final ScheduledExecutorService mScheduleExecutor;
    private final List<CaptureConfig> mCaptureConfigs = new ArrayList<CaptureConfig>();
    private final CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        }
    };
    private final StateCallback mCaptureSessionStateCallback = new StateCallback();
    @Nullable
    CameraCaptureSession mCameraCaptureSession;
    @Nullable
    volatile SessionConfig mSessionConfig;
    @Nullable
    volatile Config mCameraEventOnRepeatingOptions;
    private Map<DeferrableSurface, Surface> mConfiguredSurfaceMap = new HashMap<DeferrableSurface, Surface>();
    private final boolean mIsLegacyDevice;
    @GuardedBy(value="mStateLock")
    List<DeferrableSurface> mConfiguredDeferrableSurfaces = Collections.emptyList();
    @GuardedBy(value="mStateLock")
    State mState = State.INITIALIZED;
    @GuardedBy(value="mStateLock")
    ListenableFuture<Void> mReleaseFuture;
    @GuardedBy(value="mStateLock")
    CallbackToFutureAdapter.Completer<Void> mReleaseCompleter;
    @GuardedBy(value="mStateLock")
    ListenableFuture<Void> mOpenFuture;
    @GuardedBy(value="mStateLock")
    CallbackToFutureAdapter.Completer<Void> mOpenCaptureSessionCompleter;

    CaptureSession(@NonNull Executor executor, @NonNull ScheduledExecutorService scheduledExecutorService, boolean isLegacyDevice) {
        this.mExecutor = executor;
        this.mScheduleExecutor = scheduledExecutorService;
        this.mIsLegacyDevice = isLegacyDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    SessionConfig getSessionConfig() {
        Object object = this.mStateLock;
        synchronized (object) {
            return this.mSessionConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSessionConfig(SessionConfig sessionConfig) {
        Object object = this.mStateLock;
        synchronized (object) {
            switch (this.mState) {
                case UNINITIALIZED: {
                    throw new IllegalStateException("setSessionConfig() should not be possible in state: " + (Object)((Object)this.mState));
                }
                case INITIALIZED: 
                case GET_SURFACE: 
                case OPENING: {
                    this.mSessionConfig = sessionConfig;
                    break;
                }
                case OPENED: {
                    this.mSessionConfig = sessionConfig;
                    if (!this.mConfiguredSurfaceMap.keySet().containsAll(sessionConfig.getSurfaces())) {
                        Log.e((String)TAG, (String)"Does not have the proper configured lists");
                        return;
                    }
                    Log.d((String)TAG, (String)"Attempting to submit CaptureRequest after setting");
                    this.issueRepeatingCaptureRequests();
                    break;
                }
                case CLOSED: 
                case RELEASING: 
                case RELEASED: {
                    throw new IllegalStateException("Session configuration cannot be set on a closed/released session.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    ListenableFuture<Void> open(SessionConfig sessionConfig, CameraDevice cameraDevice) {
        Object object = this.mStateLock;
        synchronized (object) {
            switch (this.mState) {
                case INITIALIZED: {
                    this.mState = State.GET_SURFACE;
                    List surfaces = sessionConfig.getSurfaces();
                    this.mConfiguredDeferrableSurfaces = new ArrayList<DeferrableSurface>(surfaces);
                    this.mOpenFuture = FutureChain.from((ListenableFuture)DeferrableSurfaces.surfaceListWithTimeout(this.mConfiguredDeferrableSurfaces, (boolean)false, (long)5000L, (Executor)this.mExecutor, (ScheduledExecutorService)this.mScheduleExecutor)).transformAsync(surfaceList -> this.openCaptureSession((List<Surface>)surfaceList, sessionConfig, cameraDevice), this.mExecutor);
                    this.mOpenFuture.addListener(() -> {
                        Object object = this.mStateLock;
                        synchronized (object) {
                            this.mOpenFuture = null;
                        }
                    }, this.mExecutor);
                    return Futures.nonCancellationPropagating(this.mOpenFuture);
                }
            }
            Log.e((String)TAG, (String)("Open not allowed in state: " + (Object)((Object)this.mState)));
        }
        return Futures.immediateFailedFuture((Throwable)new IllegalStateException("open() should not allow the state: " + (Object)((Object)this.mState)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private ListenableFuture<Void> openCaptureSession(List<Surface> configuredSurfaces, SessionConfig sessionConfig, CameraDevice cameraDevice) {
        Object object = this.mStateLock;
        synchronized (object) {
            switch (this.mState) {
                case UNINITIALIZED: 
                case INITIALIZED: 
                case OPENED: {
                    return Futures.immediateFailedFuture((Throwable)new IllegalStateException("openCaptureSession() should not be possible in state: " + (Object)((Object)this.mState)));
                }
                case GET_SURFACE: {
                    return CallbackToFutureAdapter.getFuture(completer -> {
                        Preconditions.checkState((boolean)Thread.holdsLock(this.mStateLock));
                        if (configuredSurfaces.contains(null)) {
                            int i = configuredSurfaces.indexOf(null);
                            Log.d((String)TAG, (String)"Some surfaces were closed.");
                            DeferrableSurface deferrableSurface = this.mConfiguredDeferrableSurfaces.get(i);
                            this.mConfiguredDeferrableSurfaces.clear();
                            completer.setException((Throwable)new DeferrableSurface.SurfaceClosedException("Surface closed", deferrableSurface));
                            return "openCaptureSession-cancelled[session=" + this + "]";
                        }
                        if (configuredSurfaces.isEmpty()) {
                            completer.setException((Throwable)new IllegalArgumentException("Unable to open capture session with no surfaces."));
                            return "openCaptureSession-cancelled[session=" + this + "]";
                        }
                        try {
                            DeferrableSurfaces.incrementAll(this.mConfiguredDeferrableSurfaces);
                        }
                        catch (DeferrableSurface.SurfaceClosedException e) {
                            this.mConfiguredDeferrableSurfaces.clear();
                            completer.setException((Throwable)e);
                            return "openCaptureSession-cancelled[session=" + this + "]";
                        }
                        this.mConfiguredSurfaceMap.clear();
                        for (int i = 0; i < configuredSurfaces.size(); ++i) {
                            this.mConfiguredSurfaceMap.put(this.mConfiguredDeferrableSurfaces.get(i), (Surface)configuredSurfaces.get(i));
                        }
                        ArrayList uniqueConfiguredSurface = new ArrayList(new HashSet(configuredSurfaces));
                        Preconditions.checkState((this.mOpenCaptureSessionCompleter == null ? 1 : 0) != 0, (String)"The openCaptureSessionCompleter can only set once!");
                        this.mState = State.OPENING;
                        Log.d((String)TAG, (String)"Opening capture session.");
                        ArrayList<CameraCaptureSession.StateCallback> callbacks = new ArrayList<CameraCaptureSession.StateCallback>(sessionConfig.getSessionStateCallbacks());
                        callbacks.add(this.mCaptureSessionStateCallback);
                        CameraCaptureSession.StateCallback comboCallback = CameraCaptureSessionStateCallbacks.createComboCallback(callbacks);
                        Config options = sessionConfig.getImplementationOptions();
                        CameraEventCallbacks eventCallbacks = new Camera2ImplConfig(options).getCameraEventCallback(CameraEventCallbacks.createEmptyCallback());
                        List<CaptureConfig> presetList = eventCallbacks.createComboCallback().onPresetSession();
                        CaptureConfig.Builder captureConfigBuilder = CaptureConfig.Builder.from((CaptureConfig)sessionConfig.getRepeatingCaptureConfig());
                        for (CaptureConfig captureConfig : presetList) {
                            captureConfigBuilder.addImplementationOptions(captureConfig.getImplementationOptions());
                        }
                        LinkedList<OutputConfigurationCompat> outputConfigList = new LinkedList<OutputConfigurationCompat>();
                        for (Surface surface : uniqueConfiguredSurface) {
                            outputConfigList.add(new OutputConfigurationCompat(surface));
                        }
                        SessionConfigurationCompat sessionConfigurationCompat = new SessionConfigurationCompat(0, outputConfigList, this.getExecutor(), comboCallback);
                        CaptureRequest captureRequest = Camera2CaptureRequestBuilder.buildWithoutTarget(captureConfigBuilder.build(), cameraDevice);
                        if (captureRequest != null) {
                            sessionConfigurationCompat.setSessionParameters(captureRequest);
                        }
                        this.mOpenCaptureSessionCompleter = completer;
                        CameraDeviceCompat.createCaptureSession(cameraDevice, sessionConfigurationCompat);
                        return "openCaptureSession[session=" + this + "]";
                    });
                }
            }
            return Futures.immediateFailedFuture((Throwable)new CancellationException("openCaptureSession() not execute in state: " + (Object)((Object)this.mState)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.mStateLock;
        synchronized (object) {
            switch (this.mState) {
                case UNINITIALIZED: {
                    throw new IllegalStateException("close() should not be possible in state: " + (Object)((Object)this.mState));
                }
                case GET_SURFACE: {
                    if (this.mOpenFuture != null) {
                        this.mOpenFuture.cancel(true);
                    }
                }
                case INITIALIZED: {
                    this.mState = State.RELEASED;
                    break;
                }
                case OPENED: {
                    CameraEventCallbacks eventCallbacks;
                    List<CaptureConfig> configList;
                    if (this.mSessionConfig != null && !(configList = (eventCallbacks = new Camera2ImplConfig(this.mSessionConfig.getImplementationOptions()).getCameraEventCallback(CameraEventCallbacks.createEmptyCallback())).createComboCallback().onDisableSession()).isEmpty()) {
                        try {
                            this.issueCaptureRequests(this.setupConfiguredSurface(configList));
                        }
                        catch (IllegalStateException e) {
                            Log.e((String)TAG, (String)"Unable to issue the request before close the capture session", (Throwable)e);
                        }
                    }
                }
                case OPENING: {
                    this.mState = State.CLOSED;
                    this.mSessionConfig = null;
                    this.mCameraEventOnRepeatingOptions = null;
                    this.closeConfiguredDeferrableSurfaces();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<Void> release(boolean abortInFlightCaptures) {
        Object object = this.mStateLock;
        synchronized (object) {
            switch (this.mState) {
                case UNINITIALIZED: {
                    throw new IllegalStateException("release() should not be possible in state: " + (Object)((Object)this.mState));
                }
                case OPENED: 
                case CLOSED: {
                    if (this.mCameraCaptureSession != null) {
                        if (abortInFlightCaptures) {
                            try {
                                this.mCameraCaptureSession.abortCaptures();
                            }
                            catch (CameraAccessException e) {
                                Log.e((String)TAG, (String)"Unable to abort captures.", (Throwable)e);
                            }
                        }
                        this.mCameraCaptureSession.close();
                    }
                }
                case OPENING: {
                    this.mState = State.RELEASING;
                }
                case RELEASING: {
                    if (this.mReleaseFuture == null) {
                        this.mReleaseFuture = CallbackToFutureAdapter.getFuture((CallbackToFutureAdapter.Resolver)new CallbackToFutureAdapter.Resolver<Void>(){

                            public Object attachCompleter(@NonNull CallbackToFutureAdapter.Completer<Void> completer) {
                                Preconditions.checkState((boolean)Thread.holdsLock(CaptureSession.this.mStateLock));
                                Preconditions.checkState((CaptureSession.this.mReleaseCompleter == null ? 1 : 0) != 0, (String)"Release completer expected to be null");
                                CaptureSession.this.mReleaseCompleter = completer;
                                return "Release[session=" + CaptureSession.this + "]";
                            }
                        });
                    }
                    return this.mReleaseFuture;
                }
                case GET_SURFACE: {
                    if (this.mOpenFuture != null) {
                        this.mOpenFuture.cancel(true);
                    }
                }
                case INITIALIZED: {
                    this.mState = State.RELEASED;
                }
            }
        }
        return Futures.immediateFuture(null);
    }

    void forceClose() {
        this.mCaptureSessionStateCallback.onClosed(this.mCameraCaptureSession);
    }

    @GuardedBy(value="mStateLock")
    void clearConfiguredSurfaces() {
        DeferrableSurfaces.decrementAll(this.mConfiguredDeferrableSurfaces);
        this.mConfiguredDeferrableSurfaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void issueCaptureRequests(List<CaptureConfig> captureConfigs) {
        Object object = this.mStateLock;
        synchronized (object) {
            switch (this.mState) {
                case UNINITIALIZED: {
                    throw new IllegalStateException("issueCaptureRequests() should not be possible in state: " + (Object)((Object)this.mState));
                }
                case INITIALIZED: 
                case GET_SURFACE: 
                case OPENING: {
                    this.mCaptureConfigs.addAll(captureConfigs);
                    break;
                }
                case OPENED: {
                    this.mCaptureConfigs.addAll(captureConfigs);
                    this.issuePendingCaptureRequest();
                    break;
                }
                case CLOSED: 
                case RELEASING: 
                case RELEASED: {
                    throw new IllegalStateException("Cannot issue capture request on a closed/released session.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<CaptureConfig> getCaptureConfigs() {
        Object object = this.mStateLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.mCaptureConfigs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    State getState() {
        Object object = this.mStateLock;
        synchronized (object) {
            return this.mState;
        }
    }

    void issueRepeatingCaptureRequests() {
        if (this.mSessionConfig == null) {
            Log.d((String)TAG, (String)"Skipping issueRepeatingCaptureRequests for no configuration case.");
            return;
        }
        CaptureConfig captureConfig = this.mSessionConfig.getRepeatingCaptureConfig();
        try {
            CaptureRequest captureRequest;
            Log.d((String)TAG, (String)"Issuing request for session.");
            CaptureConfig.Builder captureConfigBuilder = CaptureConfig.Builder.from((CaptureConfig)captureConfig);
            CameraEventCallbacks eventCallbacks = new Camera2ImplConfig(this.mSessionConfig.getImplementationOptions()).getCameraEventCallback(CameraEventCallbacks.createEmptyCallback());
            this.mCameraEventOnRepeatingOptions = CaptureSession.mergeOptions(eventCallbacks.createComboCallback().onRepeating());
            if (this.mCameraEventOnRepeatingOptions != null) {
                captureConfigBuilder.addImplementationOptions(this.mCameraEventOnRepeatingOptions);
            }
            if ((captureRequest = Camera2CaptureRequestBuilder.build(captureConfigBuilder.build(), this.mCameraCaptureSession.getDevice(), this.mConfiguredSurfaceMap)) == null) {
                Log.d((String)TAG, (String)"Skipping issuing empty request for session.");
                return;
            }
            CameraCaptureSession.CaptureCallback comboCaptureCallback = this.createCamera2CaptureCallback(captureConfig.getCameraCaptureCallbacks(), this.mCaptureCallback);
            CameraCaptureSessionCompat.setSingleRepeatingRequest(this.mCameraCaptureSession, captureRequest, this.mExecutor, comboCaptureCallback);
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)("Unable to access camera: " + e.getMessage()));
            Thread.dumpStack();
        }
    }

    void issuePendingCaptureRequest() {
        if (this.mCaptureConfigs.isEmpty()) {
            return;
        }
        try {
            this.issueBurstCaptureRequest(this.mCaptureConfigs);
        }
        finally {
            this.mCaptureConfigs.clear();
        }
    }

    void issueBurstCaptureRequest(List<CaptureConfig> captureConfigs) {
        if (captureConfigs.isEmpty()) {
            return;
        }
        try {
            CameraBurstCaptureCallback callbackAggregator = new CameraBurstCaptureCallback();
            ArrayList<CaptureRequest> captureRequests = new ArrayList<CaptureRequest>();
            Log.d((String)TAG, (String)"Issuing capture request.");
            for (CaptureConfig captureConfig : captureConfigs) {
                if (captureConfig.getSurfaces().isEmpty()) {
                    Log.d((String)TAG, (String)"Skipping issuing empty capture request.");
                    continue;
                }
                boolean surfacesValid = true;
                for (DeferrableSurface surface : captureConfig.getSurfaces()) {
                    if (this.mConfiguredSurfaceMap.containsKey(surface)) continue;
                    Log.d((String)TAG, (String)("Skipping capture request with invalid surface: " + surface));
                    surfacesValid = false;
                    break;
                }
                if (!surfacesValid) continue;
                CaptureConfig.Builder captureConfigBuilder = CaptureConfig.Builder.from((CaptureConfig)captureConfig);
                if (this.mSessionConfig != null) {
                    captureConfigBuilder.addImplementationOptions(this.mSessionConfig.getRepeatingCaptureConfig().getImplementationOptions());
                }
                if (this.mCameraEventOnRepeatingOptions != null) {
                    captureConfigBuilder.addImplementationOptions(this.mCameraEventOnRepeatingOptions);
                }
                captureConfigBuilder.addImplementationOptions(captureConfig.getImplementationOptions());
                CaptureRequest captureRequest = Camera2CaptureRequestBuilder.build(captureConfigBuilder.build(), this.mCameraCaptureSession.getDevice(), this.mConfiguredSurfaceMap);
                if (captureRequest == null) {
                    Log.d((String)TAG, (String)"Skipping issuing request without surface.");
                    return;
                }
                ArrayList<CameraCaptureSession.CaptureCallback> cameraCallbacks = new ArrayList<CameraCaptureSession.CaptureCallback>();
                for (CameraCaptureCallback callback : captureConfig.getCameraCaptureCallbacks()) {
                    CaptureCallbackConverter.toCaptureCallback(callback, cameraCallbacks);
                }
                callbackAggregator.addCamera2Callbacks(captureRequest, cameraCallbacks);
                captureRequests.add(captureRequest);
            }
            if (!captureRequests.isEmpty()) {
                CameraCaptureSessionCompat.captureBurstRequests(this.mCameraCaptureSession, captureRequests, this.mExecutor, callbackAggregator);
            } else {
                Log.d((String)TAG, (String)"Skipping issuing burst request due to no valid request elements");
            }
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)("Unable to access camera: " + e.getMessage()));
            Thread.dumpStack();
        }
    }

    void cancelIssuedCaptureRequests() {
        if (!this.mCaptureConfigs.isEmpty()) {
            for (CaptureConfig captureConfig : this.mCaptureConfigs) {
                for (CameraCaptureCallback cameraCaptureCallback : captureConfig.getCameraCaptureCallbacks()) {
                    cameraCaptureCallback.onCaptureCancelled();
                }
            }
            this.mCaptureConfigs.clear();
        }
    }

    private CameraCaptureSession.CaptureCallback createCamera2CaptureCallback(List<CameraCaptureCallback> cameraCaptureCallbacks, CameraCaptureSession.CaptureCallback ... additionalCallbacks) {
        ArrayList<CameraCaptureSession.CaptureCallback> camera2Callbacks = new ArrayList<CameraCaptureSession.CaptureCallback>(cameraCaptureCallbacks.size() + additionalCallbacks.length);
        for (CameraCaptureCallback callback : cameraCaptureCallbacks) {
            camera2Callbacks.add(CaptureCallbackConverter.toCaptureCallback(callback));
        }
        Collections.addAll(camera2Callbacks, additionalCallbacks);
        return Camera2CaptureCallbacks.createComboCallback(camera2Callbacks);
    }

    @NonNull
    private static Config mergeOptions(List<CaptureConfig> captureConfigList) {
        MutableOptionsBundle options = MutableOptionsBundle.create();
        for (CaptureConfig captureConfig : captureConfigList) {
            Config newOptions = captureConfig.getImplementationOptions();
            Iterator iterator = newOptions.listOptions().iterator();
            while (iterator.hasNext()) {
                Config.Option option;
                Config.Option objectOpt = option = (Config.Option)iterator.next();
                Object newValue = newOptions.retrieveOption(objectOpt, null);
                if (options.containsOption(option)) {
                    Object oldValue = options.retrieveOption(objectOpt, null);
                    if (Objects.equals(oldValue, newValue)) continue;
                    Log.d((String)TAG, (String)("Detect conflicting option " + objectOpt.getId() + " : " + newValue + " != " + oldValue));
                    continue;
                }
                options.insertOption(objectOpt, newValue);
            }
        }
        return options;
    }

    void closeConfiguredDeferrableSurfaces() {
        if (this.mIsLegacyDevice || Build.VERSION.SDK_INT <= 23) {
            for (DeferrableSurface deferrableSurface : this.mConfiguredDeferrableSurfaces) {
                deferrableSurface.close();
            }
        }
    }

    List<CaptureConfig> setupConfiguredSurface(List<CaptureConfig> list) {
        ArrayList<CaptureConfig> ret = new ArrayList<CaptureConfig>();
        for (CaptureConfig c : list) {
            CaptureConfig.Builder builder = CaptureConfig.Builder.from((CaptureConfig)c);
            builder.setTemplateType(1);
            for (DeferrableSurface deferrableSurface : this.mSessionConfig.getRepeatingCaptureConfig().getSurfaces()) {
                builder.addSurface(deferrableSurface);
            }
            ret.add(builder.build());
        }
        return ret;
    }

    @NonNull
    private Executor getExecutor() {
        return this.mExecutor;
    }

    static final class Builder {
        private Executor mExecutor;
        private ScheduledExecutorService mScheduledExecutorService;
        private int mSupportedHardwareLevel = -1;

        Builder() {
        }

        CaptureSession build() {
            if (this.mExecutor == null) {
                throw new IllegalStateException("Missing camera executor. Executor must be set with setExecutor()");
            }
            if (this.mScheduledExecutorService == null) {
                throw new IllegalStateException("Missing ScheduledExecutorService. ScheduledExecutorService must be set with setScheduledExecutorService()");
            }
            return new CaptureSession(this.mExecutor, this.mScheduledExecutorService, this.mSupportedHardwareLevel == 2);
        }

        void setExecutor(@NonNull Executor executor) {
            this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        }

        void setScheduledExecutorService(@NonNull ScheduledExecutorService scheduledExecutorService) {
            this.mScheduledExecutorService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService);
        }

        void setSupportedHardwareLevel(int supportedHardwareLevel) {
            this.mSupportedHardwareLevel = supportedHardwareLevel;
        }
    }

    final class StateCallback
    extends CameraCaptureSession.StateCallback {
        StateCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConfigured(@NonNull CameraCaptureSession session) {
            Object object = CaptureSession.this.mStateLock;
            synchronized (object) {
                Preconditions.checkNotNull(CaptureSession.this.mOpenCaptureSessionCompleter, (Object)"OpenCaptureSession completer should not null");
                CaptureSession.this.mOpenCaptureSessionCompleter.set(null);
                CaptureSession.this.mOpenCaptureSessionCompleter = null;
                switch (CaptureSession.this.mState) {
                    case UNINITIALIZED: 
                    case INITIALIZED: 
                    case GET_SURFACE: 
                    case OPENED: 
                    case RELEASED: {
                        throw new IllegalStateException("onConfigured() should not be possible in state: " + (Object)((Object)CaptureSession.this.mState));
                    }
                    case OPENING: {
                        Config implOptions;
                        CameraEventCallbacks eventCallbacks;
                        List<CaptureConfig> list;
                        CaptureSession.this.mState = State.OPENED;
                        CaptureSession.this.mCameraCaptureSession = session;
                        if (CaptureSession.this.mSessionConfig != null && !(list = (eventCallbacks = new Camera2ImplConfig(implOptions = CaptureSession.this.mSessionConfig.getImplementationOptions()).getCameraEventCallback(CameraEventCallbacks.createEmptyCallback())).createComboCallback().onEnableSession()).isEmpty()) {
                            CaptureSession.this.issueBurstCaptureRequest(CaptureSession.this.setupConfiguredSurface(list));
                        }
                        Log.d((String)CaptureSession.TAG, (String)"Attempting to send capture request onConfigured");
                        CaptureSession.this.issueRepeatingCaptureRequests();
                        CaptureSession.this.issuePendingCaptureRequest();
                        break;
                    }
                    case CLOSED: {
                        CaptureSession.this.mCameraCaptureSession = session;
                        break;
                    }
                    case RELEASING: {
                        session.close();
                    }
                }
                Log.d((String)CaptureSession.TAG, (String)("CameraCaptureSession.onConfigured() mState=" + (Object)((Object)CaptureSession.this.mState)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReady(@NonNull CameraCaptureSession session) {
            Object object = CaptureSession.this.mStateLock;
            synchronized (object) {
                switch (CaptureSession.this.mState) {
                    case UNINITIALIZED: {
                        throw new IllegalStateException("onReady() should not be possible in state: " + (Object)((Object)CaptureSession.this.mState));
                    }
                }
                Log.d((String)CaptureSession.TAG, (String)("CameraCaptureSession.onReady() " + (Object)((Object)CaptureSession.this.mState)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClosed(@NonNull CameraCaptureSession session) {
            Object object = CaptureSession.this.mStateLock;
            synchronized (object) {
                if (CaptureSession.this.mState == State.UNINITIALIZED) {
                    throw new IllegalStateException("onClosed() should not be possible in state: " + (Object)((Object)CaptureSession.this.mState));
                }
                if (CaptureSession.this.mState == State.RELEASED) {
                    return;
                }
                Log.d((String)CaptureSession.TAG, (String)"CameraCaptureSession.onClosed()");
                CaptureSession.this.closeConfiguredDeferrableSurfaces();
                CaptureSession.this.mState = State.RELEASED;
                CaptureSession.this.mCameraCaptureSession = null;
                CaptureSession.this.clearConfiguredSurfaces();
                if (CaptureSession.this.mReleaseCompleter != null) {
                    CaptureSession.this.mReleaseCompleter.set(null);
                    CaptureSession.this.mReleaseCompleter = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConfigureFailed(@NonNull CameraCaptureSession session) {
            Object object = CaptureSession.this.mStateLock;
            synchronized (object) {
                Preconditions.checkNotNull(CaptureSession.this.mOpenCaptureSessionCompleter, (Object)"OpenCaptureSession completer should not null");
                CaptureSession.this.mOpenCaptureSessionCompleter.setException((Throwable)new CancellationException("onConfigureFailed"));
                CaptureSession.this.mOpenCaptureSessionCompleter = null;
                switch (CaptureSession.this.mState) {
                    case UNINITIALIZED: 
                    case INITIALIZED: 
                    case GET_SURFACE: 
                    case OPENED: 
                    case RELEASED: {
                        throw new IllegalStateException("onConfiguredFailed() should not be possible in state: " + (Object)((Object)CaptureSession.this.mState));
                    }
                    case OPENING: 
                    case CLOSED: {
                        CaptureSession.this.mState = State.RELEASED;
                        CaptureSession.this.mCameraCaptureSession = null;
                        break;
                    }
                    case RELEASING: {
                        CaptureSession.this.mState = State.RELEASING;
                        session.close();
                    }
                }
                Log.e((String)CaptureSession.TAG, (String)("CameraCaptureSession.onConfiguredFailed() " + (Object)((Object)CaptureSession.this.mState)));
            }
        }
    }

    static enum State {
        UNINITIALIZED,
        INITIALIZED,
        GET_SURFACE,
        OPENING,
        OPENED,
        CLOSED,
        RELEASING,
        RELEASED;

    }
}

