/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.annotation.SuppressLint;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.util.Rational;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.camera.camera2.internal.Camera2CameraControl;
import androidx.camera.camera2.internal.Camera2CameraInfoImpl;
import androidx.camera.camera2.internal.CameraDeviceStateCallbacks;
import androidx.camera.camera2.internal.CaptureSession;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.core.CameraControl;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.LiveDataObservable;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseAttachState;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

final class Camera2CameraImpl
implements CameraInternal {
    private static final String TAG = "Camera";
    private static final int ERROR_NONE = 0;
    private final UseCaseAttachState mUseCaseAttachState;
    private final CameraManagerCompat mCameraManager;
    final Handler mHandler;
    private final Executor mExecutor;
    volatile InternalState mState = InternalState.INITIALIZED;
    private final LiveDataObservable<CameraInternal.State> mObservableState = new LiveDataObservable();
    private final Camera2CameraControl mCameraControlInternal;
    private final StateCallback mStateCallback = new StateCallback();
    @NonNull
    final CameraInfoInternal mCameraInfoInternal;
    @Nullable
    CameraDevice mCameraDevice;
    int mCameraDeviceError = 0;
    private CaptureSession.Builder mCaptureSessionBuilder = new CaptureSession.Builder();
    CaptureSession mCaptureSession;
    SessionConfig mCameraControlSessionConfig = SessionConfig.defaultEmptySessionConfig();
    final AtomicInteger mReleaseRequestCount = new AtomicInteger(0);
    ListenableFuture<Void> mUserReleaseFuture;
    CallbackToFutureAdapter.Completer<Void> mUserReleaseNotifier;
    final Map<CaptureSession, ListenableFuture<Void>> mReleasedCaptureSessions = new LinkedHashMap<CaptureSession, ListenableFuture<Void>>();
    private final Observable<Integer> mAvailableCamerasObservable;
    private final CameraAvailability mCameraAvailability;
    final Set<CaptureSession> mConfiguringForClose = new HashSet<CaptureSession>();

    Camera2CameraImpl(CameraManagerCompat cameraManager, String cameraId, @NonNull Observable<Integer> availableCamerasObservable, Handler handler) {
        this.mCameraManager = cameraManager;
        this.mAvailableCamerasObservable = availableCamerasObservable;
        this.mHandler = handler;
        ScheduledExecutorService executorScheduler = CameraXExecutors.newHandlerExecutor((Handler)this.mHandler);
        this.mExecutor = executorScheduler;
        this.mUseCaseAttachState = new UseCaseAttachState(cameraId);
        this.mObservableState.postValue((Object)CameraInternal.State.CLOSED);
        try {
            CameraCharacteristics cameraCharacteristics = this.mCameraManager.unwrap().getCameraCharacteristics(cameraId);
            this.mCameraControlInternal = new Camera2CameraControl(cameraCharacteristics, executorScheduler, executorScheduler, new ControlUpdateListenerInternal());
            this.mCameraInfoInternal = new Camera2CameraInfoImpl(cameraId, cameraCharacteristics, this.mCameraControlInternal.getZoomControl(), this.mCameraControlInternal.getTorchControl());
            Camera2CameraInfoImpl camera2CameraInfo = (Camera2CameraInfoImpl)this.mCameraInfoInternal;
            this.mCaptureSessionBuilder.setSupportedHardwareLevel(camera2CameraInfo.getSupportedHardwareLevel());
        }
        catch (CameraAccessException e) {
            throw new IllegalStateException("Cannot access camera", e);
        }
        this.mCaptureSessionBuilder.setExecutor(this.mExecutor);
        this.mCaptureSessionBuilder.setScheduledExecutorService(executorScheduler);
        this.mCaptureSession = this.mCaptureSessionBuilder.build();
        this.mCameraAvailability = new CameraAvailability(cameraId);
        this.mAvailableCamerasObservable.addObserver(this.mExecutor, (Observable.Observer)this.mCameraAvailability);
        this.mCameraManager.registerAvailabilityCallback(this.mExecutor, this.mCameraAvailability);
    }

    public void open() {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2CameraImpl.this.open();
                }
            });
            return;
        }
        switch (this.mState) {
            case INITIALIZED: {
                this.openCameraDevice();
                break;
            }
            case CLOSING: {
                this.setState(InternalState.REOPENING);
                if (this.isSessionCloseComplete() || this.mCameraDeviceError != 0) break;
                Preconditions.checkState((this.mCameraDevice != null ? 1 : 0) != 0, (String)"Camera Device should be open if session close is not complete");
                this.setState(InternalState.OPENED);
                this.openCaptureSession();
                break;
            }
            default: {
                Log.d((String)TAG, (String)("open() ignored due to being in state: " + (Object)((Object)this.mState)));
            }
        }
    }

    public void close() {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2CameraImpl.this.close();
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Closing camera: " + this.mCameraInfoInternal.getCameraId()));
        switch (this.mState) {
            case OPENED: {
                this.setState(InternalState.CLOSING);
                this.closeCamera(false);
                break;
            }
            case OPENING: 
            case REOPENING: {
                this.setState(InternalState.CLOSING);
                break;
            }
            case PENDING_OPEN: {
                Preconditions.checkState((this.mCameraDevice == null ? 1 : 0) != 0);
                this.setState(InternalState.INITIALIZED);
                break;
            }
            default: {
                Log.d((String)TAG, (String)("close() ignored due to being in state: " + (Object)((Object)this.mState)));
            }
        }
    }

    @WorkerThread
    private void configAndClose(boolean abortInFlightCaptures) {
        final CaptureSession dummySession = this.mCaptureSessionBuilder.build();
        this.mConfiguringForClose.add(dummySession);
        this.resetCaptureSession(abortInFlightCaptures);
        final SurfaceTexture surfaceTexture = new SurfaceTexture(0);
        surfaceTexture.setDefaultBufferSize(640, 480);
        final Surface surface = new Surface(surfaceTexture);
        final Runnable closeAndCleanupRunner = new Runnable(){

            @Override
            public void run() {
                surface.release();
                surfaceTexture.release();
            }
        };
        SessionConfig.Builder builder = new SessionConfig.Builder();
        builder.addNonRepeatingSurface((DeferrableSurface)new ImmediateSurface(surface));
        builder.setTemplateType(1);
        Log.d((String)TAG, (String)"Start configAndClose.");
        ListenableFuture<Void> openDummyCaptureSession = dummySession.open(builder.build(), this.mCameraDevice);
        Futures.addCallback(openDummyCaptureSession, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                Camera2CameraImpl.this.closeStaleCaptureSessions(dummySession);
                Camera2CameraImpl.this.releaseDummySession(dummySession, closeAndCleanupRunner);
            }

            public void onFailure(Throwable t) {
                Log.d((String)Camera2CameraImpl.TAG, (String)("Unable to configure camera " + Camera2CameraImpl.this.mCameraInfoInternal.getCameraId() + " due to " + t.getMessage()));
                Camera2CameraImpl.this.releaseDummySession(dummySession, closeAndCleanupRunner);
            }
        }, (Executor)this.mExecutor);
    }

    void releaseDummySession(CaptureSession dummySession, Runnable closeAndCleanupRunner) {
        this.mConfiguringForClose.remove(dummySession);
        ListenableFuture<Void> releaseFuture = this.releaseSession(dummySession, false);
        releaseFuture.addListener(closeAndCleanupRunner, CameraXExecutors.directExecutor());
    }

    @WorkerThread
    boolean isSessionCloseComplete() {
        return this.mReleasedCaptureSessions.isEmpty() && this.mConfiguringForClose.isEmpty();
    }

    @WorkerThread
    void finishClose() {
        Preconditions.checkState((this.mState == InternalState.RELEASING || this.mState == InternalState.CLOSING ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.mReleasedCaptureSessions.isEmpty());
        this.mCameraDevice = null;
        if (this.mState == InternalState.CLOSING) {
            this.setState(InternalState.INITIALIZED);
        } else {
            this.setState(InternalState.RELEASED);
            this.mAvailableCamerasObservable.removeObserver((Observable.Observer)this.mCameraAvailability);
            this.mCameraManager.unregisterAvailabilityCallback(this.mCameraAvailability);
            if (this.mUserReleaseNotifier != null) {
                this.mUserReleaseNotifier.set(null);
                this.mUserReleaseNotifier = null;
            }
        }
    }

    @WorkerThread
    void closeCamera(boolean abortInFlightCaptures) {
        boolean isLegacyDevice;
        Preconditions.checkState((this.mState == InternalState.CLOSING || this.mState == InternalState.RELEASING || this.mState == InternalState.REOPENING && this.mCameraDeviceError != 0 ? 1 : 0) != 0, (String)("closeCamera should only be called in a CLOSING, RELEASING or REOPENING (with error) state. Current state: " + (Object)((Object)this.mState) + " (error: " + Camera2CameraImpl.getErrorMessage(this.mCameraDeviceError) + ")"));
        Camera2CameraInfoImpl camera2CameraInfo = (Camera2CameraInfoImpl)this.getCameraInfoInternal();
        boolean bl = isLegacyDevice = camera2CameraInfo.getSupportedHardwareLevel() == 2;
        if (Build.VERSION.SDK_INT > 23 && Build.VERSION.SDK_INT < 29 && isLegacyDevice && this.mCameraDeviceError == 0) {
            this.configAndClose(abortInFlightCaptures);
        } else {
            this.resetCaptureSession(abortInFlightCaptures);
        }
        this.mCaptureSession.cancelIssuedCaptureRequests();
    }

    @WorkerThread
    ListenableFuture<Void> releaseSession(final @NonNull CaptureSession captureSession, boolean abortInFlightCaptures) {
        captureSession.close();
        ListenableFuture<Void> releaseFuture = captureSession.release(abortInFlightCaptures);
        Log.d((String)TAG, (String)("releasing session in state " + this.mState.name()));
        this.mReleasedCaptureSessions.put(captureSession, releaseFuture);
        Futures.addCallback(releaseFuture, (FutureCallback)new FutureCallback<Void>(){

            @WorkerThread
            public void onSuccess(@Nullable Void result) {
                Camera2CameraImpl.this.mReleasedCaptureSessions.remove(captureSession);
                switch (Camera2CameraImpl.this.mState) {
                    case REOPENING: {
                        if (Camera2CameraImpl.this.mCameraDeviceError == 0) break;
                    }
                    case CLOSING: 
                    case RELEASING: {
                        if (!Camera2CameraImpl.this.isSessionCloseComplete() || Camera2CameraImpl.this.mCameraDevice == null) break;
                        Camera2CameraImpl.this.mCameraDevice.close();
                        Camera2CameraImpl.this.mCameraDevice = null;
                        break;
                    }
                }
            }

            public void onFailure(Throwable t) {
            }
        }, (Executor)CameraXExecutors.directExecutor());
        return releaseFuture;
    }

    @NonNull
    public ListenableFuture<Void> release() {
        ListenableFuture releaseFuture = CallbackToFutureAdapter.getFuture((CallbackToFutureAdapter.Resolver)new CallbackToFutureAdapter.Resolver<Void>(){

            public Object attachCompleter(final @NonNull CallbackToFutureAdapter.Completer<Void> completer) {
                Camera2CameraImpl.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Futures.propagate(Camera2CameraImpl.this.getOrCreateUserReleaseFuture(), (CallbackToFutureAdapter.Completer)completer);
                    }
                });
                return "Release[request=" + Camera2CameraImpl.this.mReleaseRequestCount.getAndIncrement() + "]";
            }
        });
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2CameraImpl.this.releaseInternal();
                }
            });
        } else {
            this.releaseInternal();
        }
        return releaseFuture;
    }

    @NonNull
    public Observable<CameraInternal.State> getCameraState() {
        return this.mObservableState;
    }

    @WorkerThread
    void releaseInternal() {
        switch (this.mState) {
            case INITIALIZED: 
            case PENDING_OPEN: {
                Preconditions.checkState((this.mCameraDevice == null ? 1 : 0) != 0);
                this.setState(InternalState.RELEASING);
                Preconditions.checkState((boolean)this.isSessionCloseComplete());
                this.finishClose();
                break;
            }
            case OPENED: {
                this.setState(InternalState.RELEASING);
                this.closeCamera(true);
                break;
            }
            case CLOSING: 
            case OPENING: 
            case REOPENING: 
            case RELEASING: {
                this.setState(InternalState.RELEASING);
                break;
            }
            default: {
                Log.d((String)TAG, (String)("release() ignored due to being in state: " + (Object)((Object)this.mState)));
            }
        }
    }

    @WorkerThread
    ListenableFuture<Void> getOrCreateUserReleaseFuture() {
        if (this.mUserReleaseFuture == null) {
            this.mUserReleaseFuture = this.mState != InternalState.RELEASED ? CallbackToFutureAdapter.getFuture((CallbackToFutureAdapter.Resolver)new CallbackToFutureAdapter.Resolver<Void>(){

                public Object attachCompleter(@NonNull CallbackToFutureAdapter.Completer<Void> completer) {
                    Preconditions.checkState((Camera2CameraImpl.this.mUserReleaseNotifier == null ? 1 : 0) != 0, (String)"Camera can only be released once, so release completer should be null on creation.");
                    Camera2CameraImpl.this.mUserReleaseNotifier = completer;
                    return "Release[camera=" + Camera2CameraImpl.this + "]";
                }
            }) : Futures.immediateFuture(null);
        }
        return this.mUserReleaseFuture;
    }

    public void onUseCaseActive(final @NonNull UseCase useCase) {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2CameraImpl.this.onUseCaseActive(useCase);
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Use case " + useCase + " ACTIVE for camera " + this.mCameraInfoInternal.getCameraId()));
        this.mUseCaseAttachState.setUseCaseActive(useCase);
        this.mUseCaseAttachState.updateUseCase(useCase);
        this.updateCaptureSessionConfig();
    }

    public void onUseCaseInactive(final @NonNull UseCase useCase) {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2CameraImpl.this.onUseCaseInactive(useCase);
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Use case " + useCase + " INACTIVE for camera " + this.mCameraInfoInternal.getCameraId()));
        this.mUseCaseAttachState.setUseCaseInactive(useCase);
        this.updateCaptureSessionConfig();
    }

    public void onUseCaseUpdated(final @NonNull UseCase useCase) {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2CameraImpl.this.onUseCaseUpdated(useCase);
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Use case " + useCase + " UPDATED for camera " + this.mCameraInfoInternal.getCameraId()));
        this.mUseCaseAttachState.updateUseCase(useCase);
        this.updateCaptureSessionConfig();
    }

    public void onUseCaseReset(final @NonNull UseCase useCase) {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Camera2CameraImpl.this.onUseCaseReset(useCase);
                }
            });
            return;
        }
        Log.d((String)TAG, (String)("Use case " + useCase + " RESET for camera " + this.mCameraInfoInternal.getCameraId()));
        this.mUseCaseAttachState.updateUseCase(useCase);
        this.resetCaptureSession(false);
        this.updateCaptureSessionConfig();
        this.openCaptureSession();
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    boolean isUseCaseOnline(@NonNull UseCase useCase) {
        try {
            return (Boolean)CallbackToFutureAdapter.getFuture(completer -> {
                if (!this.mHandler.post(() -> completer.set((Object)this.mUseCaseAttachState.isUseCaseOnline(useCase)))) {
                    completer.setException((Throwable)new RuntimeException("Unable to check if use case is online. Camera handler shut down."));
                }
                return "isUseCaseOnline";
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to check if use case is online.", e);
        }
    }

    public void addOnlineUseCase(@NonNull Collection<UseCase> useCases) {
        if (!useCases.isEmpty()) {
            this.mCameraControlInternal.setActive(true);
            this.mHandler.post(() -> this.tryAddOnlineUseCases(useCases));
        }
    }

    private void tryAddOnlineUseCases(@NonNull Collection<UseCase> toAdd) {
        ArrayList<UseCase> useCasesChangedToOnline = new ArrayList<UseCase>();
        String cameraId = this.mCameraInfoInternal.getCameraId();
        for (UseCase useCase : toAdd) {
            if (this.mUseCaseAttachState.isUseCaseOnline(useCase)) continue;
            useCasesChangedToOnline.add(useCase);
            this.mUseCaseAttachState.setUseCaseOnline(useCase);
        }
        if (useCasesChangedToOnline.isEmpty()) {
            return;
        }
        Log.d((String)TAG, (String)("Use cases [" + TextUtils.join((CharSequence)", ", useCasesChangedToOnline) + "] now ONLINE for camera " + cameraId));
        this.notifyStateOnlineToUseCases(useCasesChangedToOnline);
        this.updateCaptureSessionConfig();
        this.resetCaptureSession(false);
        if (this.mState == InternalState.OPENED) {
            this.openCaptureSession();
        } else {
            this.open();
        }
        this.updateCameraControlPreviewAspectRatio(useCasesChangedToOnline);
    }

    private void notifyStateOnlineToUseCases(List<UseCase> useCases) {
        CameraXExecutors.mainThreadExecutor().execute(() -> {
            for (UseCase useCase : useCases) {
                useCase.onStateOnline(this.mCameraInfoInternal.getCameraId());
            }
        });
    }

    private void notifyStateOfflineToUseCases(List<UseCase> useCases) {
        CameraXExecutors.mainThreadExecutor().execute(() -> {
            for (UseCase useCase : useCases) {
                useCase.onStateOffline(this.mCameraInfoInternal.getCameraId());
            }
        });
    }

    private void updateCameraControlPreviewAspectRatio(Collection<UseCase> useCases) {
        for (UseCase useCase : useCases) {
            if (!(useCase instanceof Preview)) continue;
            Size resolutoin = useCase.getAttachedSurfaceResolution(this.mCameraInfoInternal.getCameraId());
            Rational aspectRatio = new Rational(resolutoin.getWidth(), resolutoin.getHeight());
            this.mCameraControlInternal.setPreviewAspectRatio(aspectRatio);
            return;
        }
    }

    private void clearCameraControlPreviewAspectRatio(Collection<UseCase> removedUseCases) {
        for (UseCase useCase : removedUseCases) {
            if (!(useCase instanceof Preview)) continue;
            this.mCameraControlInternal.setPreviewAspectRatio(null);
            return;
        }
    }

    public void removeOnlineUseCase(@NonNull Collection<UseCase> useCases) {
        if (!useCases.isEmpty()) {
            this.mHandler.post(() -> this.tryRemoveOnlineUseCases(useCases));
        }
    }

    private void tryRemoveOnlineUseCases(@NonNull Collection<UseCase> toRemove) {
        ArrayList<UseCase> useCasesChangedToOffline = new ArrayList<UseCase>();
        for (UseCase useCase : toRemove) {
            if (!this.mUseCaseAttachState.isUseCaseOnline(useCase)) continue;
            this.mUseCaseAttachState.setUseCaseOffline(useCase);
            useCasesChangedToOffline.add(useCase);
        }
        if (useCasesChangedToOffline.isEmpty()) {
            return;
        }
        Log.d((String)TAG, (String)("Use cases [" + TextUtils.join((CharSequence)", ", useCasesChangedToOffline) + "] now OFFLINE for camera " + this.mCameraInfoInternal.getCameraId()));
        this.clearCameraControlPreviewAspectRatio(useCasesChangedToOffline);
        this.notifyStateOfflineToUseCases(useCasesChangedToOffline);
        boolean allUseCasesOffline = this.mUseCaseAttachState.getOnlineUseCases().isEmpty();
        if (allUseCasesOffline) {
            this.mCameraControlInternal.setActive(false);
            this.resetCaptureSession(false);
            this.close();
        } else {
            this.updateCaptureSessionConfig();
            this.resetCaptureSession(false);
            if (this.mState == InternalState.OPENED) {
                this.openCaptureSession();
            }
        }
    }

    @NonNull
    public CameraInfoInternal getCameraInfoInternal() {
        return this.mCameraInfoInternal;
    }

    @SuppressLint(value={"MissingPermission"})
    @WorkerThread
    void openCameraDevice() {
        if (!this.mCameraAvailability.isCameraAvailable()) {
            Log.d((String)TAG, (String)("No cameras available. Waiting for available camera before opening camera: " + this.mCameraInfoInternal.getCameraId()));
            this.setState(InternalState.PENDING_OPEN);
            return;
        }
        this.setState(InternalState.OPENING);
        Log.d((String)TAG, (String)("Opening camera: " + this.mCameraInfoInternal.getCameraId()));
        try {
            this.mCameraManager.openCamera(this.mCameraInfoInternal.getCameraId(), this.mExecutor, this.createDeviceStateCallback());
        }
        catch (CameraAccessException e) {
            Log.d((String)TAG, (String)("Unable to open camera " + this.mCameraInfoInternal.getCameraId() + " due to " + e.getMessage()));
        }
    }

    void updateCaptureSessionConfig() {
        SessionConfig.ValidatingBuilder validatingBuilder = this.mUseCaseAttachState.getActiveAndOnlineBuilder();
        if (validatingBuilder.isValid()) {
            validatingBuilder.add(this.mCameraControlSessionConfig);
            SessionConfig sessionConfig = validatingBuilder.build();
            this.mCaptureSession.setSessionConfig(sessionConfig);
        }
    }

    @WorkerThread
    void openCaptureSession() {
        Preconditions.checkState((this.mState == InternalState.OPENED ? 1 : 0) != 0);
        SessionConfig.ValidatingBuilder validatingBuilder = this.mUseCaseAttachState.getOnlineBuilder();
        if (!validatingBuilder.isValid()) {
            Log.d((String)TAG, (String)"Unable to create capture session due to conflicting configurations");
            return;
        }
        final CaptureSession captureSession = this.mCaptureSession;
        ListenableFuture<Void> openCaptureSession = captureSession.open(validatingBuilder.build(), this.mCameraDevice);
        Futures.addCallback(openCaptureSession, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                Camera2CameraImpl.this.closeStaleCaptureSessions(captureSession);
            }

            public void onFailure(Throwable t) {
                if (t instanceof CameraAccessException) {
                    Log.d((String)Camera2CameraImpl.TAG, (String)("Unable to configure camera " + Camera2CameraImpl.this.mCameraInfoInternal.getCameraId() + " due to " + t.getMessage()));
                } else if (t instanceof CancellationException) {
                    Log.d((String)Camera2CameraImpl.TAG, (String)("Unable to configure camera " + Camera2CameraImpl.this.mCameraInfoInternal.getCameraId() + " cancelled"));
                } else if (t instanceof DeferrableSurface.SurfaceClosedException) {
                    UseCase useCase = Camera2CameraImpl.this.findUseCaseForSurface(((DeferrableSurface.SurfaceClosedException)t).getDeferrableSurface());
                    if (useCase != null) {
                        Camera2CameraImpl.this.postSurfaceClosedError(useCase);
                    }
                } else if (t instanceof TimeoutException) {
                    Log.e((String)Camera2CameraImpl.TAG, (String)("Unable to configure camera " + Camera2CameraImpl.this.mCameraInfoInternal.getCameraId() + ", timeout!"));
                } else {
                    throw new RuntimeException(t);
                }
            }
        }, (Executor)this.mExecutor);
    }

    void closeStaleCaptureSessions(CaptureSession captureSession) {
        if (Build.VERSION.SDK_INT < 23) {
            CaptureSession[] captureSessions;
            for (CaptureSession releasingSession : captureSessions = this.mReleasedCaptureSessions.keySet().toArray(new CaptureSession[this.mReleasedCaptureSessions.size()])) {
                if (captureSession == releasingSession) break;
                releasingSession.forceClose();
            }
        }
    }

    @Nullable
    UseCase findUseCaseForSurface(@NonNull DeferrableSurface surface) {
        for (UseCase useCase : this.mUseCaseAttachState.getOnlineUseCases()) {
            SessionConfig sessionConfig = useCase.getSessionConfig(this.mCameraInfoInternal.getCameraId());
            if (!sessionConfig.getSurfaces().contains(surface)) continue;
            return useCase;
        }
        return null;
    }

    void postSurfaceClosedError(@NonNull UseCase useCase) {
        ScheduledExecutorService executor = CameraXExecutors.mainThreadExecutor();
        final SessionConfig sessionConfigError = useCase.getSessionConfig(this.mCameraInfoInternal.getCameraId());
        List errorListeners = sessionConfigError.getErrorListeners();
        if (!errorListeners.isEmpty()) {
            final SessionConfig.ErrorListener errorListener = (SessionConfig.ErrorListener)errorListeners.get(0);
            Log.d((String)TAG, (String)"Posting surface closed", (Throwable)new Throwable());
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    errorListener.onError(sessionConfigError, SessionConfig.SessionError.SESSION_ERROR_SURFACE_NEEDS_RESET);
                }
            });
        }
    }

    @WorkerThread
    void resetCaptureSession(boolean abortInFlightCaptures) {
        Preconditions.checkState((this.mCaptureSession != null ? 1 : 0) != 0);
        Log.d((String)TAG, (String)"Resetting Capture Session");
        CaptureSession oldCaptureSession = this.mCaptureSession;
        SessionConfig previousSessionConfig = oldCaptureSession.getSessionConfig();
        List<CaptureConfig> unissuedCaptureConfigs = oldCaptureSession.getCaptureConfigs();
        this.mCaptureSession = this.mCaptureSessionBuilder.build();
        this.mCaptureSession.setSessionConfig(previousSessionConfig);
        this.mCaptureSession.issueCaptureRequests(unissuedCaptureConfigs);
        this.releaseSession(oldCaptureSession, abortInFlightCaptures);
    }

    @WorkerThread
    private CameraDevice.StateCallback createDeviceStateCallback() {
        SessionConfig config = this.mUseCaseAttachState.getOnlineBuilder().build();
        List configuredStateCallbacks = config.getDeviceStateCallbacks();
        ArrayList<CameraDevice.StateCallback> allStateCallbacks = new ArrayList<CameraDevice.StateCallback>(configuredStateCallbacks);
        allStateCallbacks.add(this.mStateCallback);
        return CameraDeviceStateCallbacks.createComboCallback(allStateCallbacks);
    }

    private boolean checkAndAttachRepeatingSurface(CaptureConfig.Builder captureConfigBuilder) {
        if (!captureConfigBuilder.getSurfaces().isEmpty()) {
            Log.w((String)TAG, (String)"The capture config builder already has surface inside.");
            return false;
        }
        Collection activeUseCases = this.mUseCaseAttachState.getActiveAndOnlineUseCases();
        for (UseCase useCase : activeUseCases) {
            SessionConfig sessionConfig = useCase.getSessionConfig(this.mCameraInfoInternal.getCameraId());
            List surfaces = sessionConfig.getRepeatingCaptureConfig().getSurfaces();
            if (surfaces.isEmpty()) continue;
            for (DeferrableSurface surface : surfaces) {
                captureConfigBuilder.addSurface(surface);
            }
        }
        if (captureConfigBuilder.getSurfaces().isEmpty()) {
            Log.w((String)TAG, (String)"Unable to find a repeating surface to attach to CaptureConfig");
            return false;
        }
        return true;
    }

    @NonNull
    public CameraControlInternal getCameraControlInternal() {
        return this.mCameraControlInternal;
    }

    void submitCaptureRequests(@NonNull List<CaptureConfig> captureConfigs) {
        ArrayList<CaptureConfig> captureConfigsWithSurface = new ArrayList<CaptureConfig>();
        for (CaptureConfig captureConfig : captureConfigs) {
            CaptureConfig.Builder builder = CaptureConfig.Builder.from((CaptureConfig)captureConfig);
            if (captureConfig.getSurfaces().isEmpty() && captureConfig.isUseRepeatingSurface() && !this.checkAndAttachRepeatingSurface(builder)) continue;
            captureConfigsWithSurface.add(builder.build());
        }
        Log.d((String)TAG, (String)("issue capture request for camera " + this.mCameraInfoInternal.getCameraId()));
        this.mCaptureSession.issueCaptureRequests(captureConfigsWithSurface);
    }

    @NonNull
    public String toString() {
        return String.format(Locale.US, "Camera@%x[id=%s]", this.hashCode(), this.mCameraInfoInternal.getCameraId());
    }

    @NonNull
    public CameraControl getCameraControl() {
        return this.getCameraControlInternal();
    }

    @NonNull
    public CameraInfo getCameraInfo() {
        return this.getCameraInfoInternal();
    }

    @WorkerThread
    void setState(InternalState state) {
        Log.d((String)TAG, (String)("Transitioning camera internal state: " + (Object)((Object)this.mState) + " --> " + (Object)((Object)state)));
        this.mState = state;
        switch (state) {
            case INITIALIZED: {
                this.mObservableState.postValue((Object)CameraInternal.State.CLOSED);
                break;
            }
            case PENDING_OPEN: {
                this.mObservableState.postValue((Object)CameraInternal.State.PENDING_OPEN);
                break;
            }
            case OPENING: 
            case REOPENING: {
                this.mObservableState.postValue((Object)CameraInternal.State.OPENING);
                break;
            }
            case OPENED: {
                this.mObservableState.postValue((Object)CameraInternal.State.OPEN);
                break;
            }
            case CLOSING: {
                this.mObservableState.postValue((Object)CameraInternal.State.CLOSING);
                break;
            }
            case RELEASING: {
                this.mObservableState.postValue((Object)CameraInternal.State.RELEASING);
                break;
            }
            case RELEASED: {
                this.mObservableState.postValue((Object)CameraInternal.State.RELEASED);
            }
        }
    }

    static String getErrorMessage(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "ERROR_NONE";
            }
            case 4: {
                return "ERROR_CAMERA_DEVICE";
            }
            case 3: {
                return "ERROR_CAMERA_DISABLED";
            }
            case 1: {
                return "ERROR_CAMERA_IN_USE";
            }
            case 5: {
                return "ERROR_CAMERA_SERVICE";
            }
            case 2: {
                return "ERROR_MAX_CAMERAS_IN_USE";
            }
        }
        return "UNKNOWN ERROR";
    }

    void updateDefaultRequestBuilderToCameraControl(@NonNull CameraDevice cameraDevice) {
        try {
            int templateType = this.mCameraControlInternal.getDefaultTemplate();
            CaptureRequest.Builder builder = cameraDevice.createCaptureRequest(templateType);
            this.mCameraControlInternal.setDefaultRequestBuilder(builder);
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)"fail to create capture request.", (Throwable)e);
        }
    }

    final class ControlUpdateListenerInternal
    implements CameraControlInternal.ControlUpdateCallback {
        ControlUpdateListenerInternal() {
        }

        public void onCameraControlUpdateSessionConfig(@NonNull SessionConfig sessionConfig) {
            Camera2CameraImpl.this.mCameraControlSessionConfig = (SessionConfig)Preconditions.checkNotNull((Object)sessionConfig);
            Camera2CameraImpl.this.updateCaptureSessionConfig();
        }

        public void onCameraControlCaptureRequests(@NonNull List<CaptureConfig> captureConfigs) {
            Camera2CameraImpl.this.submitCaptureRequests((List)Preconditions.checkNotNull(captureConfigs));
        }
    }

    final class CameraAvailability
    extends CameraManager.AvailabilityCallback
    implements Observable.Observer<Integer> {
        private final String mCameraId;
        private boolean mCameraAvailable = true;
        private int mNumAvailableCameras = 0;

        CameraAvailability(String cameraId) {
            this.mCameraId = cameraId;
        }

        public void onCameraAvailable(@NonNull String cameraId) {
            if (!this.mCameraId.equals(cameraId)) {
                return;
            }
            this.mCameraAvailable = true;
            if (Camera2CameraImpl.this.mState == InternalState.PENDING_OPEN) {
                Camera2CameraImpl.this.openCameraDevice();
            }
        }

        public void onCameraUnavailable(@NonNull String cameraId) {
            if (!this.mCameraId.equals(cameraId)) {
                return;
            }
            this.mCameraAvailable = false;
        }

        public void onNewData(@Nullable Integer value) {
            Preconditions.checkNotNull((Object)value);
            if (value != this.mNumAvailableCameras) {
                this.mNumAvailableCameras = value;
                if (Camera2CameraImpl.this.mState == InternalState.PENDING_OPEN) {
                    Camera2CameraImpl.this.openCameraDevice();
                }
            }
        }

        public void onError(@NonNull Throwable t) {
        }

        boolean isCameraAvailable() {
            return this.mCameraAvailable && this.mNumAvailableCameras > 0;
        }
    }

    final class StateCallback
    extends CameraDevice.StateCallback {
        StateCallback() {
        }

        public void onOpened(CameraDevice cameraDevice) {
            Log.d((String)Camera2CameraImpl.TAG, (String)("CameraDevice.onOpened(): " + cameraDevice.getId()));
            Camera2CameraImpl.this.mCameraDevice = cameraDevice;
            Camera2CameraImpl.this.updateDefaultRequestBuilderToCameraControl(cameraDevice);
            Camera2CameraImpl.this.mCameraDeviceError = 0;
            switch (Camera2CameraImpl.this.mState) {
                case CLOSING: 
                case RELEASING: {
                    Preconditions.checkState((boolean)Camera2CameraImpl.this.isSessionCloseComplete());
                    Camera2CameraImpl.this.mCameraDevice.close();
                    Camera2CameraImpl.this.mCameraDevice = null;
                    break;
                }
                case OPENING: 
                case REOPENING: {
                    Camera2CameraImpl.this.setState(InternalState.OPENED);
                    Camera2CameraImpl.this.openCaptureSession();
                    break;
                }
                default: {
                    throw new IllegalStateException("onOpened() should not be possible from state: " + (Object)((Object)Camera2CameraImpl.this.mState));
                }
            }
        }

        public void onClosed(CameraDevice cameraDevice) {
            Log.d((String)Camera2CameraImpl.TAG, (String)("CameraDevice.onClosed(): " + cameraDevice.getId()));
            Preconditions.checkState((Camera2CameraImpl.this.mCameraDevice == null ? 1 : 0) != 0, (String)("Unexpected onClose callback on camera device: " + cameraDevice));
            switch (Camera2CameraImpl.this.mState) {
                case CLOSING: 
                case RELEASING: {
                    Preconditions.checkState((boolean)Camera2CameraImpl.this.isSessionCloseComplete());
                    Camera2CameraImpl.this.finishClose();
                    break;
                }
                case REOPENING: {
                    Camera2CameraImpl.this.openCameraDevice();
                    break;
                }
                default: {
                    throw new IllegalStateException("Camera closed while in state: " + (Object)((Object)Camera2CameraImpl.this.mState));
                }
            }
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            Log.d((String)Camera2CameraImpl.TAG, (String)("CameraDevice.onDisconnected(): " + cameraDevice.getId()));
            for (CaptureSession captureSession : Camera2CameraImpl.this.mReleasedCaptureSessions.keySet()) {
                captureSession.forceClose();
            }
            Camera2CameraImpl.this.mCaptureSession.forceClose();
            this.onError(cameraDevice, 1);
        }

        public void onError(@NonNull CameraDevice cameraDevice, int error) {
            Camera2CameraImpl.this.mCameraDevice = cameraDevice;
            Camera2CameraImpl.this.mCameraDeviceError = error;
            switch (Camera2CameraImpl.this.mState) {
                case CLOSING: 
                case RELEASING: {
                    Log.e((String)Camera2CameraImpl.TAG, (String)("CameraDevice.onError(): " + cameraDevice.getId() + " with error: " + Camera2CameraImpl.getErrorMessage(error)));
                    Camera2CameraImpl.this.closeCamera(false);
                    break;
                }
                case OPENED: 
                case OPENING: 
                case REOPENING: {
                    this.handleErrorOnOpen(cameraDevice, error);
                    break;
                }
                default: {
                    throw new IllegalStateException("onError() should not be possible from state: " + (Object)((Object)Camera2CameraImpl.this.mState));
                }
            }
        }

        private void handleErrorOnOpen(@NonNull CameraDevice cameraDevice, int error) {
            Preconditions.checkState((Camera2CameraImpl.this.mState == InternalState.OPENING || Camera2CameraImpl.this.mState == InternalState.OPENED || Camera2CameraImpl.this.mState == InternalState.REOPENING ? 1 : 0) != 0, (String)("Attempt to handle open error from non open state: " + (Object)((Object)Camera2CameraImpl.this.mState)));
            switch (error) {
                case 1: 
                case 2: 
                case 4: {
                    this.reopenCameraAfterError();
                    break;
                }
                default: {
                    Log.e((String)Camera2CameraImpl.TAG, (String)("Error observed on open (or opening) camera device " + cameraDevice.getId() + ": " + Camera2CameraImpl.getErrorMessage(error)));
                    Camera2CameraImpl.this.setState(InternalState.CLOSING);
                    Camera2CameraImpl.this.closeCamera(false);
                }
            }
        }

        private void reopenCameraAfterError() {
            Preconditions.checkState((Camera2CameraImpl.this.mCameraDeviceError != 0 ? 1 : 0) != 0, (String)"Can only reopen camera device after error if the camera device is actually in an error state.");
            Camera2CameraImpl.this.setState(InternalState.REOPENING);
            Camera2CameraImpl.this.closeCamera(false);
        }
    }

    static enum InternalState {
        INITIALIZED,
        PENDING_OPEN,
        OPENING,
        OPENED,
        CLOSING,
        REOPENING,
        RELEASING,
        RELEASED;

    }
}

