/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.graphics.Rect;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.util.Rational;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.AeFpsRange;
import androidx.camera.camera2.internal.CaptureCallbackContainer;
import androidx.camera.camera2.internal.FocusMeteringControl;
import androidx.camera.camera2.internal.TorchControl;
import androidx.camera.camera2.internal.ZoomControl;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.FocusMeteringResult;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.SessionConfig;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

final class Camera2CameraControl
implements CameraControlInternal {
    @VisibleForTesting
    final CameraControlSessionCallback mSessionCallback;
    final Executor mExecutor;
    private final CameraCharacteristics mCameraCharacteristics;
    private final CameraControlInternal.ControlUpdateCallback mControlUpdateCallback;
    private final SessionConfig.Builder mSessionConfigBuilder = new SessionConfig.Builder();
    volatile Rational mPreviewAspectRatio = null;
    private final FocusMeteringControl mFocusMeteringControl;
    private final ZoomControl mZoomControl;
    private final TorchControl mTorchControl;
    private final AeFpsRange mAeFpsRange;
    private volatile boolean mIsTorchOn = false;
    private volatile int mFlashMode = 2;
    private Rect mCropRect = null;

    Camera2CameraControl(@NonNull CameraCharacteristics cameraCharacteristics, @NonNull ScheduledExecutorService scheduler, @NonNull Executor executor, @NonNull CameraControlInternal.ControlUpdateCallback controlUpdateCallback) {
        this.mCameraCharacteristics = cameraCharacteristics;
        this.mControlUpdateCallback = controlUpdateCallback;
        this.mExecutor = executor;
        this.mSessionCallback = new CameraControlSessionCallback(this.mExecutor);
        this.mSessionConfigBuilder.setTemplateType(this.getDefaultTemplate());
        this.mSessionConfigBuilder.addRepeatingCameraCaptureCallback((CameraCaptureCallback)CaptureCallbackContainer.create(this.mSessionCallback));
        this.mFocusMeteringControl = new FocusMeteringControl(this, scheduler, this.mExecutor);
        this.mZoomControl = new ZoomControl(this, this.mCameraCharacteristics);
        this.mTorchControl = new TorchControl(this, this.mCameraCharacteristics);
        this.mAeFpsRange = new AeFpsRange(this.mCameraCharacteristics);
        this.mExecutor.execute(this::updateSessionConfig);
    }

    @NonNull
    public ZoomControl getZoomControl() {
        return this.mZoomControl;
    }

    @NonNull
    public TorchControl getTorchControl() {
        return this.mTorchControl;
    }

    void setActive(boolean isActive) {
        this.mFocusMeteringControl.setActive(isActive);
        this.mZoomControl.setActive(isActive);
        this.mTorchControl.setActive(isActive);
    }

    @WorkerThread
    public void setPreviewAspectRatio(@Nullable Rational previewAspectRatio) {
        this.mPreviewAspectRatio = previewAspectRatio;
    }

    public void setDefaultRequestBuilder(@NonNull CaptureRequest.Builder builder) {
        this.mFocusMeteringControl.setDefaultRequestBuilder(builder);
    }

    @NonNull
    public ListenableFuture<FocusMeteringResult> startFocusAndMetering(@NonNull FocusMeteringAction action) {
        return this.mFocusMeteringControl.startFocusAndMetering(action, this.mPreviewAspectRatio);
    }

    @NonNull
    public ListenableFuture<Void> cancelFocusAndMetering() {
        return this.mFocusMeteringControl.cancelFocusAndMetering();
    }

    @NonNull
    public ListenableFuture<Void> setZoomRatio(float ratio) {
        return this.mZoomControl.setZoomRatio(ratio);
    }

    @NonNull
    public ListenableFuture<Void> setLinearZoom(float linearZoom) {
        return this.mZoomControl.setLinearZoom(linearZoom);
    }

    public void setCropRegion(@Nullable Rect crop) {
        this.mExecutor.execute(() -> this.setCropRegionInternal(crop));
    }

    public int getFlashMode() {
        return this.mFlashMode;
    }

    public void setFlashMode(int flashMode) {
        this.mFlashMode = flashMode;
        this.mExecutor.execute(this::updateSessionConfig);
    }

    @NonNull
    public ListenableFuture<Void> enableTorch(boolean torch) {
        return this.mTorchControl.enableTorch(torch);
    }

    public void triggerAf() {
        this.mExecutor.execute(this.mFocusMeteringControl::triggerAf);
    }

    public void triggerAePrecapture() {
        this.mExecutor.execute(this.mFocusMeteringControl::triggerAePrecapture);
    }

    public void cancelAfAeTrigger(boolean cancelAfTrigger, boolean cancelAePrecaptureTrigger) {
        this.mExecutor.execute(() -> this.mFocusMeteringControl.cancelAfAeTrigger(cancelAfTrigger, cancelAePrecaptureTrigger));
    }

    public void submitCaptureRequests(@NonNull List<CaptureConfig> captureConfigs) {
        this.mExecutor.execute(() -> this.submitCaptureRequestsInternal(captureConfigs));
    }

    int getDefaultTemplate() {
        return 1;
    }

    @WorkerThread
    void updateSessionConfig() {
        this.mSessionConfigBuilder.setImplementationOptions(this.getSessionOptions());
        this.mControlUpdateCallback.onCameraControlUpdateSessionConfig(this.mSessionConfigBuilder.build());
    }

    @WorkerThread
    void setCropRegionInternal(Rect crop) {
        this.mCropRect = crop;
        this.updateSessionConfig();
    }

    @WorkerThread
    @NonNull
    Rect getCropSensorRegion() {
        Rect cropRect = this.mCropRect;
        if (cropRect == null) {
            cropRect = this.getSensorRect();
        }
        return cropRect;
    }

    @WorkerThread
    @NonNull
    Rect getSensorRect() {
        return (Rect)Preconditions.checkNotNull((Object)this.mCameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE));
    }

    @WorkerThread
    void removeCaptureResultListener(@NonNull CaptureResultListener listener) {
        this.mSessionCallback.removeListener(listener);
    }

    @WorkerThread
    void addCaptureResultListener(@NonNull CaptureResultListener listener) {
        this.mSessionCallback.addListener(listener);
    }

    void enableTorchInternal(boolean torch) {
        this.mExecutor.execute(() -> {
            this.mIsTorchOn = torch;
            if (!torch) {
                CaptureConfig.Builder singleRequestBuilder = new CaptureConfig.Builder();
                singleRequestBuilder.setTemplateType(this.getDefaultTemplate());
                singleRequestBuilder.setUseRepeatingSurface(true);
                Camera2ImplConfig.Builder configBuilder = new Camera2ImplConfig.Builder();
                configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_MODE, this.getSupportedAeMode(1));
                configBuilder.setCaptureRequestOption(CaptureRequest.FLASH_MODE, 0);
                singleRequestBuilder.addImplementationOptions((Config)configBuilder.build());
                this.submitCaptureRequestsInternal(Collections.singletonList(singleRequestBuilder.build()));
            }
            this.updateSessionConfig();
        });
    }

    @WorkerThread
    void submitCaptureRequestsInternal(List<CaptureConfig> captureConfigs) {
        this.mControlUpdateCallback.onCameraControlCaptureRequests(captureConfigs);
    }

    @VisibleForTesting
    @WorkerThread
    Config getSessionOptions() {
        Camera2ImplConfig.Builder builder = new Camera2ImplConfig.Builder();
        builder.setCaptureRequestOption(CaptureRequest.CONTROL_MODE, 1);
        this.mFocusMeteringControl.addFocusMeteringOptions(builder);
        this.mAeFpsRange.addAeFpsRangeOptions(builder);
        int aeMode = 1;
        if (this.mIsTorchOn) {
            builder.setCaptureRequestOption(CaptureRequest.FLASH_MODE, 2);
        } else {
            switch (this.mFlashMode) {
                case 2: {
                    aeMode = 1;
                    break;
                }
                case 1: {
                    aeMode = 3;
                    break;
                }
                case 0: {
                    aeMode = 2;
                }
            }
        }
        builder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_MODE, this.getSupportedAeMode(aeMode));
        builder.setCaptureRequestOption(CaptureRequest.CONTROL_AWB_MODE, this.getSupportedAwbMode(1));
        if (this.mCropRect != null) {
            builder.setCaptureRequestOption(CaptureRequest.SCALER_CROP_REGION, this.mCropRect);
        }
        return builder.build();
    }

    @WorkerThread
    int getSupportedAfMode(int preferredMode) {
        int[] modes = (int[])this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (modes == null) {
            return 0;
        }
        if (this.isModeInList(preferredMode, modes)) {
            return preferredMode;
        }
        if (this.isModeInList(4, modes)) {
            return 4;
        }
        if (this.isModeInList(1, modes)) {
            return 1;
        }
        return 0;
    }

    @WorkerThread
    private int getSupportedAeMode(int preferredMode) {
        int[] modes = (int[])this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
        if (modes == null) {
            return 0;
        }
        if (this.isModeInList(preferredMode, modes)) {
            return preferredMode;
        }
        if (this.isModeInList(1, modes)) {
            return 1;
        }
        return 0;
    }

    @WorkerThread
    private int getSupportedAwbMode(int preferredMode) {
        int[] modes = (int[])this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES);
        if (modes == null) {
            return 0;
        }
        if (this.isModeInList(preferredMode, modes)) {
            return preferredMode;
        }
        if (this.isModeInList(1, modes)) {
            return 1;
        }
        return 0;
    }

    @WorkerThread
    private boolean isModeInList(int mode, int[] modeList) {
        for (int m : modeList) {
            if (mode != m) continue;
            return true;
        }
        return false;
    }

    int getMaxAfRegionCount() {
        Integer count = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF);
        return count == null ? 0 : count;
    }

    int getMaxAeRegionCount() {
        Integer count = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AE);
        return count == null ? 0 : count;
    }

    int getMaxAwbRegionCount() {
        Integer count = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB);
        return count == null ? 0 : count;
    }

    static final class CameraControlSessionCallback
    extends CameraCaptureSession.CaptureCallback {
        final Set<CaptureResultListener> mResultListeners = new HashSet<CaptureResultListener>();
        private final Executor mExecutor;

        CameraControlSessionCallback(@NonNull Executor executor) {
            this.mExecutor = executor;
        }

        @WorkerThread
        void addListener(@NonNull CaptureResultListener listener) {
            this.mResultListeners.add(listener);
        }

        @WorkerThread
        void removeListener(@NonNull CaptureResultListener listener) {
            this.mResultListeners.remove(listener);
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            this.mExecutor.execute(() -> {
                HashSet<CaptureResultListener> removeSet = new HashSet<CaptureResultListener>();
                for (CaptureResultListener listener : this.mResultListeners) {
                    boolean isFinished = listener.onCaptureResult(result);
                    if (!isFinished) continue;
                    removeSet.add(listener);
                }
                if (!removeSet.isEmpty()) {
                    this.mResultListeners.removeAll(removeSet);
                }
            });
        }
    }

    static interface CaptureResultListener {
        public boolean onCaptureResult(@NonNull TotalCaptureResult var1);
    }
}

