/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.util.Range;
import androidx.annotation.NonNull;
import androidx.camera.camera2.impl.Camera2ImplConfig;

final class AeFpsRange {
    private Range<Integer> mAeTargetFpsRange = null;

    AeFpsRange(CameraCharacteristics cameraCharacteristics) {
        Integer hardwareLevel = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        if (hardwareLevel != null && hardwareLevel == 2) {
            Range[] ranges = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
            this.mAeTargetFpsRange = AeFpsRange.pickSuitableFpsRange(ranges);
        }
    }

    public void addAeFpsRangeOptions(@NonNull Camera2ImplConfig.Builder configBuilder) {
        if (this.mAeTargetFpsRange != null) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, this.mAeTargetFpsRange);
        }
    }

    private static Range<Integer> getCorrectedFpsRange(@NonNull Range<Integer> fpsRange) {
        int newUpper = (Integer)fpsRange.getUpper();
        int newLower = (Integer)fpsRange.getLower();
        if ((Integer)fpsRange.getUpper() >= 1000) {
            newUpper = (Integer)fpsRange.getUpper() / 1000;
        }
        if ((Integer)fpsRange.getLower() >= 1000) {
            newLower = (Integer)fpsRange.getLower() / 1000;
        }
        return new Range((Comparable)Integer.valueOf(newLower), (Comparable)Integer.valueOf(newUpper));
    }

    private static Range<Integer> pickSuitableFpsRange(Range<Integer>[] availableFpsRanges) {
        if (availableFpsRanges == null || availableFpsRanges.length == 0) {
            return null;
        }
        Range<Integer> pickedRange = null;
        for (Range<Integer> fpsRange : availableFpsRanges) {
            if ((Integer)(fpsRange = AeFpsRange.getCorrectedFpsRange(fpsRange)).getUpper() != 30) continue;
            if (pickedRange == null) {
                pickedRange = fpsRange;
                continue;
            }
            if ((Integer)fpsRange.getLower() >= (Integer)pickedRange.getLower()) continue;
            pickedRange = fpsRange;
        }
        return pickedRange;
    }
}

