/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.params.InputConfiguration;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.CameraCaptureSessionCompat;
import androidx.camera.camera2.internal.compat.CameraDeviceCompatApi23Impl;
import androidx.camera.camera2.internal.compat.params.InputConfigurationCompat;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompat;
import androidx.camera.camera2.internal.compat.params.SessionConfigurationCompat;
import androidx.camera.core.impl.utils.MainThreadAsyncHandler;
import androidx.core.util.Preconditions;
import java.util.List;

@RequiresApi(value=24)
class CameraDeviceCompatApi24Impl
extends CameraDeviceCompatApi23Impl {
    CameraDeviceCompatApi24Impl() {
    }

    @Override
    public void createCaptureSession(@NonNull CameraDevice device, @NonNull SessionConfigurationCompat config) throws CameraAccessException {
        CameraDeviceCompatApi24Impl.checkPreconditions(device, config);
        CameraCaptureSessionCompat.StateCallbackExecutorWrapper cb = new CameraCaptureSessionCompat.StateCallbackExecutorWrapper(config.getExecutor(), config.getStateCallback());
        List<OutputConfigurationCompat> outputs = config.getOutputConfigurations();
        Handler handler = MainThreadAsyncHandler.getInstance();
        InputConfigurationCompat inputConfigCompat = config.getInputConfiguration();
        if (inputConfigCompat != null) {
            InputConfiguration inputConfig = (InputConfiguration)inputConfigCompat.unwrap();
            Preconditions.checkNotNull((Object)inputConfig);
            device.createReprocessableCaptureSessionByConfigurations(inputConfig, SessionConfigurationCompat.transformFromCompat(outputs), (CameraCaptureSession.StateCallback)cb, handler);
        } else if (config.getSessionType() == 1) {
            device.createConstrainedHighSpeedCaptureSession(CameraDeviceCompatApi24Impl.unpackSurfaces(outputs), (CameraCaptureSession.StateCallback)cb, handler);
        } else {
            device.createCaptureSessionByOutputConfigurations(SessionConfigurationCompat.transformFromCompat(outputs), (CameraCaptureSession.StateCallback)cb, handler);
        }
    }
}

