/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureRequest;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.CameraCaptureSessionCompat;
import androidx.camera.core.impl.utils.MainThreadAsyncHandler;
import androidx.core.util.Preconditions;
import java.util.List;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
class CameraCaptureSessionCompatBaseImpl
implements CameraCaptureSessionCompat.CameraCaptureSessionCompatImpl {
    CameraCaptureSessionCompatBaseImpl() {
    }

    @Override
    public int captureBurstRequests(@NonNull CameraCaptureSession captureSession, @NonNull List<CaptureRequest> requests, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        Preconditions.checkNotNull((Object)captureSession);
        CameraCaptureSessionCompat.CaptureCallbackExecutorWrapper cb = new CameraCaptureSessionCompat.CaptureCallbackExecutorWrapper(executor, listener);
        return captureSession.captureBurst(requests, (CameraCaptureSession.CaptureCallback)cb, MainThreadAsyncHandler.getInstance());
    }

    @Override
    public int captureSingleRequest(@NonNull CameraCaptureSession captureSession, @NonNull CaptureRequest request, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        Preconditions.checkNotNull((Object)captureSession);
        CameraCaptureSessionCompat.CaptureCallbackExecutorWrapper cb = new CameraCaptureSessionCompat.CaptureCallbackExecutorWrapper(executor, listener);
        return captureSession.capture(request, (CameraCaptureSession.CaptureCallback)cb, MainThreadAsyncHandler.getInstance());
    }

    @Override
    public int setRepeatingBurstRequests(@NonNull CameraCaptureSession captureSession, @NonNull List<CaptureRequest> requests, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        Preconditions.checkNotNull((Object)captureSession);
        CameraCaptureSessionCompat.CaptureCallbackExecutorWrapper cb = new CameraCaptureSessionCompat.CaptureCallbackExecutorWrapper(executor, listener);
        return captureSession.setRepeatingBurst(requests, (CameraCaptureSession.CaptureCallback)cb, MainThreadAsyncHandler.getInstance());
    }

    @Override
    public int setSingleRepeatingRequest(@NonNull CameraCaptureSession captureSession, @NonNull CaptureRequest request, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        Preconditions.checkNotNull((Object)captureSession);
        CameraCaptureSessionCompat.CaptureCallbackExecutorWrapper cb = new CameraCaptureSessionCompat.CaptureCallbackExecutorWrapper(executor, listener);
        return captureSession.setRepeatingRequest(request, (CameraCaptureSession.CaptureCallback)cb, MainThreadAsyncHandler.getInstance());
    }
}

