/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.os.Build;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.CameraCaptureSessionCompatApi28Impl;
import androidx.camera.camera2.internal.compat.CameraCaptureSessionCompatBaseImpl;
import java.util.List;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public final class CameraCaptureSessionCompat {
    private static final CameraCaptureSessionCompatImpl IMPL = CameraCaptureSessionCompat.chooseImplementation();

    private CameraCaptureSessionCompat() {
    }

    private static CameraCaptureSessionCompatImpl chooseImplementation() {
        if (Build.VERSION.SDK_INT >= 28) {
            return new CameraCaptureSessionCompatApi28Impl();
        }
        return new CameraCaptureSessionCompatBaseImpl();
    }

    public static int captureBurstRequests(@NonNull CameraCaptureSession captureSession, @NonNull List<CaptureRequest> requests, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        return IMPL.captureBurstRequests(captureSession, requests, executor, listener);
    }

    public static int captureSingleRequest(@NonNull CameraCaptureSession captureSession, @NonNull CaptureRequest request, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        return IMPL.captureSingleRequest(captureSession, request, executor, listener);
    }

    public static int setRepeatingBurstRequests(@NonNull CameraCaptureSession captureSession, @NonNull List<CaptureRequest> requests, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        return IMPL.setRepeatingBurstRequests(captureSession, requests, executor, listener);
    }

    public static int setSingleRepeatingRequest(@NonNull CameraCaptureSession captureSession, @NonNull CaptureRequest request, @NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        return IMPL.setSingleRepeatingRequest(captureSession, request, executor, listener);
    }

    static final class StateCallbackExecutorWrapper
    extends CameraCaptureSession.StateCallback {
        final CameraCaptureSession.StateCallback mWrappedCallback;
        private final Executor mExecutor;

        StateCallbackExecutorWrapper(@NonNull Executor executor, @NonNull CameraCaptureSession.StateCallback wrappedCallback) {
            this.mExecutor = executor;
            this.mWrappedCallback = wrappedCallback;
        }

        public void onConfigured(final @NonNull CameraCaptureSession session) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onConfigured(session);
                }
            });
        }

        public void onConfigureFailed(final @NonNull CameraCaptureSession session) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onConfigureFailed(session);
                }
            });
        }

        public void onReady(final @NonNull CameraCaptureSession session) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onReady(session);
                }
            });
        }

        public void onActive(final @NonNull CameraCaptureSession session) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onActive(session);
                }
            });
        }

        @RequiresApi(value=26)
        public void onCaptureQueueEmpty(final @NonNull CameraCaptureSession session) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onCaptureQueueEmpty(session);
                }
            });
        }

        public void onClosed(final @NonNull CameraCaptureSession session) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onClosed(session);
                }
            });
        }

        @RequiresApi(value=23)
        public void onSurfacePrepared(final @NonNull CameraCaptureSession session, final @NonNull Surface surface) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onSurfacePrepared(session, surface);
                }
            });
        }
    }

    static final class CaptureCallbackExecutorWrapper
    extends CameraCaptureSession.CaptureCallback {
        final CameraCaptureSession.CaptureCallback mWrappedCallback;
        private final Executor mExecutor;

        CaptureCallbackExecutorWrapper(@NonNull Executor executor, @NonNull CameraCaptureSession.CaptureCallback wrappedCallback) {
            this.mExecutor = executor;
            this.mWrappedCallback = wrappedCallback;
        }

        public void onCaptureStarted(final @NonNull CameraCaptureSession session, final @NonNull CaptureRequest request, final long timestamp, final long frameNumber) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onCaptureStarted(session, request, timestamp, frameNumber);
                }
            });
        }

        public void onCaptureProgressed(final @NonNull CameraCaptureSession session, final @NonNull CaptureRequest request, final @NonNull CaptureResult partialResult) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onCaptureProgressed(session, request, partialResult);
                }
            });
        }

        public void onCaptureCompleted(final @NonNull CameraCaptureSession session, final @NonNull CaptureRequest request, final @NonNull TotalCaptureResult result) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onCaptureCompleted(session, request, result);
                }
            });
        }

        public void onCaptureFailed(final @NonNull CameraCaptureSession session, final @NonNull CaptureRequest request, final @NonNull CaptureFailure failure) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onCaptureFailed(session, request, failure);
                }
            });
        }

        public void onCaptureSequenceCompleted(final @NonNull CameraCaptureSession session, final int sequenceId, final long frameNumber) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onCaptureSequenceCompleted(session, sequenceId, frameNumber);
                }
            });
        }

        public void onCaptureSequenceAborted(final @NonNull CameraCaptureSession session, final int sequenceId) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onCaptureSequenceAborted(session, sequenceId);
                }
            });
        }

        @RequiresApi(value=24)
        public void onCaptureBufferLost(final @NonNull CameraCaptureSession session, final @NonNull CaptureRequest request, final @NonNull Surface target, final long frameNumber) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    mWrappedCallback.onCaptureBufferLost(session, request, target, frameNumber);
                }
            });
        }
    }

    static interface CameraCaptureSessionCompatImpl {
        public int captureBurstRequests(@NonNull CameraCaptureSession var1, @NonNull List<CaptureRequest> var2, @NonNull Executor var3, @NonNull CameraCaptureSession.CaptureCallback var4) throws CameraAccessException;

        public int captureSingleRequest(@NonNull CameraCaptureSession var1, @NonNull CaptureRequest var2, @NonNull Executor var3, @NonNull CameraCaptureSession.CaptureCallback var4) throws CameraAccessException;

        public int setRepeatingBurstRequests(@NonNull CameraCaptureSession var1, @NonNull List<CaptureRequest> var2, @NonNull Executor var3, @NonNull CameraCaptureSession.CaptureCallback var4) throws CameraAccessException;

        public int setSingleRepeatingRequest(@NonNull CameraCaptureSession var1, @NonNull CaptureRequest var2, @NonNull Executor var3, @NonNull CameraCaptureSession.CaptureCallback var4) throws CameraAccessException;
    }
}

