/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import androidx.camera.core.ImageCapture;
import androidx.camera.core.UseCase;
import androidx.camera.core.VideoCapture;
import java.util.List;

final class UseCaseSurfaceOccupancyManager {
    private UseCaseSurfaceOccupancyManager() {
    }

    static void checkUseCaseLimitNotExceeded(List<UseCase> originalUseCases, List<UseCase> newUseCases) {
        int imageCaptureCount = 0;
        int videoCaptureCount = 0;
        if (newUseCases == null || newUseCases.isEmpty()) {
            throw new IllegalArgumentException("No new use cases to be bound.");
        }
        if (originalUseCases != null) {
            for (UseCase useCase : originalUseCases) {
                if (useCase instanceof ImageCapture) {
                    ++imageCaptureCount;
                    continue;
                }
                if (!(useCase instanceof VideoCapture)) continue;
                ++videoCaptureCount;
            }
        }
        for (UseCase useCase : newUseCases) {
            if (useCase instanceof ImageCapture) {
                ++imageCaptureCount;
                continue;
            }
            if (!(useCase instanceof VideoCapture)) continue;
            ++videoCaptureCount;
        }
        if (imageCaptureCount > 1) {
            throw new IllegalArgumentException("Exceeded max simultaneously bound image capture use cases.");
        }
        if (videoCaptureCount > 1) {
            throw new IllegalArgumentException("Exceeded max simultaneously bound video capture use cases.");
        }
    }
}

