/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.camera.camera2.internal.Camera2CameraControl;
import androidx.camera.core.CameraControl;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.google.common.util.concurrent.ListenableFuture;

final class TorchControl {
    private static final String TAG = "TorchControl";
    final Object mEnableTorchLock = new Object();
    private final Object mActiveLock = new Object();
    private final Camera2CameraControl mCamera2CameraControl;
    private final MutableLiveData<Integer> mTorchState;
    private final boolean mHasFlashUnit;
    @GuardedBy(value="mActiveLock")
    private boolean mIsActive;
    @GuardedBy(value="mEnableTorchLock")
    CallbackToFutureAdapter.Completer<Void> mEnableTorchCompleter;
    @GuardedBy(value="mEnableTorchLock")
    boolean mTargetTorchEnabled;
    private final Camera2CameraControl.CaptureResultListener mCaptureResultListener = new Camera2CameraControl.CaptureResultListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onCaptureResult(@NonNull TotalCaptureResult captureResult) {
            CallbackToFutureAdapter.Completer<Void> completerToSet = null;
            Object object = TorchControl.this.mEnableTorchLock;
            synchronized (object) {
                if (TorchControl.this.mEnableTorchCompleter != null) {
                    boolean torchEnabled;
                    CaptureRequest captureRequest = captureResult.getRequest();
                    Integer flashMode = (Integer)captureRequest.get(CaptureRequest.FLASH_MODE);
                    boolean bl = torchEnabled = flashMode != null && flashMode == 2;
                    if (torchEnabled == TorchControl.this.mTargetTorchEnabled) {
                        completerToSet = TorchControl.this.mEnableTorchCompleter;
                        TorchControl.this.mEnableTorchCompleter = null;
                    }
                }
            }
            if (completerToSet != null) {
                completerToSet.set(null);
            }
            return false;
        }
    };

    TorchControl(@NonNull Camera2CameraControl camera2CameraControl, @NonNull CameraCharacteristics cameraCharacteristics) {
        this.mCamera2CameraControl = camera2CameraControl;
        Boolean hasFlashUnit = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        this.mHasFlashUnit = hasFlashUnit != null && hasFlashUnit != false;
        this.mTorchState = new MutableLiveData((Object)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActive(boolean isActive) {
        Object object = this.mActiveLock;
        synchronized (object) {
            if (this.mIsActive == isActive) {
                return;
            }
            this.mIsActive = isActive;
            if (isActive) {
                this.mCamera2CameraControl.addCaptureResultListener(this.mCaptureResultListener);
            } else {
                this.mCamera2CameraControl.removeCaptureResultListener(this.mCaptureResultListener);
            }
            boolean shouldResetDefault = false;
            CallbackToFutureAdapter.Completer<Void> completerToCancel = null;
            Object object2 = this.mEnableTorchLock;
            synchronized (object2) {
                if (!isActive) {
                    if (this.mEnableTorchCompleter != null) {
                        completerToCancel = this.mEnableTorchCompleter;
                        this.mEnableTorchCompleter = null;
                    }
                    if (this.mTargetTorchEnabled) {
                        shouldResetDefault = true;
                        this.mTargetTorchEnabled = false;
                        this.mCamera2CameraControl.enableTorchInternal(false);
                    }
                }
            }
            if (shouldResetDefault) {
                this.setLiveDataValue(this.mTorchState, 0);
            }
            if (completerToCancel != null) {
                completerToCancel.setException((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<Void> enableTorch(boolean enabled) {
        if (!this.mHasFlashUnit) {
            Log.d((String)TAG, (String)"Unable to enableTorch due to there is no flash unit.");
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("No flash unit"));
        }
        Object object = this.mActiveLock;
        synchronized (object) {
            if (!this.mIsActive) {
                return Futures.immediateFailedFuture((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
            }
            ListenableFuture future = CallbackToFutureAdapter.getFuture(completer -> {
                CallbackToFutureAdapter.Completer<Void> completerToCancel = null;
                Object object = this.mEnableTorchLock;
                synchronized (object) {
                    if (this.mEnableTorchCompleter != null) {
                        completerToCancel = this.mEnableTorchCompleter;
                    }
                    this.mEnableTorchCompleter = completer;
                    this.mTargetTorchEnabled = enabled;
                    this.mCamera2CameraControl.enableTorchInternal(enabled);
                }
                this.setLiveDataValue(this.mTorchState, enabled ? 1 : 0);
                if (completerToCancel != null) {
                    completerToCancel.setException((Throwable)new CameraControl.OperationCanceledException("There is a new enableTorch being set"));
                }
                return "enableTorch: " + enabled;
            });
            return future;
        }
    }

    @NonNull
    LiveData<Integer> getTorchState() {
        return this.mTorchState;
    }

    private <T> void setLiveDataValue(@NonNull MutableLiveData<T> liveData, T value) {
        if (Threads.isMainThread()) {
            liveData.setValue(value);
        } else {
            liveData.postValue(value);
        }
    }
}

