/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.content.Context;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.CamcorderProfileHelper;
import androidx.camera.core.CameraX;
import androidx.camera.core.ImageOutputConfig;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseConfig;
import androidx.camera.core.impl.SurfaceCombination;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.SurfaceSizeDefinition;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class SupportedSurfaceCombination {
    private static final Size MAX_PREVIEW_SIZE = new Size(1920, 1080);
    private static final Size DEFAULT_SIZE = new Size(640, 480);
    private static final Size ZERO_SIZE = new Size(0, 0);
    private static final Size QUALITY_2160P_SIZE = new Size(3840, 2160);
    private static final Size QUALITY_1080P_SIZE = new Size(1920, 1080);
    private static final Size QUALITY_720P_SIZE = new Size(1280, 720);
    private static final Size QUALITY_480P_SIZE = new Size(720, 480);
    private static final int ALIGN16 = 16;
    private static final Rational ASPECT_RATIO_4_3 = new Rational(4, 3);
    private static final Rational ASPECT_RATIO_3_4 = new Rational(3, 4);
    private static final Rational ASPECT_RATIO_16_9 = new Rational(16, 9);
    private static final Rational ASPECT_RATIO_9_16 = new Rational(9, 16);
    private final List<SurfaceCombination> mSurfaceCombinations = new ArrayList<SurfaceCombination>();
    private final Map<Integer, Size> mMaxSizeCache = new HashMap<Integer, Size>();
    private String mCameraId;
    private CameraCharacteristics mCharacteristics;
    private int mHardwareLevel = 2;
    private boolean mIsRawSupported = false;
    private boolean mIsBurstCaptureSupported = false;
    private SurfaceSizeDefinition mSurfaceSizeDefinition;
    private CamcorderProfileHelper mCamcorderProfileHelper;

    SupportedSurfaceCombination(Context context, String cameraId, CamcorderProfileHelper camcorderProfileHelper) {
        this.mCameraId = cameraId;
        this.mCamcorderProfileHelper = camcorderProfileHelper;
        this.init(context);
    }

    private SupportedSurfaceCombination() {
    }

    String getCameraId() {
        return this.mCameraId;
    }

    boolean isRawSupported() {
        return this.mIsRawSupported;
    }

    boolean isBurstCaptureSupported() {
        return this.mIsBurstCaptureSupported;
    }

    boolean checkSupported(List<SurfaceConfig> surfaceConfigList) {
        SurfaceCombination surfaceCombination;
        boolean isSupported = false;
        Iterator<SurfaceCombination> iterator = this.mSurfaceCombinations.iterator();
        while (iterator.hasNext() && !(isSupported = (surfaceCombination = iterator.next()).isSupported(surfaceConfigList))) {
        }
        return isSupported;
    }

    SurfaceConfig transformSurfaceConfig(int imageFormat, Size size) {
        SurfaceConfig.ConfigSize configSize = SurfaceConfig.ConfigSize.NOT_SUPPORT;
        if (this.getAllOutputSizesByFormat(imageFormat) == null) {
            throw new IllegalArgumentException("Can not get supported output size for the format: " + imageFormat);
        }
        SurfaceConfig.ConfigType configType = imageFormat == 35 ? SurfaceConfig.ConfigType.YUV : (imageFormat == 256 ? SurfaceConfig.ConfigType.JPEG : (imageFormat == 32 ? SurfaceConfig.ConfigType.RAW : SurfaceConfig.ConfigType.PRIV));
        Size maxSize = this.fetchMaxSize(imageFormat);
        if (size.getWidth() * size.getHeight() <= this.mSurfaceSizeDefinition.getAnalysisSize().getWidth() * this.mSurfaceSizeDefinition.getAnalysisSize().getHeight()) {
            configSize = SurfaceConfig.ConfigSize.ANALYSIS;
        } else if (size.getWidth() * size.getHeight() <= this.mSurfaceSizeDefinition.getPreviewSize().getWidth() * this.mSurfaceSizeDefinition.getPreviewSize().getHeight()) {
            configSize = SurfaceConfig.ConfigSize.PREVIEW;
        } else if (size.getWidth() * size.getHeight() <= this.mSurfaceSizeDefinition.getRecordSize().getWidth() * this.mSurfaceSizeDefinition.getRecordSize().getHeight()) {
            configSize = SurfaceConfig.ConfigSize.RECORD;
        } else if (size.getWidth() * size.getHeight() <= maxSize.getWidth() * maxSize.getHeight()) {
            configSize = SurfaceConfig.ConfigSize.MAXIMUM;
        }
        return SurfaceConfig.create((SurfaceConfig.ConfigType)configType, (SurfaceConfig.ConfigSize)configSize);
    }

    Map<UseCase, Size> getSuggestedResolutions(List<UseCase> originalUseCases, List<UseCase> newUseCases) {
        HashMap<UseCase, Size> suggestedResolutionsMap = new HashMap<UseCase, Size>();
        List<Integer> useCasesPriorityOrder = this.getUseCasesPriorityOrder(newUseCases);
        ArrayList<List<Size>> supportedOutputSizesList = new ArrayList<List<Size>>();
        for (Integer index : useCasesPriorityOrder) {
            List<Size> supportedOutputSizes = this.getSupportedOutputSizes(newUseCases.get(index));
            supportedOutputSizesList.add(supportedOutputSizes);
        }
        List<List<Size>> allPossibleSizeArrangements = this.getAllPossibleSizeArrangements(supportedOutputSizesList);
        for (List<Size> possibleSizeList : allPossibleSizeArrangements) {
            ArrayList<SurfaceConfig> surfaceConfigList = new ArrayList<SurfaceConfig>();
            if (originalUseCases != null) {
                for (UseCase useCase : originalUseCases) {
                    Size resolution = useCase.getAttachedSurfaceResolution(useCase.getBoundCamera().getCameraInfoInternal().getCameraId());
                    surfaceConfigList.add(this.transformSurfaceConfig(useCase.getImageFormat(), resolution));
                }
            }
            for (int i = 0; i < possibleSizeList.size(); ++i) {
                Size size = possibleSizeList.get(i);
                UseCase newUseCase = newUseCases.get(useCasesPriorityOrder.get(i));
                surfaceConfigList.add(this.transformSurfaceConfig(newUseCase.getImageFormat(), size));
            }
            if (!this.checkSupported(surfaceConfigList)) continue;
            for (UseCase useCase : newUseCases) {
                suggestedResolutionsMap.put(useCase, possibleSizeList.get(useCasesPriorityOrder.indexOf(newUseCases.indexOf(useCase))));
            }
        }
        return suggestedResolutionsMap;
    }

    boolean requiresCorrectedAspectRatio() {
        return this.mHardwareLevel == 2 && Build.VERSION.SDK_INT == 21;
    }

    Rational getCorrectedAspectRatio(int targetRotation) {
        Rational outputRatio = null;
        if (this.mHardwareLevel == 2 && Build.VERSION.SDK_INT == 21) {
            Size maxJpegSize = this.fetchMaxSize(256);
            outputRatio = new Rational(maxJpegSize.getWidth(), maxJpegSize.getHeight());
            outputRatio = this.rotateAspectRatioByRotation(outputRatio, targetRotation);
        }
        return outputRatio;
    }

    SurfaceSizeDefinition getSurfaceSizeDefinition() {
        return this.mSurfaceSizeDefinition;
    }

    private Size fetchMaxSize(int imageFormat) {
        Size size = this.mMaxSizeCache.get(imageFormat);
        if (size != null) {
            return size;
        }
        Size maxSize = this.getMaxOutputSizeByFormat(imageFormat);
        this.mMaxSizeCache.put(imageFormat, maxSize);
        return maxSize;
    }

    private List<Integer> getUseCasesPriorityOrder(List<UseCase> newUseCases) {
        ArrayList<Integer> priorityOrder = new ArrayList<Integer>();
        ArrayList<Integer> priorityValueList = new ArrayList<Integer>();
        for (UseCase useCase : newUseCases) {
            UseCaseConfig config = useCase.getUseCaseConfig();
            int priority = config.getSurfaceOccupancyPriority(0);
            if (priorityValueList.contains(priority)) continue;
            priorityValueList.add(priority);
        }
        Collections.sort(priorityValueList);
        Collections.reverse(priorityValueList);
        Iterator<Object> iterator = priorityValueList.iterator();
        while (iterator.hasNext()) {
            int priorityValue = (Integer)iterator.next();
            for (UseCase useCase : newUseCases) {
                UseCaseConfig config = useCase.getUseCaseConfig();
                if (priorityValue != config.getSurfaceOccupancyPriority(0)) continue;
                priorityOrder.add(newUseCases.indexOf(useCase));
            }
        }
        return priorityOrder;
    }

    private List<Size> getSupportedOutputSizes(UseCase useCase) {
        int imageFormat = useCase.getImageFormat();
        Size[] outputSizes = this.getAllOutputSizesByFormat(imageFormat, useCase);
        ArrayList<Size> outputSizeCandidates = new ArrayList<Size>();
        ImageOutputConfig config = (ImageOutputConfig)useCase.getUseCaseConfig();
        Size maxSize = config.getMaxResolution(this.getMaxOutputSizeByFormat(imageFormat));
        Arrays.sort(outputSizes, new CompareSizesByArea(true));
        Size targetSize = config.getTargetResolution(ZERO_SIZE);
        Size minSize = DEFAULT_SIZE;
        if (!targetSize.equals((Object)ZERO_SIZE) && this.getArea(targetSize) < this.getArea(DEFAULT_SIZE)) {
            minSize = targetSize;
        }
        for (Size outputSize : outputSizes) {
            if (this.getArea(outputSize) > this.getArea(maxSize) || this.getArea(outputSize) < this.getArea(minSize)) continue;
            outputSizeCandidates.add(outputSize);
        }
        if (outputSizeCandidates.isEmpty()) {
            throw new IllegalArgumentException("Can not get supported output size under supported maximum for the format: " + imageFormat);
        }
        ArrayList<Size> sizesMatchAspectRatio = new ArrayList<Size>();
        ArrayList<Size> sizesNotMatchAspectRatio = new ArrayList<Size>();
        Rational aspectRatio = null;
        if (config.hasTargetAspectRatio()) {
            boolean isSensorLandscapeOrientation = this.isRotationNeeded(0);
            int targetAspectRatio = config.getTargetAspectRatio();
            switch (targetAspectRatio) {
                case 0: {
                    aspectRatio = isSensorLandscapeOrientation ? ASPECT_RATIO_4_3 : ASPECT_RATIO_3_4;
                    break;
                }
                case 1: {
                    aspectRatio = isSensorLandscapeOrientation ? ASPECT_RATIO_16_9 : ASPECT_RATIO_9_16;
                    break;
                }
            }
        } else {
            aspectRatio = config.getTargetAspectRatioCustom(null);
            int targetRotation = config.getTargetRotation(0);
            aspectRatio = this.rotateAspectRatioByRotation(aspectRatio, targetRotation);
        }
        for (Size outputSize : outputSizeCandidates) {
            if (this.hasMatchingAspectRatio(outputSize, aspectRatio)) {
                sizesMatchAspectRatio.add(outputSize);
                continue;
            }
            sizesNotMatchAspectRatio.add(outputSize);
        }
        if (aspectRatio != null) {
            Collections.sort(sizesNotMatchAspectRatio, new CompareSizesByDistanceToTargetRatio(Float.valueOf(aspectRatio.floatValue())));
        }
        boolean isDefaultResolutionSupported = outputSizeCandidates.contains(DEFAULT_SIZE);
        Size size = targetSize = targetSize.equals((Object)ZERO_SIZE) ? config.getDefaultResolution(ZERO_SIZE) : targetSize;
        if (!targetSize.equals((Object)ZERO_SIZE)) {
            this.removeSupportedSizesByTargetSize(sizesMatchAspectRatio, targetSize);
            this.removeSupportedSizesByTargetSize(sizesNotMatchAspectRatio, targetSize);
        }
        if (sizesMatchAspectRatio.isEmpty() && sizesNotMatchAspectRatio.isEmpty() && !isDefaultResolutionSupported) {
            throw new IllegalArgumentException("Can not get supported output size for the desired output size quality for the format: " + imageFormat);
        }
        ArrayList<Size> supportedResolutions = new ArrayList<Size>();
        supportedResolutions.addAll(sizesMatchAspectRatio);
        supportedResolutions.addAll(sizesNotMatchAspectRatio);
        if (supportedResolutions.isEmpty() && !isDefaultResolutionSupported) {
            supportedResolutions.add(DEFAULT_SIZE);
        }
        return supportedResolutions;
    }

    private Rational rotateAspectRatioByRotation(Rational aspectRatio, int targetRotation) {
        Rational outputRatio = aspectRatio;
        if (aspectRatio != null && this.isRotationNeeded(targetRotation)) {
            outputRatio = new Rational(aspectRatio.getDenominator(), aspectRatio.getNumerator());
        }
        return outputRatio;
    }

    private boolean isRotationNeeded(int targetRotation) {
        int sensorRotationDegrees = CameraX.getCameraInfo((String)this.mCameraId).getSensorRotationDegrees(targetRotation);
        return sensorRotationDegrees == 90 || sensorRotationDegrees == 270;
    }

    private boolean hasMatchingAspectRatio(Size resolution, Rational aspectRatio) {
        boolean isMatch = aspectRatio == null ? false : (aspectRatio.equals((Object)new Rational(resolution.getWidth(), resolution.getHeight())) ? true : this.isPossibleMod16FromAspectRatio(resolution, aspectRatio));
        return isMatch;
    }

    private boolean isPossibleMod16FromAspectRatio(Size resolution, Rational aspectRatio) {
        int width = resolution.getWidth();
        int height = resolution.getHeight();
        Rational invAspectRatio = new Rational(aspectRatio.getDenominator(), aspectRatio.getNumerator());
        if (width % 16 == 0 && height % 16 == 0) {
            return this.ratioIntersectsMod16Segment(Math.max(0, height - 16), width, aspectRatio) || this.ratioIntersectsMod16Segment(Math.max(0, width - 16), height, invAspectRatio);
        }
        if (width % 16 == 0) {
            return this.ratioIntersectsMod16Segment(height, width, aspectRatio);
        }
        if (height % 16 == 0) {
            return this.ratioIntersectsMod16Segment(width, height, invAspectRatio);
        }
        return false;
    }

    private int getArea(Size size) {
        return size.getWidth() * size.getHeight();
    }

    private boolean ratioIntersectsMod16Segment(int height, int mod16Width, Rational aspectRatio) {
        Preconditions.checkArgument((mod16Width % 16 == 0 ? 1 : 0) != 0);
        double aspectRatioWidth = (double)(height * aspectRatio.getNumerator()) / (double)aspectRatio.getDenominator();
        return aspectRatioWidth > (double)Math.max(0, mod16Width - 16) && aspectRatioWidth < (double)(mod16Width + 16);
    }

    private void removeSupportedSizesByTargetSize(List<Size> supportedSizesList, Size targetSize) {
        if (supportedSizesList != null && supportedSizesList.size() != 0) {
            Size outputSize;
            int indexBigEnough = 0;
            int i = 0;
            while (i < supportedSizesList.size() && this.getArea(outputSize = supportedSizesList.get(i)) >= this.getArea(targetSize)) {
                indexBigEnough = i++;
            }
            Size bigEnoughSize = supportedSizesList.get(indexBigEnough);
            ArrayList<Size> removeSizes = new ArrayList<Size>();
            for (Size size : supportedSizesList) {
                if (this.getArea(size) <= this.getArea(bigEnoughSize)) continue;
                removeSizes.add(size);
            }
            supportedSizesList.removeAll(removeSizes);
        }
    }

    private List<List<Size>> getAllPossibleSizeArrangements(List<List<Size>> supportedOutputSizesList) {
        int totalArrangementsCount = 1;
        for (List<Size> supportedOutputSizes : supportedOutputSizesList) {
            totalArrangementsCount *= supportedOutputSizes.size();
        }
        if (totalArrangementsCount == 0) {
            throw new IllegalArgumentException("Failed to find supported resolutions.");
        }
        ArrayList<List<Size>> allPossibleSizeArrangements = new ArrayList<List<Size>>();
        for (int i = 0; i < totalArrangementsCount; ++i) {
            ArrayList sizeList = new ArrayList();
            allPossibleSizeArrangements.add(sizeList);
        }
        int currentRunCount = totalArrangementsCount;
        int nextRunCount = currentRunCount / supportedOutputSizesList.get(0).size();
        for (int currentIndex = 0; currentIndex < supportedOutputSizesList.size(); ++currentIndex) {
            List<Size> supportedOutputSizes = supportedOutputSizesList.get(currentIndex);
            for (int i = 0; i < totalArrangementsCount; ++i) {
                List surfaceConfigList = (List)allPossibleSizeArrangements.get(i);
                surfaceConfigList.add(supportedOutputSizes.get(i % currentRunCount / nextRunCount));
            }
            if (currentIndex >= supportedOutputSizesList.size() - 1) continue;
            currentRunCount = nextRunCount;
            nextRunCount = currentRunCount / supportedOutputSizesList.get(currentIndex + 1).size();
        }
        return allPossibleSizeArrangements;
    }

    @Nullable
    private Size[] getAllOutputSizesByFormat(int imageFormat) {
        return this.getAllOutputSizesByFormat(imageFormat, null);
    }

    @Nullable
    private Size[] getAllOutputSizesByFormat(int imageFormat, @Nullable UseCase useCase) {
        Size[] outputSizes = null;
        List formatResolutionsPairList = null;
        if (useCase != null) {
            ImageOutputConfig imageOutputConfig = (ImageOutputConfig)useCase.getUseCaseConfig();
            formatResolutionsPairList = imageOutputConfig.getSupportedResolutions(null);
        }
        if (formatResolutionsPairList != null) {
            for (Pair formatResolutionPair : formatResolutionsPairList) {
                if ((Integer)formatResolutionPair.first != imageFormat) continue;
                outputSizes = (Size[])formatResolutionPair.second;
                break;
            }
        }
        if (outputSizes == null) {
            if (this.mCharacteristics == null) {
                throw new IllegalStateException("CameraCharacteristics is null.");
            }
            StreamConfigurationMap map = (StreamConfigurationMap)this.mCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (map == null) {
                throw new IllegalArgumentException("Can not get supported output size for the format: " + imageFormat);
            }
            outputSizes = Build.VERSION.SDK_INT < 23 && imageFormat == 34 ? map.getOutputSizes(SurfaceTexture.class) : map.getOutputSizes(imageFormat);
        }
        if (outputSizes == null) {
            throw new IllegalArgumentException("Can not get supported output size for the format: " + imageFormat);
        }
        Arrays.sort(outputSizes, new CompareSizesByArea(true));
        return outputSizes;
    }

    Size getMaxOutputSizeByFormat(int imageFormat) {
        Size[] outputSizes = this.getAllOutputSizesByFormat(imageFormat);
        return Collections.max(Arrays.asList(outputSizes), new CompareSizesByArea());
    }

    private void init(Context context) {
        CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        try {
            this.generateSupportedCombinationList(cameraManager);
            this.generateSurfaceSizeDefinition(windowManager);
        }
        catch (CameraAccessException e) {
            throw new IllegalArgumentException("Generate supported combination list and size definition fail - CameraId:" + this.mCameraId, e);
        }
        this.checkCustomization();
    }

    List<SurfaceCombination> getLegacySupportedCombinationList() {
        ArrayList<SurfaceCombination> combinationList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination1 = new SurfaceCombination();
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination1);
        SurfaceCombination surfaceCombination2 = new SurfaceCombination();
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination2);
        SurfaceCombination surfaceCombination3 = new SurfaceCombination();
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination3);
        SurfaceCombination surfaceCombination4 = new SurfaceCombination();
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination4);
        SurfaceCombination surfaceCombination5 = new SurfaceCombination();
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination5);
        SurfaceCombination surfaceCombination6 = new SurfaceCombination();
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        combinationList.add(surfaceCombination6);
        SurfaceCombination surfaceCombination7 = new SurfaceCombination();
        surfaceCombination7.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination7.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        combinationList.add(surfaceCombination7);
        SurfaceCombination surfaceCombination8 = new SurfaceCombination();
        surfaceCombination8.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination8.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination8.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination8);
        return combinationList;
    }

    List<SurfaceCombination> getLimitedSupportedCombinationList() {
        ArrayList<SurfaceCombination> combinationList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination1 = new SurfaceCombination();
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.RECORD));
        combinationList.add(surfaceCombination1);
        SurfaceCombination surfaceCombination2 = new SurfaceCombination();
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.RECORD));
        combinationList.add(surfaceCombination2);
        SurfaceCombination surfaceCombination3 = new SurfaceCombination();
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.RECORD));
        combinationList.add(surfaceCombination3);
        SurfaceCombination surfaceCombination4 = new SurfaceCombination();
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.RECORD));
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.RECORD));
        combinationList.add(surfaceCombination4);
        SurfaceCombination surfaceCombination5 = new SurfaceCombination();
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.RECORD));
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.RECORD));
        combinationList.add(surfaceCombination5);
        SurfaceCombination surfaceCombination6 = new SurfaceCombination();
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination6);
        return combinationList;
    }

    List<SurfaceCombination> getFullSupportedCombinationList() {
        ArrayList<SurfaceCombination> combinationList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination1 = new SurfaceCombination();
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination1);
        SurfaceCombination surfaceCombination2 = new SurfaceCombination();
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination2);
        SurfaceCombination surfaceCombination3 = new SurfaceCombination();
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination3);
        SurfaceCombination surfaceCombination4 = new SurfaceCombination();
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination4);
        SurfaceCombination surfaceCombination5 = new SurfaceCombination();
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.ANALYSIS));
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination5);
        SurfaceCombination surfaceCombination6 = new SurfaceCombination();
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.ANALYSIS));
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination6);
        return combinationList;
    }

    List<SurfaceCombination> getRAWSupportedCombinationList() {
        ArrayList<SurfaceCombination> combinationList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination1 = new SurfaceCombination();
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination1);
        SurfaceCombination surfaceCombination2 = new SurfaceCombination();
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination2);
        SurfaceCombination surfaceCombination3 = new SurfaceCombination();
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination3);
        SurfaceCombination surfaceCombination4 = new SurfaceCombination();
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination4.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination4);
        SurfaceCombination surfaceCombination5 = new SurfaceCombination();
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination5.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination5);
        SurfaceCombination surfaceCombination6 = new SurfaceCombination();
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination6.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination6);
        SurfaceCombination surfaceCombination7 = new SurfaceCombination();
        surfaceCombination7.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination7.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        surfaceCombination7.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination7);
        SurfaceCombination surfaceCombination8 = new SurfaceCombination();
        surfaceCombination8.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination8.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        surfaceCombination8.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination8);
        return combinationList;
    }

    List<SurfaceCombination> getBurstSupportedCombinationList() {
        ArrayList<SurfaceCombination> combinationList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination1 = new SurfaceCombination();
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination1);
        SurfaceCombination surfaceCombination2 = new SurfaceCombination();
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination2);
        SurfaceCombination surfaceCombination3 = new SurfaceCombination();
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination3);
        return combinationList;
    }

    List<SurfaceCombination> getLevel3SupportedCombinationList() {
        ArrayList<SurfaceCombination> combinationList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination1 = new SurfaceCombination();
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.ANALYSIS));
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        surfaceCombination1.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination1);
        SurfaceCombination surfaceCombination2 = new SurfaceCombination();
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.ANALYSIS));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        combinationList.add(surfaceCombination2);
        return combinationList;
    }

    private void generateSupportedCombinationList(CameraManager cameraManager) throws CameraAccessException {
        int[] availableCapabilities;
        this.mCharacteristics = cameraManager.getCameraCharacteristics(this.mCameraId);
        Integer keyValue = (Integer)this.mCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        if (keyValue != null) {
            this.mHardwareLevel = keyValue;
        }
        this.mSurfaceCombinations.addAll(this.getLegacySupportedCombinationList());
        if (this.mHardwareLevel == 0 || this.mHardwareLevel == 1 || this.mHardwareLevel == 3) {
            this.mSurfaceCombinations.addAll(this.getLimitedSupportedCombinationList());
        }
        if (this.mHardwareLevel == 1 || this.mHardwareLevel == 3) {
            this.mSurfaceCombinations.addAll(this.getFullSupportedCombinationList());
        }
        if ((availableCapabilities = (int[])this.mCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES)) != null) {
            for (int capability : availableCapabilities) {
                if (capability == 3) {
                    this.mIsRawSupported = true;
                    continue;
                }
                if (capability != 6) continue;
                this.mIsBurstCaptureSupported = true;
            }
        }
        if (this.mIsRawSupported) {
            this.mSurfaceCombinations.addAll(this.getRAWSupportedCombinationList());
        }
        if (this.mIsBurstCaptureSupported && this.mHardwareLevel == 0) {
            this.mSurfaceCombinations.addAll(this.getBurstSupportedCombinationList());
        }
        if (this.mHardwareLevel == 3) {
            this.mSurfaceCombinations.addAll(this.getLevel3SupportedCombinationList());
        }
    }

    private void checkCustomization() {
    }

    private void generateSurfaceSizeDefinition(WindowManager windowManager) {
        Size analysisSize = new Size(640, 480);
        Size previewSize = this.getPreviewSize(windowManager);
        Size recordSize = this.getRecordSize();
        this.mSurfaceSizeDefinition = SurfaceSizeDefinition.create((Size)analysisSize, (Size)previewSize, (Size)recordSize);
    }

    private Size getPreviewSize(WindowManager windowManager) {
        Point displaySize = new Point();
        windowManager.getDefaultDisplay().getRealSize(displaySize);
        Size displayViewSize = displaySize.x > displaySize.y ? new Size(displaySize.x, displaySize.y) : new Size(displaySize.y, displaySize.x);
        Size previewSize = Collections.min(Arrays.asList(new Size(displayViewSize.getWidth(), displayViewSize.getHeight()), MAX_PREVIEW_SIZE), new CompareSizesByArea());
        return previewSize;
    }

    private Size getRecordSize() {
        Size recordSize = QUALITY_480P_SIZE;
        if (this.mCamcorderProfileHelper.hasProfile(Integer.parseInt(this.mCameraId), 8)) {
            recordSize = QUALITY_2160P_SIZE;
        } else if (this.mCamcorderProfileHelper.hasProfile(Integer.parseInt(this.mCameraId), 6)) {
            recordSize = QUALITY_1080P_SIZE;
        } else if (this.mCamcorderProfileHelper.hasProfile(Integer.parseInt(this.mCameraId), 5)) {
            recordSize = QUALITY_720P_SIZE;
        } else if (this.mCamcorderProfileHelper.hasProfile(Integer.parseInt(this.mCameraId), 4)) {
            recordSize = QUALITY_480P_SIZE;
        }
        return recordSize;
    }

    static final class CompareSizesByDistanceToTargetRatio
    implements Comparator<Size> {
        private Float mTargetRatio;

        CompareSizesByDistanceToTargetRatio(Float targetRatio) {
            this.mTargetRatio = targetRatio;
        }

        @Override
        public int compare(Size lhs, Size rhs) {
            Float lhsRatio = Float.valueOf((float)lhs.getWidth() * 1.0f / (float)lhs.getHeight());
            Float rhsRatio = Float.valueOf((float)rhs.getWidth() * 1.0f / (float)rhs.getHeight());
            Float lhsRatioDelta = Float.valueOf(Math.abs(lhsRatio.floatValue() - this.mTargetRatio.floatValue()));
            Float rhsRatioDelta = Float.valueOf(Math.abs(rhsRatio.floatValue() - this.mTargetRatio.floatValue()));
            int result = (int)Math.signum(lhsRatioDelta.floatValue() - rhsRatioDelta.floatValue());
            return result;
        }
    }

    static final class CompareSizesByArea
    implements Comparator<Size> {
        private boolean mReverse = false;

        CompareSizesByArea() {
        }

        CompareSizesByArea(boolean reverse) {
            this.mReverse = reverse;
        }

        @Override
        public int compare(Size lhs, Size rhs) {
            int result = Long.signum((long)lhs.getWidth() * (long)lhs.getHeight() - (long)rhs.getWidth() * (long)rhs.getHeight());
            if (this.mReverse) {
                result *= -1;
            }
            return result;
        }
    }
}

