/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.content.Context;
import android.util.Log;
import android.util.Rational;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.Camera2SessionOptionUnpacker;
import androidx.camera.camera2.internal.ImageCaptureOptionUnpacker;
import androidx.camera.core.CameraX;
import androidx.camera.core.CaptureConfig;
import androidx.camera.core.ConfigProvider;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureConfig;
import androidx.camera.core.SessionConfig;

public final class ImageCaptureConfigProvider
implements ConfigProvider<ImageCaptureConfig> {
    private static final String TAG = "ImageCaptureProvider";
    private static final Rational DEFAULT_ASPECT_RATIO_4_3 = new Rational(4, 3);
    private static final Rational DEFAULT_ASPECT_RATIO_3_4 = new Rational(3, 4);
    private final WindowManager mWindowManager;

    public ImageCaptureConfigProvider(@NonNull Context context) {
        this.mWindowManager = (WindowManager)context.getSystemService("window");
    }

    @NonNull
    public ImageCaptureConfig getConfig(@Nullable Integer lensFacing) {
        ImageCapture.Builder builder = ImageCapture.Builder.fromConfig((ImageCaptureConfig)ImageCapture.DEFAULT_CONFIG.getConfig(lensFacing));
        SessionConfig.Builder sessionBuilder = new SessionConfig.Builder();
        sessionBuilder.setTemplateType(1);
        builder.setDefaultSessionConfig(sessionBuilder.build());
        builder.setSessionOptionUnpacker((SessionConfig.OptionUnpacker)Camera2SessionOptionUnpacker.INSTANCE);
        CaptureConfig.Builder captureConfig = new CaptureConfig.Builder();
        captureConfig.setTemplateType(2);
        builder.setDefaultCaptureConfig(captureConfig.build());
        builder.setCaptureOptionUnpacker((CaptureConfig.OptionUnpacker)ImageCaptureOptionUnpacker.INSTANCE);
        try {
            int checkedLensFacing = lensFacing != null ? lensFacing : CameraX.getDefaultLensFacing();
            String defaultId = CameraX.getCameraWithLensFacing((int)checkedLensFacing);
            if (defaultId != null) {
                builder.setLensFacing(checkedLensFacing);
            }
            int targetRotation = this.mWindowManager.getDefaultDisplay().getRotation();
            int rotationDegrees = CameraX.getCameraInfo((String)defaultId).getSensorRotationDegrees(targetRotation);
            boolean isRotateNeeded = rotationDegrees == 90 || rotationDegrees == 270;
            builder.setTargetRotation(targetRotation);
            builder.setTargetAspectRatioCustom(isRotateNeeded ? DEFAULT_ASPECT_RATIO_3_4 : DEFAULT_ASPECT_RATIO_4_3);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Unable to determine default lens facing for ImageCapture.", (Throwable)e);
        }
        return builder.getUseCaseConfig();
    }
}

