/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.graphics.PointF;
import android.graphics.Rect;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.os.Build;
import android.util.Rational;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.Camera2CameraControl;
import androidx.camera.core.CameraControl;
import androidx.camera.core.CaptureConfig;
import androidx.camera.core.Config;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.FocusMeteringResult;
import androidx.camera.core.MeteringPoint;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class FocusMeteringControl {
    private static final String TAG = "FocusMeteringControl";
    private final Camera2CameraControl mCameraControl;
    final Executor mExecutor;
    private final ScheduledExecutorService mScheduler;
    private volatile boolean mIsActive = false;
    private FocusMeteringAction mCurrentFocusMeteringAction;
    private boolean mIsInAfAutoMode = false;
    Integer mCurrentAfState = 0;
    private ScheduledFuture<?> mAutoCancelHandle;
    long mFocusTimeoutCounter = 0L;
    private Camera2CameraControl.CaptureResultListener mSessionListenerForFocus = null;
    private MeteringRectangle[] mAfRects = new MeteringRectangle[0];
    private MeteringRectangle[] mAeRects = new MeteringRectangle[0];
    private MeteringRectangle[] mAwbRects = new MeteringRectangle[0];

    FocusMeteringControl(@NonNull Camera2CameraControl cameraControl, @NonNull ScheduledExecutorService scheduler, @NonNull Executor executor) {
        this.mCameraControl = cameraControl;
        this.mExecutor = executor;
        this.mScheduler = scheduler;
    }

    void setActive(boolean isActive) {
        if (isActive == this.mIsActive) {
            return;
        }
        this.mIsActive = isActive;
        if (!this.mIsActive) {
            this.mExecutor.execute(() -> this.cancelFocusAndMetering());
        }
    }

    @WorkerThread
    void addFocusMeteringOptions(@NonNull Camera2ImplConfig.Builder configBuilder) {
        int afMode = this.mIsInAfAutoMode ? 1 : 4;
        configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AF_MODE, this.mCameraControl.getSupportedAfMode(afMode));
        if (this.mAfRects.length != 0) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AF_REGIONS, this.mAfRects);
        }
        if (this.mAeRects.length != 0) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_REGIONS, this.mAeRects);
        }
        if (this.mAwbRects.length != 0) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AWB_REGIONS, this.mAwbRects);
        }
    }

    @WorkerThread
    private PointF getFovAdjustedPoint(@NonNull MeteringPoint meteringPoint, @NonNull Rational cropRegionAspectRatio, @NonNull Rational defaultAspectRatio) {
        Rational fovAspectRatio = defaultAspectRatio;
        if (meteringPoint.getSurfaceAspectRatio() != null) {
            fovAspectRatio = meteringPoint.getSurfaceAspectRatio();
        }
        PointF adjustedPoint = new PointF(meteringPoint.getX(), meteringPoint.getY());
        if (!fovAspectRatio.equals((Object)cropRegionAspectRatio)) {
            if (fovAspectRatio.compareTo(cropRegionAspectRatio) > 0) {
                float heightOfCropRegion = (float)(fovAspectRatio.doubleValue() / cropRegionAspectRatio.doubleValue());
                float top_padding = (float)(((double)heightOfCropRegion - 1.0) / 2.0);
                adjustedPoint.y = (top_padding + adjustedPoint.y) * (1.0f / heightOfCropRegion);
            } else {
                float widthOfCropRegion = (float)(cropRegionAspectRatio.doubleValue() / fovAspectRatio.doubleValue());
                float left_padding = (float)(((double)widthOfCropRegion - 1.0) / 2.0);
                adjustedPoint.x = (left_padding + adjustedPoint.x) * (1.0f / widthOfCropRegion);
            }
        }
        return adjustedPoint;
    }

    @WorkerThread
    private MeteringRectangle getMeteringRect(MeteringPoint meteringPoint, PointF adjustedPoint, Rect cropRegion) {
        int centerX = (int)((float)cropRegion.left + adjustedPoint.x * (float)cropRegion.width());
        int centerY = (int)((float)cropRegion.top + adjustedPoint.y * (float)cropRegion.height());
        int width = (int)(meteringPoint.getSize() * (float)cropRegion.width());
        int height = (int)(meteringPoint.getSize() * (float)cropRegion.height());
        Rect focusRect = new Rect(centerX - width / 2, centerY - height / 2, centerX + width / 2, centerY + height / 2);
        focusRect.left = this.rangeLimit(focusRect.left, cropRegion.right, cropRegion.left);
        focusRect.right = this.rangeLimit(focusRect.right, cropRegion.right, cropRegion.left);
        focusRect.top = this.rangeLimit(focusRect.top, cropRegion.bottom, cropRegion.top);
        focusRect.bottom = this.rangeLimit(focusRect.bottom, cropRegion.bottom, cropRegion.top);
        return new MeteringRectangle(focusRect, 1000);
    }

    @WorkerThread
    private int rangeLimit(int val, int max, int min) {
        return Math.min(Math.max(val, min), max);
    }

    ListenableFuture<FocusMeteringResult> startFocusAndMetering(@NonNull FocusMeteringAction action, @Nullable Rational defaultAspectRatio) {
        return CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> this.startFocusAndMeteringInternal((CallbackToFutureAdapter.Completer<FocusMeteringResult>)completer, action, defaultAspectRatio));
            return "startFocusAndMetering";
        });
    }

    @WorkerThread
    void startFocusAndMeteringInternal(@NonNull CallbackToFutureAdapter.Completer<FocusMeteringResult> completer, @NonNull FocusMeteringAction action, @Nullable Rational defaultAspectRatio) {
        MeteringRectangle meteringRectangle;
        PointF adjustedPoint;
        if (!this.mIsActive) {
            completer.setException((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
            return;
        }
        if (action.getMeteringPointsAf().isEmpty() && action.getMeteringPointsAe().isEmpty() && action.getMeteringPointsAwb().isEmpty()) {
            completer.setException((Throwable)new IllegalArgumentException("No AF/AE/AWB MeteringPoints are added."));
            return;
        }
        if (this.mCurrentFocusMeteringAction != null) {
            this.cancelFocusAndMetering();
        }
        this.mCurrentFocusMeteringAction = action;
        Rect cropSensorRegion = this.mCameraControl.getCropSensorRegion();
        Rational cropRegionAspectRatio = new Rational(cropSensorRegion.width(), cropSensorRegion.height());
        if (defaultAspectRatio == null) {
            defaultAspectRatio = cropRegionAspectRatio;
        }
        ArrayList<MeteringRectangle> meteringRectanglesListAF = new ArrayList<MeteringRectangle>();
        ArrayList<MeteringRectangle> meteringRectanglesListAE = new ArrayList<MeteringRectangle>();
        ArrayList<MeteringRectangle> meteringRectanglesListAWB = new ArrayList<MeteringRectangle>();
        for (MeteringPoint meteringPoint : action.getMeteringPointsAf()) {
            adjustedPoint = this.getFovAdjustedPoint(meteringPoint, cropRegionAspectRatio, defaultAspectRatio);
            meteringRectangle = this.getMeteringRect(meteringPoint, adjustedPoint, cropSensorRegion);
            meteringRectanglesListAF.add(meteringRectangle);
        }
        for (MeteringPoint meteringPoint : action.getMeteringPointsAe()) {
            adjustedPoint = this.getFovAdjustedPoint(meteringPoint, cropRegionAspectRatio, defaultAspectRatio);
            meteringRectangle = this.getMeteringRect(meteringPoint, adjustedPoint, cropSensorRegion);
            meteringRectanglesListAE.add(meteringRectangle);
        }
        for (MeteringPoint meteringPoint : action.getMeteringPointsAwb()) {
            adjustedPoint = this.getFovAdjustedPoint(meteringPoint, cropRegionAspectRatio, defaultAspectRatio);
            meteringRectangle = this.getMeteringRect(meteringPoint, adjustedPoint, cropSensorRegion);
            meteringRectanglesListAWB.add(meteringRectangle);
        }
        this.executeMeteringAction(completer, meteringRectanglesListAF.toArray(new MeteringRectangle[0]), meteringRectanglesListAE.toArray(new MeteringRectangle[0]), meteringRectanglesListAWB.toArray(new MeteringRectangle[0]), action);
    }

    @WorkerThread
    private int getDefaultTemplate() {
        return 1;
    }

    @WorkerThread
    void triggerAf() {
        if (!this.mIsActive) {
            return;
        }
        CaptureConfig.Builder builder = new CaptureConfig.Builder();
        builder.setTemplateType(this.getDefaultTemplate());
        builder.setUseRepeatingSurface(true);
        Camera2ImplConfig.Builder configBuilder = new Camera2ImplConfig.Builder();
        configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AF_TRIGGER, 1);
        builder.addImplementationOptions((Config)configBuilder.build());
        this.mCameraControl.submitCaptureRequestsInternal(Collections.singletonList(builder.build()));
    }

    @WorkerThread
    void triggerAePrecapture() {
        if (!this.mIsActive) {
            return;
        }
        CaptureConfig.Builder builder = new CaptureConfig.Builder();
        builder.setTemplateType(this.getDefaultTemplate());
        builder.setUseRepeatingSurface(true);
        Camera2ImplConfig.Builder configBuilder = new Camera2ImplConfig.Builder();
        configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, 1);
        builder.addImplementationOptions((Config)configBuilder.build());
        this.mCameraControl.submitCaptureRequestsInternal(Collections.singletonList(builder.build()));
    }

    @WorkerThread
    void cancelAfAeTrigger(boolean cancelAfTrigger, boolean cancelAePrecaptureTrigger) {
        if (!this.mIsActive) {
            return;
        }
        CaptureConfig.Builder builder = new CaptureConfig.Builder();
        builder.setUseRepeatingSurface(true);
        builder.setTemplateType(this.getDefaultTemplate());
        Camera2ImplConfig.Builder configBuilder = new Camera2ImplConfig.Builder();
        if (cancelAfTrigger) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AF_TRIGGER, 2);
        }
        if (Build.VERSION.SDK_INT >= 23 && cancelAePrecaptureTrigger) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, 2);
        }
        builder.addImplementationOptions((Config)configBuilder.build());
        this.mCameraControl.submitCaptureRequestsInternal(Collections.singletonList(builder.build()));
    }

    @WorkerThread
    private void disableAutoCancel() {
        if (this.mAutoCancelHandle != null) {
            this.mAutoCancelHandle.cancel(true);
            this.mAutoCancelHandle = null;
        }
    }

    @WorkerThread
    private void executeMeteringAction(@NonNull CallbackToFutureAdapter.Completer<FocusMeteringResult> completer, @Nullable MeteringRectangle[] afRects, @Nullable MeteringRectangle[] aeRects, @Nullable MeteringRectangle[] awbRects, FocusMeteringAction focusMeteringAction) {
        this.mCameraControl.removeCaptureResultListener(this.mSessionListenerForFocus);
        this.disableAutoCancel();
        this.mAfRects = afRects == null ? new MeteringRectangle[0] : afRects;
        this.mAeRects = aeRects == null ? new MeteringRectangle[0] : aeRects;
        this.mAwbRects = awbRects == null ? new MeteringRectangle[0] : awbRects;
        if (this.shouldTriggerAF()) {
            this.mCurrentAfState = 0;
            this.mSessionListenerForFocus = result -> {
                Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
                if (afState == null) {
                    return false;
                }
                if (this.mCurrentAfState == 3) {
                    if (afState == 4) {
                        completer.set((Object)FocusMeteringResult.create((boolean)true));
                        return true;
                    }
                    if (afState == 5) {
                        completer.set((Object)FocusMeteringResult.create((boolean)false));
                        return true;
                    }
                }
                if (!this.mCurrentAfState.equals(afState)) {
                    this.mCurrentAfState = afState;
                }
                return false;
            };
            this.mCameraControl.addCaptureResultListener(this.mSessionListenerForFocus);
            this.mIsInAfAutoMode = true;
            this.mCameraControl.updateSessionConfig();
            this.triggerAf();
        } else {
            completer.set((Object)FocusMeteringResult.create((boolean)false));
            this.mCameraControl.updateSessionConfig();
        }
        if (focusMeteringAction.isAutoCancelEnabled()) {
            long timeoutId = ++this.mFocusTimeoutCounter;
            Runnable autoCancelRunnable = () -> this.mExecutor.execute(() -> {
                if (timeoutId == this.mFocusTimeoutCounter) {
                    this.cancelFocusAndMetering();
                }
            });
            this.mAutoCancelHandle = this.mScheduler.schedule(autoCancelRunnable, focusMeteringAction.getAutoCancelDurationInMillis(), TimeUnit.MILLISECONDS);
        }
    }

    @WorkerThread
    private boolean shouldTriggerAF() {
        return this.mAfRects.length > 0;
    }

    @WorkerThread
    void cancelFocusAndMetering() {
        this.mCameraControl.removeCaptureResultListener(this.mSessionListenerForFocus);
        this.disableAutoCancel();
        if (this.shouldTriggerAF()) {
            this.cancelAfAeTrigger(true, false);
        }
        this.mAfRects = new MeteringRectangle[0];
        this.mAeRects = new MeteringRectangle[0];
        this.mAwbRects = new MeteringRectangle[0];
        this.mIsInAfAutoMode = false;
        this.mCameraControl.updateSessionConfig();
        this.mCurrentFocusMeteringAction = null;
    }
}

