/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CaptureRequest;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.Camera2CaptureCallbacks;
import androidx.camera.camera2.internal.CaptureCallbackContainer;
import androidx.camera.core.CaptureConfig;
import androidx.camera.core.Config;
import androidx.camera.core.OptionsBundle;
import androidx.camera.core.UseCaseConfig;
import androidx.camera.core.impl.CameraCaptureCallback;
import java.util.Collection;
import java.util.Iterator;

class Camera2CaptureOptionUnpacker
implements CaptureConfig.OptionUnpacker {
    static final Camera2CaptureOptionUnpacker INSTANCE = new Camera2CaptureOptionUnpacker();

    Camera2CaptureOptionUnpacker() {
    }

    public void unpack(UseCaseConfig<?> config, CaptureConfig.Builder builder) {
        CaptureConfig defaultCaptureConfig = config.getDefaultCaptureConfig(null);
        OptionsBundle implOptions = OptionsBundle.emptyBundle();
        int templateType = CaptureConfig.defaultEmptyCaptureConfig().getTemplateType();
        if (defaultCaptureConfig != null) {
            templateType = defaultCaptureConfig.getTemplateType();
            builder.addAllCameraCaptureCallbacks((Collection)defaultCaptureConfig.getCameraCaptureCallbacks());
            implOptions = defaultCaptureConfig.getImplementationOptions();
        }
        builder.setImplementationOptions((Config)implOptions);
        Camera2ImplConfig camera2Config = new Camera2ImplConfig((Config)config);
        builder.setTemplateType(camera2Config.getCaptureRequestTemplate(templateType));
        builder.addCameraCaptureCallback((CameraCaptureCallback)CaptureCallbackContainer.create(camera2Config.getSessionCaptureCallback(Camera2CaptureCallbacks.createNoOpCallback())));
        Camera2ImplConfig.Builder configBuilder = new Camera2ImplConfig.Builder();
        Iterator<Config.Option<?>> iterator = camera2Config.getCaptureRequestOptions().iterator();
        while (iterator.hasNext()) {
            Config.Option<?> option;
            Config.Option<?> typeErasedOption = option = iterator.next();
            CaptureRequest.Key key = (CaptureRequest.Key)option.getToken();
            configBuilder.setCaptureRequestOption(key, camera2Config.retrieveOption(typeErasedOption));
        }
        builder.addImplementationOptions((Config)configBuilder.build());
    }
}

