/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.Camera2CameraImpl;
import androidx.camera.camera2.internal.Camera2LensFacingCameraIdFilter;
import androidx.camera.camera2.internal.CameraAvailabilityRegistry;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.core.CameraFactory;
import androidx.camera.core.CameraInfoUnavailableException;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.LensFacingCameraIdFilter;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class Camera2CameraFactory
implements CameraFactory {
    private static final int DEFAULT_ALLOWED_CONCURRENT_OPEN_CAMERAS = 1;
    private static final HandlerThread sHandlerThread = new HandlerThread("CameraX-");
    private static final Handler sHandler;
    private final CameraAvailabilityRegistry mAvailabilityRegistry = new CameraAvailabilityRegistry(1, CameraXExecutors.newHandlerExecutor((Handler)sHandler));
    private final CameraManagerCompat mCameraManager;

    public Camera2CameraFactory(@NonNull Context context) {
        this.mCameraManager = CameraManagerCompat.from(context);
    }

    @NonNull
    public CameraInternal getCamera(@NonNull String cameraId) throws CameraInfoUnavailableException {
        if (!this.getAvailableCameraIds().contains(cameraId)) {
            throw new IllegalArgumentException("The given camera id is not on the available camera id list.");
        }
        Camera2CameraImpl camera2CameraImpl = new Camera2CameraImpl(this.mCameraManager, cameraId, this.mAvailabilityRegistry.getAvailableCameraCount(), sHandler);
        this.mAvailabilityRegistry.registerCamera(camera2CameraImpl);
        return camera2CameraImpl;
    }

    @NonNull
    public Set<String> getAvailableCameraIds() throws CameraInfoUnavailableException {
        List<String> camerasList;
        try {
            camerasList = Arrays.asList(this.mCameraManager.unwrap().getCameraIdList());
        }
        catch (CameraAccessException e) {
            throw new CameraInfoUnavailableException("Unable to retrieve list of cameras on device.", (Throwable)e);
        }
        return new LinkedHashSet<String>(camerasList);
    }

    @Nullable
    public String cameraIdForLensFacing(int lensFacing) throws CameraInfoUnavailableException {
        Set availableCameraIds = this.getLensFacingCameraIdFilter(lensFacing).filter(this.getAvailableCameraIds());
        if (!availableCameraIds.isEmpty()) {
            return (String)availableCameraIds.iterator().next();
        }
        return null;
    }

    @NonNull
    public LensFacingCameraIdFilter getLensFacingCameraIdFilter(int lensFacing) {
        return new Camera2LensFacingCameraIdFilter(lensFacing, this.mCameraManager.unwrap());
    }

    static {
        sHandlerThread.start();
        sHandler = new Handler(sHandlerThread.getLooper());
    }
}

