/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2;

import androidx.annotation.NonNull;
import androidx.camera.camera2.internal.Camera2CameraFactory;
import androidx.camera.camera2.internal.Camera2DeviceSurfaceManager;
import androidx.camera.camera2.internal.ImageAnalysisConfigProvider;
import androidx.camera.camera2.internal.ImageCaptureConfigProvider;
import androidx.camera.camera2.internal.PreviewConfigProvider;
import androidx.camera.camera2.internal.VideoCaptureConfigProvider;
import androidx.camera.core.CameraFactory;
import androidx.camera.core.CameraXConfig;
import androidx.camera.core.ConfigProvider;
import androidx.camera.core.ExtendableUseCaseConfigFactory;
import androidx.camera.core.ImageAnalysisConfig;
import androidx.camera.core.ImageCaptureConfig;
import androidx.camera.core.PreviewConfig;
import androidx.camera.core.UseCaseConfigFactory;
import androidx.camera.core.VideoCaptureConfig;
import androidx.camera.core.impl.CameraDeviceSurfaceManager;

public final class Camera2Config {
    private Camera2Config() {
    }

    @NonNull
    public static CameraXConfig defaultConfig() {
        CameraFactory.Provider cameraFactoryProvider = Camera2CameraFactory::new;
        CameraDeviceSurfaceManager.Provider surfaceManagerProvider = Camera2DeviceSurfaceManager::new;
        UseCaseConfigFactory.Provider configFactoryProvider = context -> {
            ExtendableUseCaseConfigFactory factory = new ExtendableUseCaseConfigFactory();
            factory.installDefaultProvider(ImageAnalysisConfig.class, (ConfigProvider)new ImageAnalysisConfigProvider(context));
            factory.installDefaultProvider(ImageCaptureConfig.class, (ConfigProvider)new ImageCaptureConfigProvider(context));
            factory.installDefaultProvider(VideoCaptureConfig.class, (ConfigProvider)new VideoCaptureConfigProvider(context));
            factory.installDefaultProvider(PreviewConfig.class, (ConfigProvider)new PreviewConfigProvider(context));
            return factory;
        };
        CameraXConfig.Builder appConfigBuilder = new CameraXConfig.Builder().setCameraFactoryProvider(cameraFactoryProvider).setDeviceSurfaceManagerProvider(surfaceManagerProvider).setUseCaseConfigFactoryProvider(configFactoryProvider);
        return appConfigBuilder.build();
    }
}

