/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.content.Context;
import android.util.Log;
import android.util.Rational;
import android.view.WindowManager;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.impl.Camera2CaptureOptionUnpacker;
import androidx.camera.camera2.impl.Camera2SessionOptionUnpacker;
import androidx.camera.core.CameraFactory;
import androidx.camera.core.CameraX;
import androidx.camera.core.CaptureConfig;
import androidx.camera.core.ConfigProvider;
import androidx.camera.core.SessionConfig;
import androidx.camera.core.VideoCapture;
import androidx.camera.core.VideoCaptureConfig;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class VideoCaptureConfigProvider
implements ConfigProvider<VideoCaptureConfig> {
    private static final String TAG = "VideoCaptureProvider";
    private static final Rational DEFAULT_ASPECT_RATIO_16_9 = new Rational(16, 9);
    private static final Rational DEFAULT_ASPECT_RATIO_9_16 = new Rational(9, 16);
    private final CameraFactory mCameraFactory;
    private final WindowManager mWindowManager;

    public VideoCaptureConfigProvider(CameraFactory cameraFactory, Context context) {
        this.mCameraFactory = cameraFactory;
        this.mWindowManager = (WindowManager)context.getSystemService("window");
    }

    public VideoCaptureConfig getConfig(CameraX.LensFacing lensFacing) {
        VideoCaptureConfig.Builder builder = VideoCaptureConfig.Builder.fromConfig((VideoCaptureConfig)VideoCapture.DEFAULT_CONFIG.getConfig(lensFacing));
        SessionConfig.Builder sessionBuilder = new SessionConfig.Builder();
        sessionBuilder.setTemplateType(1);
        builder.setDefaultSessionConfig(sessionBuilder.build());
        builder.setSessionOptionUnpacker((SessionConfig.OptionUnpacker)Camera2SessionOptionUnpacker.INSTANCE);
        CaptureConfig.Builder captureBuilder = new CaptureConfig.Builder();
        captureBuilder.setTemplateType(1);
        builder.setDefaultCaptureConfig(captureBuilder.build());
        builder.setCaptureOptionUnpacker((CaptureConfig.OptionUnpacker)Camera2CaptureOptionUnpacker.INSTANCE);
        try {
            CameraX.LensFacing checkedLensFacing = lensFacing != null ? lensFacing : CameraX.getDefaultLensFacing();
            String defaultId = this.mCameraFactory.cameraIdForLensFacing(checkedLensFacing);
            if (defaultId != null) {
                builder.setLensFacing(checkedLensFacing);
            }
            int targetRotation = this.mWindowManager.getDefaultDisplay().getRotation();
            int rotationDegrees = CameraX.getCameraInfo((String)defaultId).getSensorRotationDegrees(targetRotation);
            boolean isRotateNeeded = rotationDegrees == 90 || rotationDegrees == 270;
            builder.setTargetRotation(targetRotation);
            builder.setTargetAspectRatioCustom(isRotateNeeded ? DEFAULT_ASPECT_RATIO_9_16 : DEFAULT_ASPECT_RATIO_16_9);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Unable to determine default lens facing for VideoCapture.", (Throwable)e);
        }
        return builder.build();
    }
}

