/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import android.annotation.SuppressLint;
import android.hardware.camera2.CaptureRequest;
import androidx.camera.camera2.Camera2Config;
import androidx.camera.camera2.impl.Camera2CaptureOptionUnpacker;
import androidx.camera.core.CaptureConfig;
import androidx.camera.core.Config;
import androidx.camera.core.DeviceProperties;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureConfig;
import androidx.camera.core.UseCaseConfig;

final class ImageCaptureOptionUnpacker
extends Camera2CaptureOptionUnpacker {
    static final ImageCaptureOptionUnpacker INSTANCE = new ImageCaptureOptionUnpacker();
    private DeviceProperties mDeviceProperties = DeviceProperties.create();

    ImageCaptureOptionUnpacker() {
    }

    @Override
    public void unpack(UseCaseConfig<?> config, CaptureConfig.Builder builder) {
        super.unpack(config, builder);
        if (!(config instanceof ImageCaptureConfig)) {
            throw new IllegalArgumentException("config is not ImageCaptureConfig");
        }
        ImageCaptureConfig imageCaptureConfig = (ImageCaptureConfig)config;
        Camera2Config.Builder camera2ConfigBuilder = new Camera2Config.Builder();
        this.applyPixelHdrPlusChangeForCaptureMode(imageCaptureConfig.getCaptureMode(null), camera2ConfigBuilder);
        builder.addImplementationOptions((Config)camera2ConfigBuilder.build());
    }

    void setDeviceProperty(DeviceProperties deviceProperties) {
        this.mDeviceProperties = deviceProperties;
    }

    @SuppressLint(value={"NewApi"})
    private void applyPixelHdrPlusChangeForCaptureMode(ImageCapture.CaptureMode captureMode, Camera2Config.Builder builder) {
        if ("Google".equals(this.mDeviceProperties.manufacturer()) && ("Pixel 2".equals(this.mDeviceProperties.model()) || "Pixel 3".equals(this.mDeviceProperties.model())) && this.mDeviceProperties.sdkVersion() >= 26 && captureMode != null) {
            switch (captureMode) {
                case MAX_QUALITY: {
                    builder.setCaptureRequestOption(CaptureRequest.CONTROL_ENABLE_ZSL, true);
                    break;
                }
                case MIN_LATENCY: {
                    builder.setCaptureRequestOption(CaptureRequest.CONTROL_ENABLE_ZSL, false);
                }
            }
        }
    }
}

